/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.kernel.common.apps.Entity1;

public class Test2EJBConcurrency
extends AbstractTestCase {
    private Object _id = null;

    public Test2EJBConcurrency(String name) {
        super(name, "kernelcactusapp");
    }

    public void setUp() throws Exception {
        this.deleteAll(Entity1.class);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        Entity1 b = new Entity1(3L, "STRING", 10);
        em.persist((Object)b);
        em.flush();
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testOptConcurrency1() throws Exception {
        OpenJPAEntityManager em1 = this.currentEntityManager();
        this.startTx((EntityManager)em1);
        OpenJPAEntityManager em2 = this.currentEntityManager();
        this.startTx((EntityManager)em2);
        Entity1 b1 = (Entity1)em1.find(Entity1.class, (Object)3);
        b1.setStringField("STRING2");
        this.endTx((EntityManager)em1);
        Test2EJBConcurrency.assertEquals((String)"b1.getstringField is not STRING2 as exp.", (String)"STRING2", (String)b1.getStringField());
        Entity1 b2 = (Entity1)em2.find(Entity1.class, (Object)3);
        Test2EJBConcurrency.assertEquals((String)"b2.getstringField is not STRING2 as exp.", (String)"STRING2", (String)b2.getStringField());
        b2.setStringField("STRING3");
        this.endTx((EntityManager)em2);
        Test2EJBConcurrency.assertEquals((String)"b2.getstringField is not STRING3 as exp.", (String)"STRING3", (String)b2.getStringField());
        this.startTx((EntityManager)em1);
        b1 = (Entity1)em1.find(Entity1.class, (Object)3);
        em1.refresh((Object)b1);
        Test2EJBConcurrency.assertEquals((String)"b1.getstringField is not STRING3 as exp.", (String)"STRING2", (String)b1.getStringField());
        b1.setStringField("STRING4");
        this.endTx((EntityManager)em1);
        b2 = (Entity1)em2.find(Entity1.class, (Object)3);
        Test2EJBConcurrency.assertEquals((String)"b2.getstringField is not STRING3 as exp.", (String)"STRING3", (String)b2.getStringField());
        this.endEm((EntityManager)em1);
        this.endEm((EntityManager)em2);
    }
}

