/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.kernel;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.lib.conf.ConfigurationProvider;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;

public abstract class BaseKernelTest
extends AbstractTestCase {
    private static Map _sysprops = new HashMap();

    public BaseKernelTest() {
    }

    public BaseKernelTest(String name) {
        super(name, "kernelcactusapp");
    }

    protected OpenJPAEntityManager getPM() {
        return this.currentEntityManager();
    }

    protected OpenJPAEntityManager getPM(boolean optimistic, boolean retainValues) {
        OpenJPAEntityManager em = this.currentEntityManager();
        em.setNontransactionalRead(true);
        em.setRetainState(retainValues);
        if (em.getTransaction().isActive()) {
            em.getTransaction().commit();
            em.setOptimistic(optimistic);
        }
        return em;
    }

    protected Object persist(Object ob) {
        Broker broker = JPAFacadeHelper.toBroker((EntityManager)this.currentEntityManager());
        broker.begin();
        broker.persist(ob, null);
        Object id = broker.getObjectId(ob);
        broker.commit();
        broker.close();
        return id;
    }

    protected Properties getProperties() {
        return this.getProperties(null);
    }

    protected synchronized Properties getProperties(String[] props) {
        Properties p = new Properties(System.getProperties());
        String str = p.getProperty("openjpa.properties", "kodo.properties");
        if (str != null && str.length() > 0) {
            Properties loaded = (Properties)_sysprops.get(str);
            if (loaded == null) {
                loaded = new Properties();
                ConfigurationProvider cp = (ConfigurationProvider)Configurations.getProperty((String)str, null);
                if (cp != null) {
                    loaded.putAll((Map<?, ?>)cp.getProperties());
                }
                _sysprops.put(str, loaded);
            }
            p.putAll((Map<?, ?>)loaded);
        }
        for (int i = 0; props != null && i < props.length; i += 2) {
            if (props[i + 1] != null) {
                if (props[i].startsWith("openjpa.")) {
                    p.remove("openjpa." + props[i].substring(5));
                } else if (props[i].startsWith("openjpa.")) {
                    p.remove("openjpa." + props[i].substring(8));
                }
                p.setProperty(props[i], props[i + 1]);
                continue;
            }
            p.remove(props[i]);
        }
        return p;
    }
}

