/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jpql.joins;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jpql.joins.Department;
import org.apache.openjpa.persistence.jpql.joins.Department_;
import org.apache.openjpa.persistence.jpql.joins.Employee;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;
import org.junit.Assert;

public class TestJoinFetchWithQueryDataCache
extends SQLListenerTestCase {
    EntityManager em;

    @Override
    public void setUp() {
        super.setUp(DROP_TABLES, Employee.class, Department.class, "openjpa.QueryCompilationCache", "all", "openjpa.DataCache", "true", "openjpa.RemoteCommitProvider", "sjvm", "openjpa.QueryCache", "true", "openjpa.Compatibility", "CopyOnDetach=false");
        this.em = this.emf.createEntityManager();
        this.em.getTransaction().begin();
        Department dept = new Department(10, "department 10");
        dept.setEmployees(new ArrayList<Employee>());
        dept.getEmployees().add(new Employee(11, "Emp11", dept));
        dept.getEmployees().add(new Employee(12, "Emp12", dept));
        dept.setEmployee2s(new ArrayList<Employee>());
        dept.getEmployee2s().add(new Employee(211, "Emp211", dept));
        dept.getEmployee2s().add(new Employee(212, "Emp212", dept));
        this.em.persist((Object)dept);
        dept = new Department(20, "department 20");
        dept.setEmployees(new ArrayList<Employee>());
        dept.getEmployees().add(new Employee(21, "Emp21", dept));
        dept.getEmployees().add(new Employee(22, "Emp22", dept));
        dept.setEmployee2s(new ArrayList<Employee>());
        dept.getEmployee2s().add(new Employee(221, "Emp221", dept));
        dept.getEmployee2s().add(new Employee(222, "Emp222", dept));
        this.em.persist((Object)dept);
        this.em.getTransaction().commit();
        this.em.close();
    }

    public void testJPQLNoFetch() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        List ds = em.createQuery("SELECT DISTINCT d FROM Department d WHERE d.deptno = 10").getResultList();
        System.out.println("-- testJPQLNoFetch -----");
        em.clear();
        Assert.assertEquals((long)1L, (long)ds.size());
        for (Department x : ds) {
            Assert.assertNull(x.getEmployees());
            Assert.assertNull(x.getEmployee2s());
            System.out.println(x);
        }
        em.close();
    }

    public void testJPQLOneFetch() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        List ds = em.createQuery("SELECT DISTINCT d FROM Department d LEFT JOIN FETCH d.employee2s WHERE d.deptno = 10").getResultList();
        System.out.println("-- testJPQLOneFetch -----");
        em.clear();
        Assert.assertEquals((long)1L, (long)ds.size());
        for (Department x : ds) {
            Assert.assertNull(x.getEmployees());
            Assert.assertNotNull(x.getEmployee2s());
            Assert.assertEquals((long)2L, (long)x.getEmployee2s().size());
            System.out.println(x);
        }
        em.close();
    }

    public void testJPQLTwoFetch() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        List ds = em.createQuery("SELECT DISTINCT d FROM Department d LEFT JOIN FETCH d.employees LEFT JOIN FETCH d.employee2s WHERE d.deptno = 10").getResultList();
        System.out.println("-- testJPQLTwoFetch -----");
        em.clear();
        Assert.assertEquals((long)1L, (long)ds.size());
        for (Department x : ds) {
            Assert.assertNotNull(x.getEmployees());
            Assert.assertEquals((long)2L, (long)x.getEmployees().size());
            Assert.assertNotNull(x.getEmployee2s());
            Assert.assertEquals((long)2L, (long)x.getEmployee2s().size());
            System.out.println(x);
        }
        em.close();
    }

    public void testCriteriaAPINoFetch() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery(Department.class);
        Root d = q.from(Department.class);
        q.where((Expression)cb.equal((Expression)d.get(Department_.deptno), (Object)20)).select((Selection)d);
        List ds = em.createQuery(q).getResultList();
        System.out.println("-- testCriteriaAPINoFetch -----");
        em.clear();
        Assert.assertEquals((long)1L, (long)ds.size());
        for (Department x : ds) {
            Assert.assertNull(x.getEmployees());
            Assert.assertNull(x.getEmployee2s());
            System.out.println(x);
        }
        em.close();
    }

    public void testCriteriaAPIOneFetch() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery(Department.class);
        Root d = q.from(Department.class);
        d.fetch(Department_.employees, JoinType.LEFT);
        q.where((Expression)cb.equal((Expression)d.get(Department_.deptno), (Object)20)).select((Selection)d).distinct(true);
        List ds = em.createQuery(q).getResultList();
        System.out.println("-- testCriteriaAPIOneFetch -----");
        em.clear();
        Assert.assertEquals((long)1L, (long)ds.size());
        for (Department x : ds) {
            Assert.assertNotNull(x.getEmployees());
            Assert.assertEquals((long)2L, (long)x.getEmployees().size());
            Assert.assertNull(x.getEmployee2s());
            System.out.println(x);
        }
        em.close();
    }

    public void testCriteriaAPITwoFetch() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery(Department.class);
        Root d = q.from(Department.class);
        d.fetch(Department_.employees, JoinType.LEFT);
        d.fetch(Department_.employee2s, JoinType.LEFT);
        q.where((Expression)cb.equal((Expression)d.get(Department_.deptno), (Object)20)).select((Selection)d).distinct(true);
        List ds = em.createQuery(q).getResultList();
        System.out.println("-- testCriteriaAPITwoFetch -----");
        em.clear();
        Assert.assertEquals((long)1L, (long)ds.size());
        for (Department x : ds) {
            Assert.assertNotNull(x.getEmployees());
            Assert.assertEquals((long)2L, (long)x.getEmployees().size());
            Assert.assertNotNull(x.getEmployee2s());
            Assert.assertEquals((long)2L, (long)x.getEmployee2s().size());
            System.out.println(x);
        }
        em.close();
    }

    public void testConsecutiveJPQLJoinFetchCall() {
        this.doQuery((EntityManagerFactory)this.emf, false);
        this.doQuery((EntityManagerFactory)this.emf, true);
    }

    private void doQuery(EntityManagerFactory emf, boolean cached) {
        String query = "select o from Employee o left join fetch o.dept where o.dept.deptno = 10";
        EntityManager em = emf.createEntityManager();
        this.sql.clear();
        List emps = em.createQuery(query, Employee.class).getResultList();
        Assert.assertEquals((long)4L, (long)emps.size());
        for (Employee emp : emps) {
            em.detach((Object)emp);
            Assert.assertNotNull((Object)emp.getDept());
            Assert.assertEquals((long)2L, (long)emp.getDept().getEmployees().size());
        }
        em.close();
        if (cached) {
            TestJoinFetchWithQueryDataCache.assertTrue((this.sql.size() == 0 ? 1 : 0) != 0);
        }
    }
}

