/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jpql.functions;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.OracleDictionary;
import org.apache.openjpa.jdbc.sql.SybaseDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.common.apps.Address;
import org.apache.openjpa.persistence.common.apps.CompUser;
import org.apache.openjpa.persistence.common.apps.FemaleUser;
import org.apache.openjpa.persistence.common.apps.MaleUser;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;

public class TestEJBQLFunction
extends AbstractTestCase {
    private int userid1;
    private int userid2;
    private int userid3;
    private int userid4;
    private int userid5;
    private int userid6;
    private String expectedShannonName = "Shannon ";

    public TestEJBQLFunction(String name) {
        super(name, "jpqlclausescactusapp");
    }

    public void setUp() {
        this.deleteAll(CompUser.class);
        OpenJPAEntityManagerSPI em = (OpenJPAEntityManagerSPI)this.currentEntityManager();
        this.startTx((EntityManager)em);
        Address[] add = new Address[]{new Address("43 Sansome", "SF", "United-Kingdom", "94104"), new Address("24 Mink", "ANTIOCH", "USA", "94513"), new Address("23 Ogbete", "CoalCamp", "NIGERIA", "00000"), new Address("10 Wilshire", "Worcester", "CANADA", "80080"), new Address("23 Bellflower", "Ogui", null, "02000"), new Address("22 Montgomery", "SF", null, "50054")};
        CompUser user1 = this.createUser("Seetha", "MAC", add[0], 36, true);
        CompUser user2 = this.createUser("Shannon ", "PC", add[1], 36, false);
        CompUser user3 = this.createUser("Ugo", "PC", add[2], 19, true);
        CompUser user4 = this.createUser("_Jacob", "LINUX", add[3], 10, true);
        CompUser user5 = this.createUser("Famzy", "UNIX", add[4], 29, false);
        CompUser user6 = this.createUser("Shade", "UNIX", add[5], 23, false);
        em.persist((Object)user1);
        this.userid1 = user1.getUserid();
        em.persist((Object)user2);
        this.userid2 = user2.getUserid();
        em.persist((Object)user3);
        this.userid3 = user3.getUserid();
        em.persist((Object)user4);
        this.userid4 = user4.getUserid();
        em.persist((Object)user5);
        this.userid5 = user5.getUserid();
        em.persist((Object)user6);
        this.userid6 = user6.getUserid();
        DBDictionary dict = ((JDBCConfiguration)em.getConfiguration()).getDBDictionaryInstance();
        if (dict instanceof SybaseDictionary) {
            this.expectedShannonName = "Shannon";
        }
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testConcatSubStringFunc() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        CompUser user = (CompUser)em.find(CompUser.class, (Object)this.userid1);
        TestEJBQLFunction.assertNotNull((String)"user is null", (Object)user);
        TestEJBQLFunction.assertEquals((String)"the name is not seetha", (String)"Seetha", (String)user.getName());
        String query = "UPDATE CompUser e SET e.name = CONCAT('Ablahum', SUBSTRING(e.name, LOCATE('e', e.name), 4)) WHERE e.name='Seetha'";
        int result = em.createQuery(query).executeUpdate();
        TestEJBQLFunction.assertEquals((String)"the result is not 1", (int)1, (int)result);
        user = (CompUser)em.find(CompUser.class, (Object)this.userid1);
        em.refresh((Object)user);
        TestEJBQLFunction.assertNotNull((String)"the user is null", (Object)user);
        TestEJBQLFunction.assertEquals((String)"the users name is not Ablahumeeth", (String)"Ablahumeeth", (String)user.getName());
        query = "UPDATE CompUser e SET e.name = CONCAT('XYZ', SUBSTRING(e.name, LOCATE('e', e.name))) WHERE e.name='Ablahumeeth'";
        result = em.createQuery(query).executeUpdate();
        TestEJBQLFunction.assertEquals((String)"the result is not 1", (int)1, (int)result);
        user = (CompUser)em.find(CompUser.class, (Object)this.userid1);
        em.refresh((Object)user);
        TestEJBQLFunction.assertNotNull((String)"the user is null", (Object)user);
        TestEJBQLFunction.assertEquals((String)"the users name is not XYZeeth", (String)"XYZeeth", (String)user.getName());
        query = "UPDATE CompUser e SET e.name = CONCAT('CAD', SUBSTRING(e.name, LOCATE('e', e.name, 5))) WHERE e.name='XYZeeth'";
        result = em.createQuery(query).executeUpdate();
        TestEJBQLFunction.assertEquals((String)"the result is not 1", (int)1, (int)result);
        user = (CompUser)em.find(CompUser.class, (Object)this.userid1);
        em.refresh((Object)user);
        TestEJBQLFunction.assertNotNull((String)"the user is null", (Object)user);
        TestEJBQLFunction.assertEquals((String)"the users name is not CADeth", (String)"CADeth", (String)user.getName());
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testConcatFunc2() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        CompUser user = (CompUser)em.find(CompUser.class, (Object)this.userid1);
        TestEJBQLFunction.assertNotNull((String)"the user is null", (Object)user);
        TestEJBQLFunction.assertEquals((String)"the users name is not seetha", (String)user.getName(), (String)"Seetha");
        String query = "UPDATE CompUser e SET e.name = CONCAT('', '') WHERE e.name='Seetha'";
        int result = em.createQuery(query).executeUpdate();
        TestEJBQLFunction.assertEquals((int)1, (int)result);
        user = (CompUser)em.find(CompUser.class, (Object)this.userid1);
        em.refresh((Object)user);
        TestEJBQLFunction.assertNotNull((Object)user);
        DBDictionary dict = ((JDBCConfiguration)this.getEmf().getConfiguration()).getDBDictionaryInstance();
        if (dict instanceof OracleDictionary) {
            TestEJBQLFunction.assertTrue((user.getName() == null || "".equals(user.getName()) ? 1 : 0) != 0);
        } else if (dict instanceof SybaseDictionary) {
            TestEJBQLFunction.assertEquals((String)" ", (String)user.getName());
        } else {
            TestEJBQLFunction.assertEquals((String)"", (String)user.getName());
        }
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testTrimFunc3() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        CompUser user = (CompUser)em.find(CompUser.class, (Object)this.userid2);
        TestEJBQLFunction.assertNotNull((Object)user);
        TestEJBQLFunction.assertEquals((String)this.expectedShannonName, (String)user.getName());
        String query = "UPDATE CompUser e SET e.name = Trim(e.name) WHERE e.name='Shannon '";
        int result = em.createQuery(query).executeUpdate();
        user = (CompUser)em.find(CompUser.class, (Object)this.userid2);
        em.refresh((Object)user);
        TestEJBQLFunction.assertNotNull((Object)user);
        TestEJBQLFunction.assertEquals((String)"Shannon", (String)user.getName());
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testLowerFunc() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        CompUser user = (CompUser)em.find(CompUser.class, (Object)this.userid3);
        TestEJBQLFunction.assertNotNull((Object)user);
        TestEJBQLFunction.assertEquals((String)"Ugo", (String)user.getName());
        String query = "UPDATE CompUser e SET e.name = LOWER(e.name) WHERE e.name='Ugo'";
        int result = em.createQuery(query).executeUpdate();
        user = (CompUser)em.find(CompUser.class, (Object)this.userid3);
        em.refresh((Object)user);
        TestEJBQLFunction.assertNotNull((Object)user);
        TestEJBQLFunction.assertEquals((String)"ugo", (String)user.getName());
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testLowerClobFunc() {
        OpenJPAEntityManagerSPI em = (OpenJPAEntityManagerSPI)this.currentEntityManager();
        DBDictionary dict = ((JDBCConfiguration)em.getConfiguration()).getDBDictionaryInstance();
        if (!dict.supportsCaseConversionForLob) {
            return;
        }
        this.startTx((EntityManager)em);
        CompUser user = (CompUser)em.find(CompUser.class, (Object)this.userid5);
        TestEJBQLFunction.assertNotNull((Object)user);
        TestEJBQLFunction.assertEquals((String)"Famzy", (String)user.getName());
        String query = "UPDATE CompUser e SET e.name = LOWER(e.name) WHERE LOWER(e.nameAsLob)='famzy'";
        int result = em.createQuery(query).executeUpdate();
        user = (CompUser)em.find(CompUser.class, (Object)this.userid5);
        em.refresh((Object)user);
        TestEJBQLFunction.assertNotNull((Object)user);
        TestEJBQLFunction.assertEquals((String)"famzy", (String)user.getName());
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testUpperFunc() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        CompUser user = (CompUser)em.find(CompUser.class, (Object)this.userid3);
        TestEJBQLFunction.assertNotNull((Object)user);
        TestEJBQLFunction.assertEquals((String)"Ugo", (String)user.getName());
        String query = "UPDATE CompUser e SET e.name = UPPER(e.name) WHERE e.name='Ugo'";
        int result = em.createQuery(query).executeUpdate();
        user = (CompUser)em.find(CompUser.class, (Object)this.userid3);
        em.refresh((Object)user);
        TestEJBQLFunction.assertNotNull((Object)user);
        TestEJBQLFunction.assertEquals((String)"UGO", (String)user.getName());
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testUpperClobFunc() {
        OpenJPAEntityManagerSPI em = (OpenJPAEntityManagerSPI)this.currentEntityManager();
        DBDictionary dict = ((JDBCConfiguration)em.getConfiguration()).getDBDictionaryInstance();
        if (!dict.supportsCaseConversionForLob) {
            return;
        }
        this.startTx((EntityManager)em);
        CompUser user = (CompUser)em.find(CompUser.class, (Object)this.userid5);
        TestEJBQLFunction.assertNotNull((Object)user);
        TestEJBQLFunction.assertEquals((String)"Famzy", (String)user.getName());
        String query = "UPDATE CompUser e SET e.name = UPPER(e.name) WHERE UPPER(e.nameAsLob)='FAMZY'";
        int result = em.createQuery(query).executeUpdate();
        user = (CompUser)em.find(CompUser.class, (Object)this.userid5);
        em.refresh((Object)user);
        TestEJBQLFunction.assertNotNull((Object)user);
        TestEJBQLFunction.assertEquals((String)"FAMZY", (String)user.getName());
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testLengthFunc() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT o.name FROM CompUser o WHERE LENGTH(o.address.country) = 3";
        List result = em.createQuery(query).getResultList();
        TestEJBQLFunction.assertNotNull((Object)result);
        TestEJBQLFunction.assertEquals((int)1, (int)result.size());
        TestEJBQLFunction.assertTrue((boolean)result.contains(this.expectedShannonName));
        this.endEm((EntityManager)em);
    }

    public void testArithmFunc() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        CompUser user = (CompUser)em.find(CompUser.class, (Object)this.userid1);
        TestEJBQLFunction.assertNotNull((Object)user);
        TestEJBQLFunction.assertEquals((String)"Seetha", (String)user.getName());
        TestEJBQLFunction.assertEquals((int)36, (int)user.getAge());
        String query = "UPDATE CompUser e SET e.age = ABS(e.age) WHERE e.name='Seetha'";
        int num = em.createQuery(query).executeUpdate();
        TestEJBQLFunction.assertNotNull((Object)num);
        TestEJBQLFunction.assertEquals((int)1, (int)num);
        user = (CompUser)em.find(CompUser.class, (Object)this.userid1);
        em.refresh((Object)user);
        TestEJBQLFunction.assertEquals((int)36, (int)user.getAge());
        query = "UPDATE CompUser e SET e.age = SQRT(e.age) WHERE e.name='Seetha'";
        num = em.createQuery(query).executeUpdate();
        TestEJBQLFunction.assertNotNull((Object)num);
        TestEJBQLFunction.assertEquals((int)1, (int)num);
        user = (CompUser)em.find(CompUser.class, (Object)this.userid1);
        em.refresh((Object)user);
        TestEJBQLFunction.assertEquals((int)6, (int)user.getAge());
        query = "UPDATE CompUser e SET e.age = MOD(e.age, 4) WHERE e.name='Seetha'";
        num = em.createQuery(query).executeUpdate();
        TestEJBQLFunction.assertNotNull((Object)num);
        TestEJBQLFunction.assertEquals((int)1, (int)num);
        user = (CompUser)em.find(CompUser.class, (Object)this.userid1);
        em.refresh((Object)user);
        TestEJBQLFunction.assertEquals((int)2, (int)user.getAge());
        query = "SELECT e.name FROM CompUser e WHERE SIZE(e.nicknames) = 6";
        List result = em.createQuery(query).getResultList();
        TestEJBQLFunction.assertNotNull((Object)result);
        TestEJBQLFunction.assertEquals((int)0, (int)result.size());
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testGroupByHavingClause() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT c.name FROM CompUser c GROUP BY c.name HAVING c.name LIKE 'S%'";
        List result = em.createQuery(query).getResultList();
        TestEJBQLFunction.assertNotNull((Object)result);
        TestEJBQLFunction.assertEquals((int)3, (int)result.size());
        TestEJBQLFunction.assertTrue((boolean)result.contains(this.expectedShannonName));
        TestEJBQLFunction.assertTrue((boolean)result.contains("Shade"));
        TestEJBQLFunction.assertTrue((boolean)result.contains("Seetha"));
        this.endEm((EntityManager)em);
    }

    public void testOrderByClause() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT c.name FROM CompUser c WHERE c.name LIKE 'S%' ORDER BY c.name";
        List result = em.createQuery(query).getResultList();
        TestEJBQLFunction.assertNotNull((Object)result);
        TestEJBQLFunction.assertEquals((int)3, (int)result.size());
        TestEJBQLFunction.assertTrue((boolean)result.contains(this.expectedShannonName));
        TestEJBQLFunction.assertTrue((boolean)result.contains("Seetha"));
        TestEJBQLFunction.assertTrue((boolean)result.contains("Shade"));
        this.endEm((EntityManager)em);
    }

    public void testAVGAggregFunc() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT AVG(e.age) FROM CompUser e";
        List result = em.createQuery(query).getResultList();
        TestEJBQLFunction.assertNotNull((Object)result);
        TestEJBQLFunction.assertEquals((int)1, (int)result.size());
        TestEJBQLFunction.assertTrue((boolean)result.contains(25));
        this.endEm((EntityManager)em);
    }

    public void testCOUNTAggregFunc() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT COUNT(c.name) FROM CompUser c";
        List result = em.createQuery(query).getResultList();
        TestEJBQLFunction.assertNotNull((Object)result);
        TestEJBQLFunction.assertEquals((int)1, (int)result.size());
        TestEJBQLFunction.assertTrue((boolean)result.contains(6L));
        this.endEm((EntityManager)em);
    }

    public void testMAXAggregFunc() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT DISTINCT MAX(c.age) FROM CompUser c";
        List result = em.createQuery(query).getResultList();
        TestEJBQLFunction.assertNotNull((Object)result);
        TestEJBQLFunction.assertEquals((int)1, (int)result.size());
        TestEJBQLFunction.assertTrue((boolean)result.contains(36));
        this.endEm((EntityManager)em);
    }

    public void testMINAggregFunc() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT DISTINCT MIN(c.age) FROM CompUser c";
        List result = em.createQuery(query).getResultList();
        TestEJBQLFunction.assertNotNull((Object)result);
        TestEJBQLFunction.assertEquals((int)1, (int)result.size());
        TestEJBQLFunction.assertTrue((boolean)result.contains(10));
        this.endEm((EntityManager)em);
    }

    public void testSUMAggregFunc() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT SUM(c.age) FROM CompUser c";
        List result = em.createQuery(query).getResultList();
        TestEJBQLFunction.assertNotNull((Object)result);
        TestEJBQLFunction.assertEquals((int)1, (int)result.size());
        TestEJBQLFunction.assertTrue((boolean)result.contains(153L));
        this.endEm((EntityManager)em);
    }

    public CompUser createUser(String name, String cName, Address add, int age, boolean isMale) {
        CompUser user = null;
        if (isMale) {
            user = new MaleUser();
            user.setName(name);
            user.setComputerName(cName);
            user.setAddress(add);
            user.setAge(age);
            user.setNameAsLob(name);
        } else {
            user = new FemaleUser();
            user.setName(name);
            user.setComputerName(cName);
            user.setAddress(add);
            user.setAge(age);
            user.setNameAsLob(name);
        }
        return user;
    }
}

