/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jpql.expressions;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.Query;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jpql.entities.IColumnEntity;
import org.apache.openjpa.persistence.jpql.entities.INameEntity;
import org.apache.openjpa.persistence.jpql.entities.IOrderedElements;
import org.apache.openjpa.persistence.jpql.entities.IOrderedEntity;
import org.apache.openjpa.persistence.jpql.entities.OrderedElementEntity;
import org.apache.openjpa.persistence.jpql.entities.OrderedManyToManyEntity;
import org.apache.openjpa.persistence.jpql.entities.OrderedNameEntity;
import org.apache.openjpa.persistence.jpql.entities.OrderedOneToManyEntity;
import org.apache.openjpa.persistence.jpql.entities.UnorderedNameEntity;
import org.apache.openjpa.persistence.jpql.entities.XMLOrderedElementEntity;
import org.apache.openjpa.persistence.jpql.entities.XMLOrderedManyToManyEntity;
import org.apache.openjpa.persistence.jpql.entities.XMLOrderedNameEntity;
import org.apache.openjpa.persistence.jpql.entities.XMLOrderedOneToManyEntity;
import org.apache.openjpa.persistence.jpql.entities.XMLUnorderedNameEntity;
import org.apache.openjpa.persistence.proxy.TreeNode;
import org.apache.openjpa.persistence.test.JPAEntityClassEnum;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestIndex
extends SingleEMFTestCase {
    private Log log = null;
    private static final String[] Element_Names = new String[]{"A_Element", "B_Element", "C_Element", "D_Element", "E_Element", "F_Element"};

    @Override
    protected String getPersistenceUnitName() {
        return "JPQLIndex";
    }

    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES, TreeNode.class, OrderedElementEntity.class, UnorderedNameEntity.class, OrderedOneToManyEntity.class, OrderedManyToManyEntity.class, OrderedNameEntity.class);
        this.log = this.emf.getConfiguration().getLog("test");
    }

    public void testO2MTreeQueryIndex() {
        int[] fanOuts = new int[]{2, 3, 4};
        this.createTreeNodeEntities(fanOuts);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String query = "SELECT index(c) from TreeNode t, in (t.childern) c WHERE index(c) = 2";
        List rs = em.createQuery(query).getResultList();
        for (Object t : rs) {
            TestIndex.assertEquals((int)2, (int)Integer.parseInt(t.toString()));
        }
        em.close();
    }

    public void testO2MQueryIndex() {
        this.createEntities(JPQLIndexEntityClasses.OrderedOneToManyEntity, UnorderedNameEntity.class);
        this.verifyEntities(JPQLIndexEntityClasses.OrderedOneToManyEntity, UnorderedNameEntity.class);
    }

    public void testO2MXMLQueryIndex() {
        this.createEntities(JPQLIndexEntityClasses.XMLOrderedOneToManyEntity, XMLUnorderedNameEntity.class);
        this.verifyEntities(JPQLIndexEntityClasses.XMLOrderedOneToManyEntity, XMLUnorderedNameEntity.class);
    }

    public void testM2MQueryIndex() {
        this.createEntities(JPQLIndexEntityClasses.OrderedManyToManyEntity, OrderedNameEntity.class);
        this.verifyEntities(JPQLIndexEntityClasses.OrderedManyToManyEntity, OrderedNameEntity.class);
    }

    public void testM2MXMLQueryIndex() {
        this.createEntities(JPQLIndexEntityClasses.OrderedManyToManyEntity, XMLOrderedNameEntity.class);
        this.verifyEntities(JPQLIndexEntityClasses.OrderedManyToManyEntity, XMLOrderedNameEntity.class);
    }

    public void testElementQueryIndex() {
        this.createEntities(JPQLIndexEntityClasses.OrderedElementEntity, String.class);
        this.verifyEntities(JPQLIndexEntityClasses.OrderedElementEntity, String.class);
    }

    public void testElementXMLQueryIndex() {
        this.createEntities(JPQLIndexEntityClasses.XMLOrderedElementEntity, String.class);
        this.verifyEntities(JPQLIndexEntityClasses.XMLOrderedElementEntity, String.class);
    }

    private TreeNode createTreeNodeEntities(int[] original) {
        TreeNode root = new TreeNode();
        root.createTree(original);
        this.assertArrayEquals(original, root.getFanOuts());
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)root);
        em.getTransaction().commit();
        em.clear();
        return root;
    }

    private void assertArrayEquals(int[] a, int[] b) {
        TestIndex.assertEquals((int)a.length, (int)b.length);
        for (int i = 0; i < a.length; ++i) {
            TestIndex.assertEquals((int)a[i], (int)b[i]);
        }
    }

    private <C, E> void createEntities(JPQLIndexEntityClasses entityType, Class<E> elementClass) {
        if (IOrderedEntity.class.isAssignableFrom(entityType.getEntityClass())) {
            if (INameEntity.class.isAssignableFrom(elementClass)) {
                this.log.trace((Object)"** Test INameEntity modifications on IOrderedEntity.");
                this.createO2MEntities(entityType, elementClass);
            } else if (IColumnEntity.class.isAssignableFrom(elementClass)) {
                this.log.trace((Object)"** Test IColumnEntity modifications on IOrderedEntity.");
                this.createM2MEntities(entityType, elementClass);
            } else {
                TestIndex.fail((String)("createEntities(IOrderedEntity) - Unexpected elementClass=" + elementClass.getSimpleName()));
            }
        } else if (IOrderedElements.class.isAssignableFrom(entityType.getEntityClass())) {
            if (String.class.isAssignableFrom(elementClass)) {
                this.log.trace((Object)"** Test String modifications on IOrderedElements.");
                this.createOrderedElements(entityType);
            } else {
                TestIndex.fail((String)("createEntities(IOrderedElements) - Unexpected elementClass=" + elementClass.getSimpleName()));
            }
        } else {
            TestIndex.fail((String)("createEntities() - Unexpected entityType=" + entityType.getEntityName()));
        }
    }

    private void createO2MEntities(JPQLIndexEntityClasses entityType, Class<INameEntity> elementClass) {
        OpenJPAEntityManagerSPI em = null;
        try {
            Class<?> entityClass = Class.forName(entityType.getEntityClassName());
            String entityClassName = entityType.getEntityName();
            String elementClassName = elementClass.getName().substring(elementClass.getName().lastIndexOf(46) + 1);
            Integer entityId = 1;
            IOrderedEntity newEntity = (IOrderedEntity)this.constructNewEntityObject(entityType);
            newEntity.setId(entityId);
            Constructor<INameEntity> elementConstrctor = elementClass.getConstructor(String.class);
            ArrayList<INameEntity> newElements = new ArrayList<INameEntity>();
            for (String element_name : Element_Names) {
                newElements.add(elementConstrctor.newInstance(element_name));
            }
            em = this.emf.createEntityManager();
            em.getTransaction().begin();
            for (INameEntity newElement : newElements) {
                em.persist((Object)newElement);
                newEntity.addEntity(newElement);
            }
            em.persist((Object)newEntity);
            em.getTransaction().commit();
            em.clear();
            IOrderedEntity findEntity = (IOrderedEntity)em.find(entityClass, (Object)entityId);
            TestIndex.assertNotNull((String)"Found entity just created", (Object)findEntity);
            TestIndex.assertEquals((String)("Verify entity id = " + entityId), (int)entityId, (int)findEntity.getId());
            TestIndex.assertEquals((String)("Verify entity name = " + entityClass.getName()), (String)entityClass.getName(), (String)findEntity.getClass().getName());
        }
        catch (Throwable t) {
            this.log.error((Object)t);
            throw new RuntimeException(t);
        }
        finally {
            if (em != null) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
                em = null;
            }
        }
    }

    private void createM2MEntities(JPQLIndexEntityClasses entityType, Class<IColumnEntity> elementClass) {
        OpenJPAEntityManagerSPI em = null;
        try {
            Class<?> entityClass = Class.forName(entityType.getEntityClassName());
            String entityClassName = entityType.getEntityName();
            String elementClassName = elementClass.getName().substring(elementClass.getName().lastIndexOf(46) + 1);
            em = this.emf.createEntityManager();
            em.getTransaction().begin();
            ArrayList<IOrderedEntity> newEntities = new ArrayList<IOrderedEntity>();
            for (int i = 0; i < 3; ++i) {
                IOrderedEntity newEntity = (IOrderedEntity)this.constructNewEntityObject(entityType);
                newEntity.setId(i);
                em.persist((Object)newEntity);
                newEntities.add(newEntity);
            }
            Constructor<IColumnEntity> elementConstrctor = elementClass.getConstructor(String.class);
            ArrayList<INameEntity> newElements = new ArrayList<INameEntity>();
            for (String element_name : Element_Names) {
                IColumnEntity newElement = elementConstrctor.newInstance(element_name);
                newElement.setEntities(newEntities);
                em.persist((Object)newElement);
                newElements.add(newElement);
            }
            for (IOrderedEntity newEntity : newEntities) {
                newEntity.setEntities(newElements);
                em.persist((Object)newEntity);
            }
            em.getTransaction().commit();
            em.clear();
            for (int i = 0; i < Element_Names.length; ++i) {
                IOrderedEntity findEntity = (IOrderedEntity)em.find(entityClass, (Object)i);
                TestIndex.assertNotNull((String)"Found entity just created", (Object)findEntity);
                TestIndex.assertEquals((String)("Verify entity id = " + i), (int)i, (int)findEntity.getId());
                TestIndex.assertEquals((String)("Verify entity name = " + entityClass.getName()), (String)entityClass.getName(), (String)findEntity.getClass().getName());
            }
        }
        catch (Throwable t) {
            this.log.error((Object)t);
            throw new RuntimeException(t);
        }
        finally {
            if (em != null) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
                em = null;
            }
        }
    }

    private void createOrderedElements(JPQLIndexEntityClasses entityType) {
        OpenJPAEntityManagerSPI em = null;
        try {
            Class<?> entityClass = Class.forName(entityType.getEntityClassName());
            String entityClassName = entityType.getEntityName();
            Integer entityId = 1;
            IOrderedElements newEntity = (IOrderedElements)this.constructNewEntityObject(entityType);
            newEntity.setId(entityId);
            ArrayList<String> namesList = new ArrayList<String>();
            for (String element_name : Element_Names) {
                namesList.add(element_name);
            }
            newEntity.setListElements(namesList);
            em = this.emf.createEntityManager();
            em.getTransaction().begin();
            em.persist((Object)newEntity);
            em.getTransaction().commit();
            em.clear();
            this.log.trace((Object)"Verifing the entity was stored");
            IOrderedElements findEntity = (IOrderedElements)em.find(entityClass, (Object)entityId);
            TestIndex.assertNotNull((String)"Found entity just created", (Object)findEntity);
            TestIndex.assertEquals((String)("Verify entity id = " + entityId), (int)entityId, (int)findEntity.getId());
            TestIndex.assertEquals((String)("Verify entity name = " + entityClass.getName()), (String)entityClass.getName(), (String)findEntity.getClass().getName());
        }
        catch (Throwable t) {
            this.log.error((Object)t);
            throw new RuntimeException(t);
        }
        finally {
            if (em != null) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
                em = null;
            }
        }
    }

    private <C, E> void verifyEntities(JPQLIndexEntityClasses entityType, Class<E> elementClass) {
        if (IOrderedEntity.class.isAssignableFrom(entityType.getEntityClass())) {
            if (INameEntity.class.isAssignableFrom(elementClass)) {
                this.log.trace((Object)"** Verify INameEntity modifications on IOrderedEntity.");
                this.verifyO2MEntities(entityType, elementClass);
            } else if (IColumnEntity.class.isAssignableFrom(elementClass)) {
                this.log.trace((Object)"** Verify IColumnEntity modifications on IOrderedEntity.");
                this.verifyM2MEntities(entityType, elementClass);
            } else {
                TestIndex.fail((String)("verifyEntities(IOrderedEntity) - Unexpected elementClass=" + elementClass.getSimpleName()));
            }
        } else if (IOrderedElements.class.isAssignableFrom(entityType.getEntityClass())) {
            if (String.class.isAssignableFrom(elementClass)) {
                this.log.trace((Object)"** Test String modifications on IOrderedElements.");
                this.verifyOrderedElements(entityType);
            } else {
                TestIndex.fail((String)("verifyEntities(IOrderedElements) - Unexpected elementClass=" + elementClass.getSimpleName()));
            }
        } else {
            TestIndex.fail((String)("verifyEntities() - Unexpected entityType=" + entityType.getEntityName()));
        }
    }

    private <E> void verifyO2MEntities(JPQLIndexEntityClasses entityType, Class<INameEntity> elementClass) {
        OpenJPAEntityManagerSPI em = null;
        try {
            Class<?> entityClass = Class.forName(entityType.getEntityClassName());
            String entityClassName = entityType.getEntityName();
            entityClassName = entityClassName.substring(entityClassName.lastIndexOf(46) + 1);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Query " + entityClassName + " and verify 'entities' collection has " + Element_Names.length + " elements in this order: " + Arrays.toString(Element_Names)));
            }
            em = this.emf.createEntityManager();
            em.clear();
            int idx = 0;
            for (String expectedEntityName : Element_Names) {
                Query q = em.createQuery("select w from " + entityClassName + " o join o.entities w where index(w) = " + idx);
                List res = q.getResultList();
                TestIndex.assertEquals((String)("  Verify query returns 1 element for index " + idx), (int)1, (int)res.size());
                if (res.size() == 1) {
                    Object oo = res.get(0);
                    TestIndex.assertEquals((String)("  Verify element type is " + elementClass.getName()), (String)elementClass.getName(), (String)oo.getClass().getName());
                    try {
                        String name = (String)elementClass.getMethod("getName", new Class[0]).invoke(oo, new Object[0]);
                        TestIndex.assertEquals((String)("  Verify element value is '" + expectedEntityName + "'"), (String)expectedEntityName, (String)name);
                    }
                    catch (Exception e) {
                        this.log.error((Object)("  Caught unexpected exception:" + e.getMessage()));
                        throw new RuntimeException(e);
                    }
                }
                ++idx;
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new RuntimeException(e);
        }
        finally {
            if (em != null) {
                em.close();
                em = null;
            }
        }
    }

    private <E> void verifyM2MEntities(JPQLIndexEntityClasses entityType, Class<IColumnEntity> elementClass) {
        OpenJPAEntityManagerSPI em = null;
        try {
            Class<?> entityClass = Class.forName(entityType.getEntityClassName());
            String entityClassName = entityType.getEntityName();
            entityClassName = entityClassName.substring(entityClassName.lastIndexOf(46) + 1);
            String elementClassName = entityType.getEntityName();
            elementClassName = elementClassName.substring(elementClassName.lastIndexOf(46) + 1);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Query " + entityClassName + " and verify 'entities' collection has " + Element_Names.length + " elements in this order: " + Arrays.toString(Element_Names)));
            }
            em = this.emf.createEntityManager();
            em.clear();
            int idx = 0;
            int idx2 = 0;
            for (String expectedEntityName : Element_Names) {
                block14: {
                    Query q = em.createQuery("select w from " + entityClassName + " o join o.entities w where index(w) = " + idx);
                    List res = q.getResultList();
                    TestIndex.assertEquals((String)("  Verify query returns 1 element for index " + idx), (int)1, (int)res.size());
                    if (res.size() == 1) {
                        Object oo = res.get(0);
                        TestIndex.assertEquals((String)("  Verify element type is " + elementClass.getName()), (String)elementClass.getName(), (String)oo.getClass().getName());
                        try {
                            String name = (String)elementClass.getMethod("getName", new Class[0]).invoke(oo, new Object[0]);
                            TestIndex.assertEquals((String)("  Verify element value is '" + expectedEntityName + "'"), (String)expectedEntityName, (String)name);
                            if (this.log.isTraceEnabled()) {
                                this.log.trace((Object)("Query " + elementClassName + " and verify 'entities' collection content"));
                            }
                            Query q2 = em.createQuery("select w from " + elementClassName + " o join o.entities w where index(w) = " + idx2);
                            List res2 = q.getResultList();
                            TestIndex.assertEquals((String)("  Verify query returns 1 entity for index " + idx2), (int)1, (int)res2.size());
                            if (res2.size() != 1) break block14;
                            Object oo2 = res2.get(0);
                            TestIndex.assertEquals((String)("  Verify entity type is " + entityClass.getName()), (String)entityClass.getName(), (String)oo2.getClass().getName());
                            try {
                                String name2 = (String)entityClass.getMethod("getName", new Class[0]).invoke(oo2, new Object[0]);
                                TestIndex.assertEquals((String)("  Verify entity value is '" + expectedEntityName + "'"), (String)expectedEntityName, (String)name);
                            }
                            catch (Exception e) {
                                this.log.error((Object)("  Caught unexpected exception:" + e.getMessage()));
                                throw new RuntimeException(e);
                            }
                        }
                        catch (Exception e) {
                            this.log.error((Object)("  Caught unexpected exception:" + e.getMessage()));
                            throw new RuntimeException(e);
                        }
                    }
                }
                ++idx;
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new RuntimeException(e);
        }
        finally {
            if (em != null) {
                em.close();
                em = null;
            }
        }
    }

    private <E> void verifyOrderedElements(JPQLIndexEntityClasses entityType) {
        OpenJPAEntityManagerSPI em = null;
        try {
            Class<?> entityClass = Class.forName(entityType.getEntityClassName());
            String entityClassName = entityType.getEntityName();
            entityClassName = entityClassName.substring(entityClassName.lastIndexOf(46) + 1);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Query " + entityClassName + " and verify 'elements' collection has " + Element_Names.length + " elements in this order: " + Arrays.toString(Element_Names)));
            }
            em = this.emf.createEntityManager();
            em.clear();
            int idx = 0;
            for (String expectedEntityName : Element_Names) {
                Query q = em.createQuery("select w from " + entityClassName + " o join o.elements w where index(w) = " + idx);
                List res = q.getResultList();
                TestIndex.assertEquals((String)("  Verify query returns 1 element for index " + idx), (int)1, (int)res.size());
                if (res.size() == 1) {
                    Object oo = res.get(0);
                    TestIndex.assertEquals((String)"  Verify element type is String", (String)String.class.getName(), (String)oo.getClass().getName());
                    try {
                        String name = oo.toString();
                        TestIndex.assertEquals((String)("  Verify element value is '" + expectedEntityName + "'"), (String)expectedEntityName, (String)name);
                    }
                    catch (Exception e) {
                        this.log.error((Object)("  Caught unexpected exception:" + e.getMessage()));
                        throw new RuntimeException(e);
                    }
                }
                ++idx;
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new RuntimeException(e);
        }
        finally {
            if (em != null) {
                em.close();
                em = null;
            }
        }
    }

    private static enum JPQLIndexEntityClasses implements JPAEntityClassEnum
    {
        OrderedElementEntity(OrderedElementEntity.class),
        OrderedOneToManyEntity(OrderedOneToManyEntity.class),
        OrderedManyToManyEntity(OrderedManyToManyEntity.class),
        XMLOrderedElementEntity(XMLOrderedElementEntity.class),
        XMLOrderedOneToManyEntity(XMLOrderedOneToManyEntity.class),
        XMLOrderedManyToManyEntity(XMLOrderedManyToManyEntity.class),
        UnorderedNameEntity(UnorderedNameEntity.class),
        XMLUnorderedNameEntity(XMLUnorderedNameEntity.class),
        OrderedNameEntity(OrderedNameEntity.class);

        private Class<?> clazz;
        private String fullEntityName;
        private String entityName;

        private JPQLIndexEntityClasses(Class<?> clazz) {
            this.clazz = clazz;
            this.fullEntityName = clazz.getName();
            this.entityName = this.fullEntityName.substring(this.getEntityClassName().lastIndexOf(46) + 1);
        }

        public Class<?> getEntityClass() {
            return this.clazz;
        }

        @Override
        public String getEntityClassName() {
            return this.fullEntityName;
        }

        @Override
        public String getEntityName() {
            return this.entityName;
        }
    }
}

