/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jpql.expressions;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.common.apps.Address;
import org.apache.openjpa.persistence.common.apps.CompUser;
import org.apache.openjpa.persistence.common.apps.FemaleUser;
import org.apache.openjpa.persistence.common.apps.MaleUser;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;

public class TestEJBQLCondExpression
extends AbstractTestCase {
    private int userid1;
    private int userid2;
    private int userid3;
    private int userid4;
    private int userid5;

    public TestEJBQLCondExpression(String name) {
        super(name, "jpqlclausescactusapp");
    }

    public void setUp() {
        this.deleteAll(CompUser.class);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        Address[] add = new Address[]{new Address("43 Sansome", "SF", "USA", "94104"), new Address("24 Mink", "ANTIOCH", "USA", "94513"), new Address("23 Ogbete", "CoalCamp", "NIGERIA", "00000"), new Address("10 Wilshire", "Worcester", "CANADA", "80080"), new Address("23 Bellflower", "Ogui", "NIGERIA", "02000"), new Address("24 Bellflower", "Ogui", "NIGERIA", "02000")};
        CompUser user1 = this.createUser("Seetha", "MAC", add[0], 40, true);
        CompUser user2 = this.createUser("Shannon", "PC", add[1], 36, false);
        CompUser user3 = this.createUser("Ugo", "PC", add[2], 19, true);
        CompUser user4 = this.createUser("Jacob", "LINUX", add[3], 10, true);
        CompUser user5 = this.createUser("Famzy", "UNIX", add[4], 29, false);
        CompUser user6 = this.createUser("tes\\ter", "Test", add[5], 10, true);
        em.persist((Object)user1);
        this.userid1 = user1.getUserid();
        em.persist((Object)user2);
        this.userid2 = user2.getUserid();
        em.persist((Object)user3);
        this.userid3 = user3.getUserid();
        em.persist((Object)user4);
        this.userid4 = user4.getUserid();
        em.persist((Object)user5);
        this.userid5 = user5.getUserid();
        em.persist((Object)user6);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testNothing() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT o FROM CompUser o";
        List result = em.createQuery(query).getResultList();
        TestEJBQLCondExpression.assertNotNull((String)"the list is null", (Object)result);
        TestEJBQLCondExpression.assertEquals((String)"the size of the list is not 6", (int)6, (int)result.size());
        this.endEm((EntityManager)em);
    }

    public void testBetweenExpr() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT o.name FROM CompUser o WHERE o.age BETWEEN 19 AND 40 AND o.computerName = 'PC'";
        List result = em.createQuery(query).getResultList();
        TestEJBQLCondExpression.assertNotNull((String)"the list is null", (Object)result);
        TestEJBQLCondExpression.assertEquals((String)"they are not equal", (int)2, (int)result.size());
        TestEJBQLCondExpression.assertTrue((String)"result dont contain shannon", (boolean)result.contains("Shannon"));
        TestEJBQLCondExpression.assertTrue((String)"result dont contain ugo", (boolean)result.contains("Ugo"));
        this.endEm((EntityManager)em);
    }

    public void testNotBetweenExpr() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT o.name FROM CompUser o WHERE o.age NOT BETWEEN 19 AND 40 AND o.computerName= 'PC'";
        List result = em.createQuery(query).getResultList();
        TestEJBQLCondExpression.assertNotNull((String)"the list is null", (Object)result);
        TestEJBQLCondExpression.assertEquals((String)"they are not equal", (int)0, (int)result.size());
        this.endEm((EntityManager)em);
    }

    public void testInExpr() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT o.name FROM CompUser o WHERE o.age IN (29, 40, 10)";
        List result = em.createQuery(query).getResultList();
        TestEJBQLCondExpression.assertNotNull((String)"the list is null", (Object)result);
        TestEJBQLCondExpression.assertEquals((int)4, (int)result.size());
        TestEJBQLCondExpression.assertTrue((String)"seetha is not in the list", (boolean)result.contains("Seetha"));
        TestEJBQLCondExpression.assertTrue((String)"jacob is not in the list", (boolean)result.contains("Jacob"));
        TestEJBQLCondExpression.assertTrue((String)"famzy is not in the list", (boolean)result.contains("Famzy"));
        this.endEm((EntityManager)em);
    }

    public void testNotInExpr() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT o.name FROM CompUser o WHERE o.age NOT IN (29, 40, 10)";
        List result = em.createQuery(query).getResultList();
        TestEJBQLCondExpression.assertNotNull((Object)result);
        TestEJBQLCondExpression.assertEquals((int)2, (int)result.size());
        TestEJBQLCondExpression.assertTrue((boolean)result.contains("Ugo"));
        TestEJBQLCondExpression.assertTrue((boolean)result.contains("Shannon"));
        this.endEm((EntityManager)em);
    }

    public void testLikeExpr() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT o.computerName FROM CompUser o WHERE o.name LIKE 'Sha%' AND o.computerName NOT IN ('PC')";
        List result = em.createQuery(query).getResultList();
        TestEJBQLCondExpression.assertNotNull((Object)result);
        TestEJBQLCondExpression.assertEquals((int)0, (int)result.size());
        query = "SELECT o.computerName FROM CompUser o WHERE o.name LIKE 'Sha%o_' AND o.computerName NOT IN ('UNIX')";
        result = em.createQuery(query).getResultList();
        TestEJBQLCondExpression.assertNotNull((Object)result);
        TestEJBQLCondExpression.assertEquals((int)1, (int)result.size());
        query = "SELECT o.computerName FROM CompUser o WHERE o.name LIKE 'tes\\%'";
        result = em.createQuery(query).getResultList();
        TestEJBQLCondExpression.assertNotNull((Object)result);
        TestEJBQLCondExpression.assertEquals((int)1, (int)result.size());
        query = "SELECT o.name FROM CompUser o WHERE o.name LIKE '_J%'";
        result = em.createQuery(query).getResultList();
        TestEJBQLCondExpression.assertNotNull((Object)result);
        TestEJBQLCondExpression.assertEquals((int)0, (int)result.size());
        query = "SELECT o.name FROM CompUser o WHERE o.name LIKE ?1 ESCAPE '|'";
        result = em.createQuery(query).setParameter(1, (Object)"%|_%").getResultList();
        TestEJBQLCondExpression.assertNotNull((Object)result);
        TestEJBQLCondExpression.assertEquals((int)0, (int)result.size());
        this.endEm((EntityManager)em);
    }

    public void testNullExpr() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT o.name FROM CompUser o WHERE o.age IS NOT NULL AND o.computerName = 'PC' ";
        List result = em.createQuery(query).getResultList();
        TestEJBQLCondExpression.assertNotNull((String)"the list is null", (Object)result);
        TestEJBQLCondExpression.assertEquals((String)"the list size is not 2", (int)2, (int)result.size());
        TestEJBQLCondExpression.assertTrue((String)"the result doesnt contain ugo", (boolean)result.contains("Ugo"));
        TestEJBQLCondExpression.assertTrue((String)"the result doesnt contain shannon", (boolean)result.contains("Shannon"));
        this.endEm((EntityManager)em);
    }

    public void testNullExpr2() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT o.name FROM CompUser o WHERE o.address.country IS NULL";
        List result = em.createQuery(query).getResultList();
        TestEJBQLCondExpression.assertNotNull((String)"the list is null", (Object)result);
        TestEJBQLCondExpression.assertEquals((String)"they are not equal", (int)0, (int)result.size());
        this.endEm((EntityManager)em);
    }

    public void testIsEmptyExpr() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT o.name FROM CompUser o WHERE o.nicknames IS NOT EMPTY";
        List result = em.createQuery(query).getResultList();
        TestEJBQLCondExpression.assertNotNull((String)"the list is null", (Object)result);
        TestEJBQLCondExpression.assertEquals((String)"they are not equal", (int)0, (int)result.size());
        this.endEm((EntityManager)em);
    }

    public void testIsEmptyExpr2() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT o.name FROM CompUser o WHERE o.nicknames IS EMPTY";
        List result = em.createQuery(query).getResultList();
        TestEJBQLCondExpression.assertNotNull((String)"the list is null", (Object)result);
        TestEJBQLCondExpression.assertEquals((String)"they are not equal", (int)6, (int)result.size());
        this.endEm((EntityManager)em);
    }

    public void testExistExpr() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT DISTINCT o.name FROM CompUser o WHERE EXISTS (SELECT c FROM Address c WHERE c = o.address )";
        List result = em.createQuery(query).getResultList();
        TestEJBQLCondExpression.assertNotNull((String)"the list is null", (Object)result);
        TestEJBQLCondExpression.assertEquals((String)"they are not equal", (int)6, (int)result.size());
        TestEJBQLCondExpression.assertTrue((String)"Seetha is not list", (boolean)result.contains("Seetha"));
        TestEJBQLCondExpression.assertTrue((String)"Shannon is not list", (boolean)result.contains("Shannon"));
        TestEJBQLCondExpression.assertTrue((String)"jacob is not list", (boolean)result.contains("Jacob"));
        TestEJBQLCondExpression.assertTrue((String)"ugo is not list", (boolean)result.contains("Ugo"));
        this.endEm((EntityManager)em);
    }

    public void testNotExistExpr() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT DISTINCT o.name FROM CompUser o WHERE NOT EXISTS (SELECT s FROM CompUser s WHERE s.address.country = o.address.country)";
        List result = em.createQuery(query).getResultList();
        TestEJBQLCondExpression.assertNotNull((String)"list is null", (Object)result);
        TestEJBQLCondExpression.assertEquals((String)"they are not equal", (int)0, (int)result.size());
        this.endEm((EntityManager)em);
    }

    public void testAnyExpr() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT o.name FROM CompUser o WHERE o.address.zipcode = ANY ( SELECT s.computerName FROM CompUser s WHERE s.address.country IS NOT NULL )";
        List result = em.createQuery(query).getResultList();
        TestEJBQLCondExpression.assertNotNull((String)"list is null", (Object)result);
        TestEJBQLCondExpression.assertEquals((String)"they are not equal", (int)0, (int)result.size());
        this.endEm((EntityManager)em);
    }

    public void testConstructorExpr() {
        OpenJPAEntityManager em = this.currentEntityManager();
        String query = "SELECT NEW org.apache.openjpa.persistence.common.apps.MaleUser(c.name, c.computerName, c.address, c.age, c.userid) FROM CompUser c WHERE c.name = 'Seetha'";
        MaleUser male = (MaleUser)em.createQuery(query).getSingleResult();
        TestEJBQLCondExpression.assertNotNull((String)"the list is null", (Object)male);
        TestEJBQLCondExpression.assertEquals((String)"the names dont match", (String)"Seetha", (String)male.getName());
        TestEJBQLCondExpression.assertEquals((String)"computer names dont match", (String)"MAC", (String)male.getComputerName());
        TestEJBQLCondExpression.assertEquals((String)"the ages dont match", (int)40, (int)male.getAge());
        this.endEm((EntityManager)em);
    }

    public CompUser createUser(String name, String cName, Address add, int age, boolean isMale) {
        CompUser user = null;
        if (isMale) {
            user = new MaleUser();
            user.setName(name);
            user.setComputerName(cName);
            user.setAddress(add);
            user.setAge(age);
            user.setNameAsLob(name);
        } else {
            user = new FemaleUser();
            user.setName(name);
            user.setComputerName(cName);
            user.setAddress(add);
            user.setAge(age);
            user.setNameAsLob(name);
        }
        return user;
    }
}

