/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.update;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.update.BaseTimestampedEntity;
import org.apache.openjpa.persistence.jdbc.update.NumericVersionedEntity;
import org.apache.openjpa.persistence.jdbc.update.TimestampedEntity;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestTimestampVersion
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES, TimestampedEntity.class, NumericVersionedEntity.class, BaseTimestampedEntity.class);
    }

    public void testQueryOnVersion() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String pql = "SELECT s FROM TimestampedEntity s WHERE s.version < :endDate";
        Query queryObj = em.createQuery(pql);
        Timestamp t1 = new Timestamp(new Date().getTime());
        queryObj.setParameter("endDate", (Object)t1);
        List scenarioList = queryObj.getResultList();
    }

    public void testBulkUpdateOnTimestampedVersion() {
        TimestampedEntity pc = new TimestampedEntity();
        pc.setName("Original");
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)pc);
        em.getTransaction().commit();
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        em.getTransaction().begin();
        Timestamp oldVersion = pc.getVersion();
        String jpql = "UPDATE TimestampedEntity t SET t.name=:newname WHERE t.name=:oldname";
        em.createQuery(jpql).setParameter("newname", (Object)"Updated").setParameter("oldname", (Object)"Original").executeUpdate();
        em.getTransaction().commit();
        em.getTransaction().begin();
        em.refresh((Object)pc);
        Timestamp newVersion = pc.getVersion();
        TestTimestampVersion.assertTrue((String)("Expected newVersion=" + newVersion.toString() + " to be after oldVersion=" + oldVersion.toString()), (boolean)newVersion.after(oldVersion));
    }

    public void testBulkUpdateOnNumericVersion() {
        NumericVersionedEntity pc = new NumericVersionedEntity();
        pc.setName("Original");
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)pc);
        em.getTransaction().commit();
        em.getTransaction().begin();
        int oldVersion = pc.getVersion();
        String jpql = "UPDATE NumericVersionedEntity t SET t.name=:newname WHERE t.name=:oldname";
        em.createQuery(jpql).setParameter("newname", (Object)"Updated").setParameter("oldname", (Object)"Original").executeUpdate();
        em.getTransaction().commit();
        em.getTransaction().begin();
        em.refresh((Object)pc);
        int newVersion = pc.getVersion();
        TestTimestampVersion.assertEquals((int)newVersion, (int)(oldVersion + 1));
    }
}

