/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.unique;

import java.util.Arrays;
import java.util.List;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.SQLSniffer;
import org.apache.openjpa.persistence.jdbc.unique.UniqueA;
import org.apache.openjpa.persistence.jdbc.unique.UniqueB;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestUniqueConstraint
extends SQLListenerTestCase {
    @Override
    public void setUp(Object ... props) {
        super.setUp(DROP_TABLES, UniqueA.class, UniqueB.class);
    }

    public void testMapping() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.getTransaction().commit();
        em.close();
        List<String> sqls = this.sql;
        this.assertSQLFragnments(sqls, "CREATE TABLE UNIQUE_A", "UNIQUE .*\\(f1, f2\\)", "UNIQUE .*\\(f3, f4\\).*");
        this.assertSQLFragnments(sqls, "CREATE TABLE UNIQUE_B", "UNIQUE .*\\(f1, f2\\).*");
        this.assertSQLFragnments(sqls, "CREATE TABLE UNIQUE_SECONDARY", "UNIQUE .*\\(sf1\\)");
        this.assertSQLFragnments(sqls, "CREATE TABLE UNIQUE_GENERATOR", "UNIQUE .*\\(GEN1, GEN2\\)");
        this.assertSQLFragnments(sqls, "CREATE TABLE UNIQUE_JOINTABLE", "UNIQUE .*\\(FK_A, FK_B\\)");
        this.assertSQLFragnments(sqls, "CREATE TABLE UNIQUE_A", "UNIQUE .*\\(f1\\)");
        this.assertSQLFragnments(sqls, "CREATE TABLE UNIQUE_B", "UNIQUE .*\\(f1\\)");
    }

    void assertSQLFragnments(List<String> list, String ... keys) {
        if (SQLSniffer.matches(list, keys)) {
            return;
        }
        TestUniqueConstraint.fail((String)("None of the following " + this.sql.size() + " SQL \r\n" + this.toString(this.sql) + "\r\n contains all keys \r\n" + this.toString(Arrays.asList(keys))));
    }
}

