/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.unique;

import java.util.Arrays;
import java.util.List;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.MariaDBDictionary;
import org.apache.openjpa.jdbc.sql.MySQLDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.SQLSniffer;
import org.apache.openjpa.persistence.jdbc.unique.NamedUniqueA;
import org.apache.openjpa.persistence.jdbc.unique.NamedUniqueB;
import org.apache.openjpa.persistence.jdbc.unique.TestNamedUniqueConstraint;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestNamedUniqueConstraintWithXMLDescriptor
extends SQLListenerTestCase {
    DBDictionary dict;

    @Override
    public void setUp(Object ... props) {
        super.setUp(DROP_TABLES, NamedUniqueA.class, NamedUniqueB.class);
    }

    @Override
    protected String getPersistenceUnitName() {
        return "NamedUniqueConstraintTest";
    }

    public void testMapping() {
        if (!this.supportsUniqueConstraints()) {
            return;
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.getTransaction().commit();
        em.close();
        List<String> sqls = this.sql;
        this.assertSQLFragnments(sqls, "CREATE TABLE NX_UNIQUE_A", this.getUniqueConstraint("ucxa_f1_f2 UNIQUE .*\\(f1x, f2x\\)"), this.getUniqueConstraint("ucxa_f3_f4 UNIQUE .*\\(f3x, f4x\\).*"));
        this.assertSQLFragnments(sqls, "CREATE TABLE NX_UNIQUE_B", this.getUniqueConstraint("ucxb_f1_f2 UNIQUE .*\\(f1x, f2x\\).*"));
        this.assertSQLFragnments(sqls, "CREATE TABLE NX_UNIQUE_SECONDARY", this.getUniqueConstraint("ucxa_sf1 UNIQUE .*\\(sf1x\\)"));
        this.assertSQLFragnments(sqls, "CREATE TABLE NX_UNIQUE_GENERATOR", this.getUniqueConstraint("ucxb_gen1_gen2 UNIQUE .*\\(GEN1_XML, GEN2_XML\\)"));
        this.assertSQLFragnments(sqls, "CREATE TABLE NX_UNIQUE_JOINTABLE", this.getUniqueConstraint("ucxa_fka_fkb UNIQUE .*\\(FK_A_XML, FK_B_XML\\)"));
        this.assertSQLFragnments(sqls, "CREATE TABLE NX_U_COLL_TBL", this.getUniqueConstraint("ucxb_f3 UNIQUE .*\\(f3x\\).*"));
    }

    private boolean supportsUniqueConstraints() {
        OpenJPAEntityManagerFactorySPI emfs = this.emf;
        JDBCConfiguration jdbccfg = (JDBCConfiguration)emfs.getConfiguration();
        this.dict = jdbccfg.getDBDictionaryInstance();
        return this.dict.supportsUniqueConstraints;
    }

    private String getUniqueConstraint(String unique) {
        if (this.dict instanceof MySQLDictionary || this.dict instanceof MariaDBDictionary) {
            return TestNamedUniqueConstraint.getUniqueConstraint(this.dict, unique);
        }
        return unique;
    }

    void assertSQLFragnments(List<String> list, String ... keys) {
        if (SQLSniffer.matches(list, keys)) {
            return;
        }
        TestNamedUniqueConstraintWithXMLDescriptor.fail((String)("None of the following " + this.sql.size() + " SQL \r\n" + this.toString(this.sql) + "\r\n contains all keys \r\n" + this.toString(Arrays.asList(keys))));
    }
}

