/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.unique;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.MariaDBDictionary;
import org.apache.openjpa.jdbc.sql.MySQLDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.SQLSniffer;
import org.apache.openjpa.persistence.jdbc.unique.NamedUniqueA;
import org.apache.openjpa.persistence.jdbc.unique.NamedUniqueB;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestNamedUniqueConstraint
extends SQLListenerTestCase {
    DBDictionary dict;

    @Override
    public void setUp(Object ... props) {
        super.setUp(DROP_TABLES, NamedUniqueA.class, NamedUniqueB.class);
    }

    public void testMapping() {
        if (!this.supportsUniqueConstraints()) {
            return;
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.getTransaction().commit();
        em.close();
        List<String> sqls = this.sql;
        this.assertSQLFragnments(sqls, "CREATE TABLE N_UNIQUE_A", this.getUniqueConstraint("uca_f1_f2 UNIQUE .*\\(f1, f2\\)"), this.getUniqueConstraint("uca_f3_f4 UNIQUE .*\\(f3, f4\\).*"));
        this.assertSQLFragnments(sqls, "CREATE TABLE N_UNIQUE_B", this.getUniqueConstraint("ucb_f1_f2 UNIQUE .*\\(f1, f2\\).*"));
        this.assertSQLFragnments(sqls, "CREATE TABLE N_UNIQUE_SECONDARY", this.getUniqueConstraint("uca_sf1 UNIQUE .*\\(sf1\\)"));
        this.assertSQLFragnments(sqls, "CREATE TABLE N_UNIQUE_GENERATOR", this.getUniqueConstraint("ucb_gen1_gen2 UNIQUE .*\\(GEN1, GEN2\\)"));
        this.assertSQLFragnments(sqls, "CREATE TABLE N_UNIQUE_JOINTABLE", this.getUniqueConstraint("uca_fka_fkb UNIQUE .*\\(FK_A, FK_B\\)"));
        this.assertSQLFragnments(sqls, "CREATE TABLE N_U_COLL_TBL", this.getUniqueConstraint("ucb_f3 UNIQUE .*\\(f3\\).*"));
    }

    private boolean supportsUniqueConstraints() {
        OpenJPAEntityManagerFactorySPI emfs = this.emf;
        JDBCConfiguration jdbccfg = (JDBCConfiguration)emfs.getConfiguration();
        this.dict = jdbccfg.getDBDictionaryInstance();
        return this.dict.supportsUniqueConstraints;
    }

    private String getUniqueConstraint(String unique) {
        if (this.dict instanceof MySQLDictionary || this.dict instanceof MariaDBDictionary) {
            return TestNamedUniqueConstraint.getUniqueConstraint(this.dict, unique);
        }
        return unique;
    }

    public static String getUniqueConstraint(DBDictionary dict, String unique) {
        ArrayList<String> tokens = new ArrayList<String>();
        ArrayList tokens1 = new ArrayList();
        StringTokenizer st = new StringTokenizer(unique);
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken());
        }
        tokens1.add(tokens.get(1));
        tokens1.add(tokens.get(0));
        for (int i = 2; i < tokens.size(); ++i) {
            tokens1.add(tokens.get(i));
        }
        StringBuilder buf = new StringBuilder();
        for (String token : tokens1) {
            buf.append(token).append(" ");
        }
        return buf.toString().trim();
    }

    void assertSQLFragnments(List<String> list, String ... keys) {
        if (SQLSniffer.matches(list, keys)) {
            return;
        }
        TestNamedUniqueConstraint.fail((String)("None of the following " + this.sql.size() + " SQL \r\n" + this.toString(this.sql) + "\r\n contains all keys \r\n" + this.toString(Arrays.asList(keys))));
    }
}

