/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.sqlcache;

import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.openjpa.jdbc.kernel.PreparedQueryCacheImpl;
import org.apache.openjpa.jdbc.kernel.PreparedQueryImpl;
import org.apache.openjpa.kernel.PreparedQuery;
import org.apache.openjpa.kernel.PreparedQueryCache;

public class TestPreparedQueryCacheExclusion
extends TestCase {
    private PreparedQueryCache cache;
    private String[] keys = new String[]{"jpql1", "jpql2", "jpql3"};
    private String[] values = new String[]{"sql1", "sql2", "sql3"};

    protected void setUp() throws Exception {
        super.setUp();
        this.cache = new PreparedQueryCacheImpl();
        for (int i = 0; i < this.keys.length; ++i) {
            PreparedQueryImpl p = new PreparedQueryImpl(this.keys[i], this.values[i], null);
            this.cache.cache((PreparedQuery)p);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testExclusionPatternsAreSet() {
        String excludes = "a;b;c";
        this.cache.setExcludes(excludes);
        TestPreparedQueryCacheExclusion.assertEquals((int)3, (int)this.cache.getExcludes().size());
        TestPreparedQueryCacheExclusion.assertNotNull((Object)this.cache.isExcluded("a"));
        TestPreparedQueryCacheExclusion.assertNotNull((Object)this.cache.isExcluded("b"));
        TestPreparedQueryCacheExclusion.assertNotNull((Object)this.cache.isExcluded("c"));
        TestPreparedQueryCacheExclusion.assertNull((Object)this.cache.isExcluded("d"));
        List exclusions = this.cache.getExcludes();
        for (PreparedQueryCache.Exclusion e : exclusions) {
            System.err.println(e);
        }
    }

    public void testCachePopulationSetUp() {
        this.assertContent(this.keys, this.values);
    }

    public void testAddExclusionPatternDisallowsCacheing() {
        int EXCLUDED = 1;
        this.cache.addExclusionPattern(this.keys[EXCLUDED]);
        PreparedQueryImpl p = new PreparedQueryImpl(this.keys[EXCLUDED], this.values[EXCLUDED], null);
        TestPreparedQueryCacheExclusion.assertFalse((String)("Must not cache excluded key " + this.keys[EXCLUDED]), (boolean)this.cache.cache((PreparedQuery)p));
    }

    public void testAddExclusionPatternMakesExistingEntryInvalid() {
        int EXCLUDED = 1;
        this.cache.addExclusionPattern(this.keys[EXCLUDED]);
        Map view = this.cache.getMapView();
        for (int i = 0; i < this.keys.length; ++i) {
            if (i == EXCLUDED) {
                TestPreparedQueryCacheExclusion.assertFalse((boolean)view.containsKey(this.keys[i]));
                TestPreparedQueryCacheExclusion.assertFalse((boolean)view.containsValue(this.values[i]));
                continue;
            }
            TestPreparedQueryCacheExclusion.assertTrue((boolean)view.containsKey(this.keys[i]));
            TestPreparedQueryCacheExclusion.assertTrue((boolean)view.containsValue(this.values[i]));
        }
    }

    public void testRemoveExclusionPatternAllowsCacheing() {
        int EXCLUDED = 1;
        this.cache.addExclusionPattern(this.keys[EXCLUDED]);
        PreparedQueryImpl p = new PreparedQueryImpl(this.keys[EXCLUDED], this.values[EXCLUDED], null);
        TestPreparedQueryCacheExclusion.assertFalse((String)("Must not cache excluded key " + this.keys[EXCLUDED]), (boolean)this.cache.cache((PreparedQuery)p));
        this.cache.removeExclusionPattern(this.keys[EXCLUDED]);
        TestPreparedQueryCacheExclusion.assertTrue((String)("Must cache remove excluded key " + this.keys[EXCLUDED]), (boolean)this.cache.cache((PreparedQuery)p));
    }

    public void testRemoveExclusionPatternDoesNotRemoveUserProhbitedKeys() {
        String USER_MARKED_UNCACHABLE = "[user prohibited]";
        this.cache.markUncachable(USER_MARKED_UNCACHABLE, (PreparedQueryCache.Exclusion)new PreparedQueryCacheImpl.StrongExclusion(USER_MARKED_UNCACHABLE, "for testing"));
        PreparedQueryImpl p = new PreparedQueryImpl(USER_MARKED_UNCACHABLE, "xyz", null);
        TestPreparedQueryCacheExclusion.assertFalse((String)("Must not cache user-prohibited key " + USER_MARKED_UNCACHABLE), (boolean)this.cache.cache((PreparedQuery)p));
        this.cache.removeExclusionPattern(USER_MARKED_UNCACHABLE);
        TestPreparedQueryCacheExclusion.assertFalse((String)("Must not cache user-prohibited key even when removed " + USER_MARKED_UNCACHABLE), (boolean)this.cache.cache((PreparedQuery)p));
    }

    void assertContent(String[] keys, String[] values) {
        Map view = this.cache.getMapView();
        for (int i = 0; i < keys.length; ++i) {
            TestPreparedQueryCacheExclusion.assertTrue((String)("key " + keys[i] + " not in " + view), (boolean)view.containsKey(keys[i]));
            TestPreparedQueryCacheExclusion.assertTrue((String)("value " + values[i] + " not in " + view), (boolean)view.containsValue(values[i]));
        }
    }
}

