/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.sqlcache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import junit.framework.TestCase;
import org.apache.openjpa.kernel.PreparedQuery;
import org.apache.openjpa.kernel.PreparedQueryCache;
import org.apache.openjpa.kernel.QueryStatistics;
import org.apache.openjpa.lib.jdbc.AbstractJDBCListener;
import org.apache.openjpa.lib.jdbc.JDBCEvent;
import org.apache.openjpa.lib.jdbc.JDBCListener;
import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.jdbc.sqlcache.Address;
import org.apache.openjpa.persistence.jdbc.sqlcache.Author;
import org.apache.openjpa.persistence.jdbc.sqlcache.Book;
import org.apache.openjpa.persistence.jdbc.sqlcache.CD;
import org.apache.openjpa.persistence.jdbc.sqlcache.Child;
import org.apache.openjpa.persistence.jdbc.sqlcache.Company;
import org.apache.openjpa.persistence.jdbc.sqlcache.Department;
import org.apache.openjpa.persistence.jdbc.sqlcache.Employee;
import org.apache.openjpa.persistence.jdbc.sqlcache.OrderJPA;
import org.apache.openjpa.persistence.jdbc.sqlcache.Parent;
import org.apache.openjpa.persistence.jdbc.sqlcache.Person;
import org.apache.openjpa.persistence.jdbc.sqlcache.Singer;
import org.apache.openjpa.persistence.test.AbstractPersistenceTestCase;

public class TestPreparedQueryCache
extends AbstractPersistenceTestCase {
    private static String RESOURCE = "META-INF/persistence.xml";
    private static String UNIT_NAME = "PreparedQuery";
    protected static final int SAMPLE_SIZE = 100;
    public static final boolean USE_CACHE = true;
    private static Object[] NO_PARAMS = null;
    public static final boolean IS_NAMED_QUERY = true;
    private static boolean FAIL_IF_PERF_DEGRADE = false;
    private static Company IBM;
    public static final String[] COMPANY_NAMES;
    public static final int[] START_YEARS;
    public static final String[] DEPARTMENT_NAMES;
    public static final String[] EMPLOYEE_NAMES;
    public static final Date[] EMPLOYEE_START_DATES;
    public static final Date[] EMPLOYEE_END_DATES;
    public static final String[] CITY_NAMES;
    public static final String EXCLUDED_QUERY_1 = "select count(p) from Company p";
    public static final String EXCLUDED_QUERY_2 = "select count(p) from Department p";
    public static final String INCLUDED_QUERY = "select p from Address p";
    public static final long[] BOOK_IDS;
    public static final String[] BOOK_NAMES;
    public static final long[] CD_IDS;
    public static final String[] CD_LABELS;
    protected static OpenJPAEntityManagerFactorySPI emf;
    protected static SQLAuditor auditor;
    protected static int TEST_COUNT;
    private OpenJPAEntityManagerSPI em;

    public void setUp() throws Exception {
        super.setUp();
        if (emf == null) {
            Properties config = new Properties();
            config.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true,SchemaAction='drop,add')");
            JDBCListener[] jDBCListenerArray = new JDBCListener[1];
            auditor = new SQLAuditor();
            jDBCListenerArray[0] = auditor;
            config.put("openjpa.jdbc.JDBCListeners", jDBCListenerArray);
            config.put("openjpa.jdbc.QuerySQLCache", "true(EnableStatistics=true)");
            config.put("openjpa.RuntimeUnenhancedClasses", "unsupported");
            config.put("openjpa.DynamicEnhancementAgent", "false");
            emf = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)UNIT_NAME, (String)RESOURCE, (Map)config);
            this.em = emf.createEntityManager();
            this.createTestData();
        } else {
            this.em = emf.createEntityManager();
            this.getPreparedQueryCache().clear();
        }
        ++TEST_COUNT;
    }

    void createTestData() {
        this.em.getTransaction().begin();
        for (int i = 0; i < COMPANY_NAMES.length; ++i) {
            Company company = new Company();
            if (i == 0) {
                IBM = company;
            }
            company.setName(COMPANY_NAMES[i]);
            company.setStartYear(START_YEARS[i]);
            this.em.persist((Object)company);
            for (String departmentName : DEPARTMENT_NAMES) {
                Department dept = new Department();
                dept.setName(departmentName);
                company.addDepartment(dept);
                this.em.persist((Object)dept);
                for (int k = 0; k < EMPLOYEE_NAMES.length; ++k) {
                    Employee emp = new Employee();
                    emp.setName(EMPLOYEE_NAMES[k]);
                    emp.setStartDate(EMPLOYEE_START_DATES[k]);
                    emp.setEndDate(EMPLOYEE_END_DATES[k]);
                    Address addr = new Address();
                    addr.setCity(CITY_NAMES[k]);
                    this.em.persist((Object)emp);
                    this.em.persist((Object)addr);
                    emp.setAddress(addr);
                    dept.addEmployees(emp);
                }
            }
        }
        Person p1 = new Person("John", "Doe", 45, 1964);
        Person p2 = new Person("John", "Doe", 42, 1967);
        Person p3 = new Person("Harry", "Doe", 12, 1995);
        Person p4 = new Person("Barry", "Doe", 22, 1985);
        this.em.persist((Object)p1);
        this.em.persist((Object)p2);
        this.em.persist((Object)p3);
        this.em.persist((Object)p4);
        Author a1 = new Author("Author1", "", 40, 1960);
        Author a2 = new Author("Author2", "", 41, 1961);
        Author a3 = new Author("Author3", "", 42, 1962);
        Singer s1 = new Singer("Singer1", "", 21, 1991);
        Singer s2 = new Singer("Singer2", "", 22, 1992);
        long id = 100L;
        Book b1 = new Book("Book1");
        Book b2 = new Book("Book2");
        CD c1 = new CD("CD1");
        CD c2 = new CD("CD2");
        b1.setId(id++);
        b1.setTitle("title-1");
        b1.setToken("LARGE");
        b2.setId(id++);
        b2.setTitle("title-2");
        b2.setToken("MEDIUM");
        c1.setId(id++);
        c2.setId(id++);
        b1.addAuthor(a1);
        b1.addAuthor(a2);
        b2.addAuthor(a2);
        b2.addAuthor(a3);
        c1.setSinger(s1);
        c2.setSinger(s2);
        this.em.persist((Object)a1);
        this.em.persist((Object)a2);
        this.em.persist((Object)a3);
        this.em.persist((Object)s1);
        this.em.persist((Object)s2);
        this.em.persist((Object)b1);
        this.em.persist((Object)b2);
        this.em.persist((Object)c1);
        this.em.persist((Object)c2);
        id = (int)System.currentTimeMillis();
        OrderJPA o1 = new OrderJPA();
        o1.setOrderId(id++);
        o1.setCustomerId(339);
        o1.setDistrictId(3);
        o1.setWarehouseId(23);
        OrderJPA o2 = new OrderJPA();
        o2.setOrderId(id++);
        o2.setCustomerId(2967);
        o2.setDistrictId(5);
        o2.setWarehouseId(22);
        this.em.persist((Object)o1);
        this.em.persist((Object)o2);
        for (int i = 1; i < 10; ++i) {
            Parent parent = new Parent();
            parent.setId(i);
            parent.setName(new String("Parent " + i));
            Address addr = new Address();
            addr.setCity("Address " + i + i);
            parent.setAddrId(addr);
            this.em.persist((Object)addr);
            for (int j = 1; j < 5; ++j) {
                Child child = new Child();
                child.setName("Child " + i + j);
                child.setParent(parent);
                parent.add(child);
            }
            this.em.persist((Object)parent);
        }
        this.em.getTransaction().commit();
    }

    @Override
    public void tearDown() throws Exception {
        this.closeEM((EntityManager)this.em);
        this.em = null;
        if (TEST_COUNT >= 50) {
            auditor.clear();
            auditor = null;
            this.closeEMF((EntityManagerFactory)emf);
            emf = null;
        }
        super.tearDown();
    }

    public void testCollectionValuedParameterOfEntities() {
        Object element2;
        Object employee22;
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        String jpql1 = "select d from Department d where d.name in ('Marketing', 'Sales') order by d.name";
        String jpql2 = "select d from Department d where d.name in ('Engineering', 'Marketing') order by d.name";
        List param1 = em.createQuery(jpql1).getResultList();
        List param2 = em.createQuery(jpql2).getResultList();
        em.clear();
        String jpql = "select e from Employee e where e.department in :param";
        List rs1 = em.createQuery(jpql).setParameter("param", (Object)param1).getResultList();
        for (Object employee22 : rs1) {
            Employee e = employee22;
            TestPreparedQueryCache.assertFalse((boolean)e.getDepartment().getName().equals("Engineering"));
        }
        List rs2 = em.createQuery(jpql).setParameter("param", (Object)param2).getResultList();
        employee22 = rs2.iterator();
        while (employee22.hasNext()) {
            Employee employee1;
            Employee e = employee1 = (Employee)employee22.next();
            TestPreparedQueryCache.assertFalse((boolean)e.getDepartment().getName().equals("Sales"));
        }
        em.clear();
        String jpql3 = "select e from Employee e where e.department in (:p1, :p2, :p3)";
        OpenJPAQuery query = em.createQuery(jpql3);
        query.setParameter("p1", param1.get(0));
        query.setParameter("p2", param1.get(1));
        query.setParameter("p3", param1.get(2));
        List rs3 = query.getResultList();
        for (Object element2 : rs3) {
            Employee e = element2;
            TestPreparedQueryCache.assertTrue((boolean)e.getDepartment().getName().equals("Marketing"));
        }
        em.clear();
        query = em.createQuery(jpql3);
        query.setParameter("p1", param2.get(0));
        query.setParameter("p2", param2.get(1));
        query.setParameter("p3", param2.get(2));
        List rs4 = query.getResultList();
        element2 = rs4.iterator();
        while (element2.hasNext()) {
            Employee employee;
            Employee e = employee = (Employee)element2.next();
            TestPreparedQueryCache.assertTrue((boolean)e.getDepartment().getName().equals("Engineering"));
        }
        em.clear();
        String jpql4 = "select p from Parent p where p.id < 3";
        String jpql5 = "select p from Parent p where p.id > 4";
        List parm1 = em.createQuery(jpql4).getResultList();
        List parm2 = em.createQuery(jpql5).getResultList();
        TestPreparedQueryCache.assertTrue((String)("Size of two result list " + parm1.size() + " and " + parm2.size() + " must not be same"), (parm1.size() != parm2.size() ? 1 : 0) != 0);
        em.clear();
        String jpql6 = "select c from Child c where c.parent in ?1";
        OpenJPAQuery qry = em.createQuery(jpql6);
        qry.setParameter(1, (Object)parm1);
        List c1 = qry.getResultList();
        for (Child item : c1) {
            Child child = item;
            TestPreparedQueryCache.assertTrue((child.getParent().getId() < 3L ? 1 : 0) != 0);
        }
        em.clear();
        qry = em.createQuery(jpql6);
        qry.setParameter(1, (Object)parm2);
        List c2 = qry.getResultList();
        for (Child value : c2) {
            Child child = value;
            TestPreparedQueryCache.assertTrue((child.getParent().getId() > 4L ? 1 : 0) != 0);
        }
    }

    public void testCollectionValuedParameterOfEntitiesWithEmptyList() {
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        String jpql1 = "select d from Department d where d.name in ('Marketing', 'Sales') order by d.name";
        List param1 = em.createQuery(jpql1).getResultList();
        em.clear();
        String jpql = "select e from Employee e where e.department in :param";
        List rs1 = em.createQuery(jpql).setParameter("param", (Object)param1).getResultList();
        Iterator iterator = rs1.iterator();
        while (iterator.hasNext()) {
            Employee employee;
            Employee e = employee = (Employee)iterator.next();
            TestPreparedQueryCache.assertFalse((boolean)e.getDepartment().getName().equals("Engineering"));
        }
        try {
            em.createQuery(jpql).setParameter("param", new ArrayList()).getResultList();
        }
        catch (ArgumentException ae) {
            TestPreparedQueryCache.assertEquals((String)ae.getCause().getMessage(), (String)"Input parameter \"param\" is empty.");
        }
    }

    public void testRepeatedParameterInSubqueryInDifferentOrderSubQLast() {
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        String jpql = "SELECT o from OrderJPA o WHERE (o.CustomerId = :customerId) AND (o.WarehouseId = :warehouseId) AND (o.DistrictId = :districtId) AND o.OrderId IN (SELECT MAX (o1.OrderId) from OrderJPA o1 WHERE ((o1.CustomerId = :customerId) AND    (o1.DistrictId = :districtId) AND    (o1.WarehouseId = :warehouseId)))";
        em.getTransaction().begin();
        TypedQuery q1 = em.createQuery(jpql, OrderJPA.class);
        q1.setParameter("customerId", (Object)339).setParameter("districtId", (Object)3).setParameter("warehouseId", (Object)23);
        TestPreparedQueryCache.assertEquals((String)"javax.persistence.JPQL", (String)OpenJPAPersistence.cast((Query)q1).getLanguage());
        TestPreparedQueryCache.assertFalse((boolean)q1.getResultList().isEmpty());
        TypedQuery q2 = em.createQuery(jpql, OrderJPA.class);
        TestPreparedQueryCache.assertEquals((String)"openjpa.prepared.SQL", (String)OpenJPAPersistence.cast((Query)q2).getLanguage());
        q2.setParameter("customerId", (Object)2967).setParameter("districtId", (Object)5).setParameter("warehouseId", (Object)22);
        TestPreparedQueryCache.assertFalse((boolean)q2.getResultList().isEmpty());
        em.getTransaction().rollback();
    }

    public void testPreparedQueryCacheIsActiveByDefault() {
        TestPreparedQueryCache.assertNotNull((Object)this.getPreparedQueryCache());
    }

    public void testPreparedQueryCacheIsPerUnitSingleton() {
        PreparedQueryCache c1 = this.getPreparedQueryCache();
        PreparedQueryCache c2 = this.getPreparedQueryCache();
        TestPreparedQueryCache.assertSame((Object)c1, (Object)c2);
    }

    public void testPreparedQueryIdentifierIsOriginalJPQLQuery() {
        String jpql = "select p from Company p";
        OpenJPAQuery q1 = this.em.createQuery(jpql);
        q1.getResultList();
        PreparedQuery pq = this.getPreparedQueryCache().get(jpql);
        TestPreparedQueryCache.assertNotNull((Object)pq);
        TestPreparedQueryCache.assertEquals((String)jpql, (String)pq.getIdentifier());
        TestPreparedQueryCache.assertEquals((String)jpql, (String)pq.getOriginalQuery());
    }

    public void testOriginalJPQLQueryStringIsSetOnPreparedQuery() {
        String jpql = "select p from Company p";
        OpenJPAQuery q1 = this.em.createQuery(jpql);
        q1.getResultList();
        PreparedQuery pq = this.getPreparedQueryCache().get(jpql);
        TestPreparedQueryCache.assertNotNull((Object)pq);
        OpenJPAQuery q2 = this.em.createQuery(jpql);
        TestPreparedQueryCache.assertEquals((String)jpql, (String)q2.getQueryString());
    }

    public void testOrderByElementsAbsentInProjection() {
        String jpql = "select c.name from Company c ORDER BY c.startYear";
        OpenJPAQuery q1 = this.em.createQuery(jpql);
        List l1 = q1.getResultList();
        PreparedQuery pq = this.getPreparedQueryCache().get(jpql);
        TestPreparedQueryCache.assertNotNull((Object)pq);
        OpenJPAQuery q2 = this.em.createQuery(jpql);
        List l2 = q2.getResultList();
        TestPreparedQueryCache.assertEquals((int)l1.size(), (int)l2.size());
        TestPreparedQueryCache.assertEquals((String)l1.toString(), (String)l2.toString());
    }

    public void testExclusionPattern() {
        OpenJPAQuery q1 = this.em.createQuery(EXCLUDED_QUERY_1);
        q1.getResultList();
        this.assertNotCached(EXCLUDED_QUERY_1);
        OpenJPAQuery q2 = this.em.createQuery(EXCLUDED_QUERY_2);
        q2.getResultList();
        this.assertNotCached(EXCLUDED_QUERY_2);
        OpenJPAQuery q3 = this.em.createQuery(INCLUDED_QUERY);
        q3.getResultList();
        this.assertCached(INCLUDED_QUERY);
    }

    void assertLanguage(OpenJPAQuery<?> q, String lang) {
        TestPreparedQueryCache.assertEquals((String)lang, (String)q.getLanguage());
    }

    void assertCached(String id) {
        PreparedQuery cached = this.getPreparedQueryCache().get(id);
        TestPreparedQueryCache.assertNotNull((String)(this.getPreparedQueryCache() + ": " + this.getPreparedQueryCache().getMapView() + " does not contain " + id), (Object)cached);
    }

    void assertNotCached(String id) {
        PreparedQueryCache cache = this.getPreparedQueryCache();
        if (cache != null) {
            TestPreparedQueryCache.assertNull((Object)cache.get(id));
        }
    }

    public void testPreparedQueryIsCachedOnExecution() {
        String jpql = "select p from Company p";
        OpenJPAQuery q1 = this.em.createQuery(jpql);
        this.assertNotCached(jpql);
        this.assertLanguage(q1, "javax.persistence.JPQL");
        q1.getResultList();
        this.assertCached(jpql);
        this.assertLanguage(q1, "javax.persistence.JPQL");
        PreparedQuery cached = this.getPreparedQueryCache().get(jpql);
        TestPreparedQueryCache.assertEquals((String)jpql, (String)cached.getIdentifier());
        TestPreparedQueryCache.assertFalse((boolean)jpql.equalsIgnoreCase(cached.getTargetQuery()));
    }

    public void testPreparedQueryIsCachedAcrossExecution() {
        String jpql = "select p from Company p";
        OpenJPAQuery q1 = this.em.createQuery(jpql);
        this.assertNotCached(jpql);
        this.assertLanguage(q1, "javax.persistence.JPQL");
        q1.getResultList();
        this.assertCached(jpql);
        this.assertLanguage(q1, "javax.persistence.JPQL");
        OpenJPAQuery q2 = this.em.createQuery(jpql);
        this.assertCached(jpql);
        this.assertLanguage(q2, "openjpa.prepared.SQL");
    }

    public void testInvalidatePreparedQueryWithHint() {
        String jpql = "select p from Company p";
        OpenJPAQuery q1 = this.em.createQuery(jpql);
        this.assertNotCached(jpql);
        q1.getResultList();
        this.assertCached(jpql);
        this.assertLanguage(q1, "javax.persistence.JPQL");
        OpenJPAQuery q2 = this.em.createQuery(jpql);
        this.assertCached(jpql);
        this.assertLanguage(q2, "openjpa.prepared.SQL");
        q2.getResultList();
        q2.setHint("openjpa.hint.InvalidatePreparedQuery", (Object)true);
        this.assertNotCached(jpql);
        TestPreparedQueryCache.assertEquals((String)"javax.persistence.JPQL", (String)q2.getLanguage());
        q2.getResultList();
        OpenJPAQuery q3 = this.em.createQuery(jpql);
        this.assertNotCached(jpql);
        this.assertLanguage(q3, "javax.persistence.JPQL");
    }

    public void testIgnorePreparedQueryWithHint() {
        String jpql = "select p from Company p";
        OpenJPAQuery q1 = this.em.createQuery(jpql);
        this.assertNotCached(jpql);
        q1.getResultList();
        this.assertCached(jpql);
        this.assertLanguage(q1, "javax.persistence.JPQL");
        OpenJPAQuery q2 = this.em.createQuery(jpql);
        this.assertCached(jpql);
        this.assertLanguage(q2, "openjpa.prepared.SQL");
        q2.getResultList();
        q2.setHint("openjpa.hint.IgnorePreparedQuery", (Object)true);
        this.assertCached(jpql);
        TestPreparedQueryCache.assertEquals((String)"javax.persistence.JPQL", (String)q2.getLanguage());
        q2.getResultList();
        OpenJPAQuery q3 = this.em.createQuery(jpql);
        this.assertCached(jpql);
        this.assertLanguage(q3, "openjpa.prepared.SQL");
    }

    public void testQueryStatistics() {
        int i;
        QueryStatistics stats = this.getPreparedQueryCache().getStatistics();
        stats.reset();
        String jpql1 = "select c from Company c";
        String jpql2 = "select c from Company c where c.name = 'PObject'";
        int N1 = 5;
        int N2 = 8;
        for (i = 0; i < N1; ++i) {
            OpenJPAQuery q1 = this.em.createQuery(jpql1);
            q1.getResultList();
        }
        for (i = 0; i < N2; ++i) {
            OpenJPAQuery q2 = this.em.createQuery(jpql2);
            q2.getResultList();
        }
        TestPreparedQueryCache.assertEquals((long)N1, (long)stats.getExecutionCount((Object)jpql1));
        TestPreparedQueryCache.assertEquals((long)N2, (long)stats.getExecutionCount((Object)jpql2));
        TestPreparedQueryCache.assertEquals((long)(N1 + N2), (long)stats.getExecutionCount());
        TestPreparedQueryCache.assertEquals((long)(N1 - 1), (long)stats.getHitCount((Object)jpql1));
        TestPreparedQueryCache.assertEquals((long)(N2 - 1), (long)stats.getHitCount((Object)jpql2));
        TestPreparedQueryCache.assertEquals((long)(N1 + N2 - 2), (long)stats.getHitCount());
    }

    public void testResetQueryStatistics() {
        int i;
        int i2;
        QueryStatistics stats = this.getPreparedQueryCache().getStatistics();
        stats.reset();
        String jpql1 = "select c from Company c";
        String jpql2 = "select c from Company c where c.name = 'PObject'";
        int N10 = 4;
        int N20 = 7;
        for (i2 = 0; i2 < N10; ++i2) {
            OpenJPAQuery q1 = this.em.createQuery(jpql1);
            q1.getResultList();
        }
        for (i2 = 0; i2 < N20; ++i2) {
            OpenJPAQuery q2 = this.em.createQuery(jpql2);
            q2.getResultList();
        }
        TestPreparedQueryCache.assertEquals((long)N10, (long)stats.getExecutionCount((Object)jpql1));
        TestPreparedQueryCache.assertEquals((long)N20, (long)stats.getExecutionCount((Object)jpql2));
        TestPreparedQueryCache.assertEquals((long)(N10 + N20), (long)stats.getExecutionCount());
        TestPreparedQueryCache.assertEquals((long)(N10 - 1), (long)stats.getHitCount((Object)jpql1));
        TestPreparedQueryCache.assertEquals((long)(N20 - 1), (long)stats.getHitCount((Object)jpql2));
        TestPreparedQueryCache.assertEquals((long)(N10 + N20 - 2), (long)stats.getHitCount());
        stats.reset();
        int N11 = 7;
        int N21 = 4;
        for (i = 0; i < N11; ++i) {
            OpenJPAQuery q1 = this.em.createQuery(jpql1);
            q1.getResultList();
        }
        for (i = 0; i < N21; ++i) {
            OpenJPAQuery q2 = this.em.createQuery(jpql2);
            q2.getResultList();
        }
        TestPreparedQueryCache.assertEquals((long)N11, (long)stats.getExecutionCount((Object)jpql1));
        TestPreparedQueryCache.assertEquals((long)N21, (long)stats.getExecutionCount((Object)jpql2));
        TestPreparedQueryCache.assertEquals((long)(N11 + N21), (long)stats.getExecutionCount());
        TestPreparedQueryCache.assertEquals((long)N11, (long)stats.getHitCount((Object)jpql1));
        TestPreparedQueryCache.assertEquals((long)N21, (long)stats.getHitCount((Object)jpql2));
        TestPreparedQueryCache.assertEquals((long)(N11 + N21), (long)stats.getHitCount());
        TestPreparedQueryCache.assertEquals((long)(N10 + N11 - 1), (long)stats.getTotalHitCount((Object)jpql1));
        TestPreparedQueryCache.assertEquals((long)(N20 + N21 - 1), (long)stats.getTotalHitCount((Object)jpql2));
        TestPreparedQueryCache.assertEquals((long)(N10 + N11 + N20 + N21 - 2), (long)stats.getTotalHitCount());
    }

    public void testQueryWithNoParameter() {
        String jpql = "select p from Company p";
        this.compare(jpql, false);
    }

    public void testQueryWithLiteral() {
        String jpql = "select p from Company p where p.name = " + this.literal(COMPANY_NAMES[0]);
        this.compare(jpql, false);
    }

    public void testQueryWithParameter() {
        String jpql = "select p from Company p where p.name = :param";
        Object[] params = new Object[]{"param", COMPANY_NAMES[0]};
        this.compare(jpql, false, params);
    }

    public void testQueryWithJoinsAndParameters() {
        String jpql = "select e from Employee e where e.name = :emp and e.department.name = :dept and e.department.company.name LIKE  " + this.literal(COMPANY_NAMES[0]) + " and e.address.city = :city";
        Object[] params = new Object[]{"emp", EMPLOYEE_NAMES[0], "dept", DEPARTMENT_NAMES[0], "city", CITY_NAMES[0]};
        this.compare(jpql, false, params);
    }

    public void testNamedQueryWithNoParameter() {
        String namedQuery = "Company.PreparedQueryWithNoParameter";
        this.compare(namedQuery, true);
    }

    public void testNamedQueryWithLiteral() {
        String namedQuery = "Company.PreparedQueryWithLiteral";
        this.compare(namedQuery, true);
    }

    public void testNamedQueryWithPositionalParameter() {
        String namedQuery = "Company.PreparedQueryWithPositionalParameter";
        Object[] params = new Object[]{1, COMPANY_NAMES[0], 2, START_YEARS[0]};
        this.compare(namedQuery, true, params);
    }

    public void testNamedQueryWithNamedParameter() {
        String namedQuery = "Company.PreparedQueryWithNamedParameter";
        Object[] params = new Object[]{"name", COMPANY_NAMES[0], "startYear", START_YEARS[0]};
        this.compare(namedQuery, true, params);
    }

    public void testPersistenceCapableParameter() {
        String jpql = "select e from Employee e where e.department.company=:company";
        Object[] params = new Object[]{"company", IBM};
        this.compare(jpql, false, params);
    }

    public void testProjectionResult() {
        String jpql = "select e.name from Employee e where e.address.city=:city";
        Object[] params = new Object[]{"city", CITY_NAMES[0]};
        this.compare(jpql, false, params);
    }

    public void testCollectionValuedParameters() {
        String jpql = "select e from Employee e where e.name in :names";
        Object[] params1 = new Object[]{"names", Arrays.asList(EMPLOYEE_NAMES[0], EMPLOYEE_NAMES[1])};
        Object[] params2 = new Object[]{"names", Arrays.asList(EMPLOYEE_NAMES[2])};
        Object[] params3 = new Object[]{"names", Arrays.asList(EMPLOYEE_NAMES)};
        int expectedCount = 2 * COMPANY_NAMES.length * DEPARTMENT_NAMES.length;
        this.run(jpql, false, params1, expectedCount, true, 1);
        expectedCount = 1 * COMPANY_NAMES.length * DEPARTMENT_NAMES.length;
        this.run(jpql, false, params2, expectedCount, true, 1);
        expectedCount = EMPLOYEE_NAMES.length * COMPANY_NAMES.length * DEPARTMENT_NAMES.length;
        this.run(jpql, false, params3, expectedCount, true, 1);
    }

    public void testQueryProjectionNotCandidateClass() {
        String jpql = "select e.department from Employee e";
        this.compare(jpql, false);
    }

    public void testQueryMultipleProjectionClass() {
        String jpql = "select d, e from Department d, in (d.employees) e";
        this.compare(jpql, false);
    }

    public void testQueryWithOrderByClause() {
        String jpql = "select e.name from Employee e order by e.id";
        this.compare(jpql, false);
    }

    public void testQueryCount() {
        String jpql = "select count(e),d from Department d join d.employees e group by d";
        this.compare(jpql, false);
    }

    public void testProjectRepeatsTerm() {
        String jpql = "select e.name, e.name from Employee e";
        this.compare(jpql, false);
    }

    public void testProjectEmbedded() {
        String jpql = "select e.address from Employee e";
        this.compare(jpql, false);
    }

    public void testNeedsTypeConversion() {
        String jpql = "select e.name, e.isManager from Employee e";
        this.compare(jpql, false);
    }

    String literal(String s) {
        return "'" + s + "'";
    }

    public void testPositional() {
        String jpql = "select p from Person p where p.firstName=?1 and p.lastName='Doe' and p.age > ?2";
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        OpenJPAQuery q1 = OpenJPAPersistence.cast((Query)em.createQuery(jpql));
        TestPreparedQueryCache.assertEquals((String)"javax.persistence.JPQL", (String)q1.getLanguage());
        List result1 = q1.setParameter(1, (Object)"John").setParameter(2, (Object)40).getResultList();
        TestPreparedQueryCache.assertEquals((int)2, (int)result1.size());
        OpenJPAQuery q2 = OpenJPAPersistence.cast((Query)em.createQuery(jpql));
        TestPreparedQueryCache.assertEquals((String)"openjpa.prepared.SQL", (String)q2.getLanguage());
        List result2 = q2.setParameter(1, (Object)"Harry").setParameter(2, (Object)10).getResultList();
        TestPreparedQueryCache.assertEquals((int)1, (int)result2.size());
    }

    public void testNamed() {
        String jpql = "select p from Person p where p.firstName=:first and p.lastName='Doe' and p.age > :age";
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        OpenJPAQuery q1 = OpenJPAPersistence.cast((Query)em.createQuery(jpql));
        TestPreparedQueryCache.assertEquals((String)"javax.persistence.JPQL", (String)q1.getLanguage());
        List result1 = q1.setParameter("first", (Object)"John").setParameter("age", (Object)40).getResultList();
        TestPreparedQueryCache.assertEquals((int)2, (int)result1.size());
        OpenJPAQuery q2 = OpenJPAPersistence.cast((Query)em.createQuery(jpql));
        TestPreparedQueryCache.assertEquals((String)"openjpa.prepared.SQL", (String)q2.getLanguage());
        List result2 = q2.setParameter("first", (Object)"Barry").setParameter("age", (Object)20).getResultList();
        TestPreparedQueryCache.assertEquals((int)1, (int)result2.size());
    }

    public void testWrongParameterValueTypeThrowException() {
        String jpql = "select p from Person p where p.firstName=:first and p.age > :age";
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        OpenJPAQuery q1 = OpenJPAPersistence.cast((Query)em.createQuery(jpql));
        try {
            List result1 = q1.setParameter("first", (Object)40).setParameter("age", (Object)"John").getResultList();
            TestPreparedQueryCache.fail((String)"Expected to fail with wrong parameter value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNullParameterValueForPrimitiveTypeThrowsException() {
        String jpql = "select p from Person p where p.firstName=:first and p.age > :age";
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        OpenJPAQuery q1 = OpenJPAPersistence.cast((Query)em.createQuery(jpql));
        try {
            List result1 = q1.setParameter("first", (Object)"John").setParameter("age", null).getResultList();
            TestPreparedQueryCache.fail((String)"Expected to fail with null parameter value for primitives");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testQueryWithLazyRelationIsCached() {
        String jpql = "select p from Author p";
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        Query q1 = em.createQuery(jpql);
        TestPreparedQueryCache.assertEquals((String)OpenJPAPersistence.cast((Query)q1).getLanguage(), (String)"javax.persistence.JPQL");
        List authors1 = q1.getResultList();
        TestPreparedQueryCache.assertFalse((boolean)authors1.isEmpty());
        Author author1 = (Author)authors1.iterator().next();
        em.close();
        TestPreparedQueryCache.assertNull(author1.getBooks());
        em = emf.createEntityManager();
        Query q2 = em.createQuery(jpql);
        TestPreparedQueryCache.assertEquals((String)OpenJPAPersistence.cast((Query)q2).getLanguage(), (String)"openjpa.prepared.SQL");
        List authors2 = q2.getResultList();
        TestPreparedQueryCache.assertFalse((boolean)authors2.isEmpty());
        Author author2 = (Author)authors2.iterator().next();
        em.close();
        TestPreparedQueryCache.assertNull(author2.getBooks());
    }

    public void testQueryWithEagerRelationIsNotCached() {
        String jpql = "select b from Book b";
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        Query q1 = em.createQuery(jpql);
        TestPreparedQueryCache.assertEquals((String)OpenJPAPersistence.cast((Query)q1).getLanguage(), (String)"javax.persistence.JPQL");
        List books = q1.getResultList();
        TestPreparedQueryCache.assertFalse((boolean)books.isEmpty());
        Book book1 = (Book)books.iterator().next();
        em.close();
        TestPreparedQueryCache.assertNotNull(book1.getAuthors());
        TestPreparedQueryCache.assertFalse((boolean)book1.getAuthors().isEmpty());
        em = emf.createEntityManager();
        Query q2 = em.createQuery(jpql);
        TestPreparedQueryCache.assertEquals((String)OpenJPAPersistence.cast((Query)q2).getLanguage(), (String)"javax.persistence.JPQL");
        List books2 = q2.getResultList();
        TestPreparedQueryCache.assertFalse((boolean)books2.isEmpty());
        Book book2 = (Book)books2.iterator().next();
        em.close();
        TestPreparedQueryCache.assertNotNull(book2.getAuthors());
        TestPreparedQueryCache.assertFalse((boolean)book2.getAuthors().isEmpty());
    }

    public void testQueryWithUserDefinedAndInternalParamtersInSubquery() {
        String jpql = "Select a From Address a Where Not Exists (     Select s.id From Singer As s Where         s.address = a  And         Not (              (s.firstName = :firstName)               Or               (                  (                      exists (select c.id from CD c where c.singer = s and c.status = 1) And                       s.lastName = :lastName                  )                   Or                   (                      not exists (Select c.id from CD c where c.singer = s and c.status = 2)                  )              )            )     )";
        OpenJPAQuery jQ = this.em.createQuery(jpql);
        jQ.setParameter("lastName", (Object)"LastName");
        jQ.setParameter("firstName", (Object)"FirstName");
        List jList = jQ.getResultList();
        OpenJPAQuery jQ1 = this.em.createQuery(jpql);
        jQ1.setParameter("lastName", (Object)"LastName1");
        jQ1.setParameter("firstName", (Object)"FirstName1");
        try {
            List list = jQ1.getResultList();
        }
        catch (Exception e) {
            System.err.println(jQ1.getParameters());
            e.printStackTrace();
            TestPreparedQueryCache.fail((String)("Fail to execute again - Parameters are messed up:" + e.getMessage()));
        }
    }

    public void testPreparedQueryIgnoredWhenLockModeIsSet() {
        String jpql = "select p from Author p";
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        Query q1 = em.createQuery(jpql);
        TestPreparedQueryCache.assertEquals((String)"javax.persistence.JPQL", (String)OpenJPAPersistence.cast((Query)q1).getLanguage());
        List authors1 = q1.getResultList();
        em.getTransaction().begin();
        Query q2 = em.createQuery(jpql);
        TestPreparedQueryCache.assertEquals((String)"openjpa.prepared.SQL", (String)OpenJPAPersistence.cast((Query)q2).getLanguage());
        LockModeType lmode1 = q2.getLockMode();
        q2.setLockMode(LockModeType.OPTIMISTIC);
        LockModeType lmode2 = q2.getLockMode();
        TestPreparedQueryCache.assertEquals((String)"javax.persistence.JPQL", (String)OpenJPAPersistence.cast((Query)q2).getLanguage());
        TestPreparedQueryCache.assertFalse((boolean)lmode1.equals((Object)lmode2));
        List authors2 = q2.getResultList();
        em.getTransaction().rollback();
    }

    public void testEnumParameter() {
        String jpql = "select e from Employee e where e.status=:current and e.hireStatus=:hire";
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        TypedQuery q1 = em.createQuery(jpql, Employee.class);
        TestPreparedQueryCache.assertEquals((String)"javax.persistence.JPQL", (String)OpenJPAPersistence.cast((Query)q1).getLanguage());
        List emps = q1.setParameter("current", (Object)Employee.Category.PERMANENT).setParameter("hire", (Object)Employee.Category.CONTRACTOR).getResultList();
        em.getTransaction().begin();
        TypedQuery q2 = em.createQuery(jpql, Employee.class);
        TestPreparedQueryCache.assertEquals((String)"openjpa.prepared.SQL", (String)OpenJPAPersistence.cast((Query)q2).getLanguage());
        List emps2 = q2.setParameter("current", (Object)Employee.Category.PERMANENT).setParameter("hire", (Object)Employee.Category.CONTRACTOR).getResultList();
        em.getTransaction().rollback();
    }

    public void testMultithreadedAccess() {
        OpenJPAEntityManagerSPI em1 = emf.createEntityManager();
        String jpql = "select p from Author p where p.name=:name";
        int N = 5;
        Thread[] threads = new Thread[N];
        QueryThread[] qts = new QueryThread[N];
        for (int i = 0; i < N; ++i) {
            OpenJPAEntityManagerSPI emt = emf.createEntityManager();
            qts[i] = new QueryThread((OpenJPAEntityManager)emt, jpql);
            threads[i] = new Thread(qts[i]);
            threads[i].setDaemon(true);
        }
        for (Thread t : threads) {
            t.start();
        }
        for (int i = 0; i < N; ++i) {
            try {
                threads[i].join();
                TestPreparedQueryCache.assertFalse((boolean)qts[i].isFailed());
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                TestPreparedQueryCache.fail();
            }
        }
    }

    public void testParameterOnExternalizedFieldIsExcluded() {
        String jpql = "select b from Book b where b.title=:title and b.token=:token";
        OpenJPAQuery q1 = this.em.createQuery(jpql).setParameter("title", (Object)"title-1").setParameter("token", (Object)"LARGE");
        OpenJPAPersistence.cast((Query)q1).getFetchPlan().removeFetchGroup("default");
        TestPreparedQueryCache.assertFalse((boolean)q1.getResultList().isEmpty());
        this.assertNotCached(jpql);
        OpenJPAQuery q2 = this.em.createQuery(jpql).setParameter("title", (Object)"title-2").setParameter("token", (Object)"MEDIUM");
        TestPreparedQueryCache.assertFalse((boolean)q2.getResultList().isEmpty());
    }

    public void testNoParameterOnExternalizedFieldIsIncluded() {
        String jpql = "select b from Book b where b.title=:title";
        OpenJPAQuery q1 = this.em.createQuery(jpql).setParameter("title", (Object)"title-1");
        OpenJPAPersistence.cast((Query)q1).getFetchPlan().removeFetchGroup("default");
        TestPreparedQueryCache.assertFalse((boolean)q1.getResultList().isEmpty());
        this.assertCached(jpql);
        OpenJPAQuery q2 = this.em.createQuery(jpql).setParameter("title", (Object)"title-2");
        TestPreparedQueryCache.assertFalse((boolean)q2.getResultList().isEmpty());
    }

    public void testSubqueryParameters() {
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        String query = "select e from Employee e inner join e.department d inner join d.company c where mod(c.startYear, 100) = 0 and exists (select e2 from Employee e2 inner join e2.department d2 inner join d2.company c2 where e2.address.city = e.address.city and e2.isManager = false and d2.name = d.name and c2.name = :companyName) and d.name = :departmentName";
        em.getTransaction().begin();
        TypedQuery q1 = em.createQuery(query, Employee.class);
        q1.setParameter("companyName", (Object)"acme.org");
        q1.setParameter("departmentName", (Object)"Engineering");
        TestPreparedQueryCache.assertEquals((int)q1.getResultList().size(), (int)6);
        TypedQuery q2 = em.createQuery(query, Employee.class);
        q2.setParameter("companyName", (Object)"acme.org");
        q2.setParameter("departmentName", (Object)"Engineering");
        TestPreparedQueryCache.assertEquals((int)q2.getResultList().size(), (int)6);
        em.getTransaction().rollback();
    }

    public void testRepeatedParameterInSubqueryInDifferentOrder() {
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        String jpql = "select o from OrderJPA o where o.OrderId in (select max(o1.OrderId) from OrderJPA o1 where ((o1.CustomerId = :customerId) and   (o1.DistrictId = :districtId) and   (o1.WarehouseId = :warehouseId))) and (o.CustomerId = :customerId) and (o.WarehouseId = :warehouseId) and (o.DistrictId = :districtId)";
        em.getTransaction().begin();
        TypedQuery q1 = em.createQuery(jpql, OrderJPA.class);
        q1.setParameter("customerId", (Object)339).setParameter("districtId", (Object)3).setParameter("warehouseId", (Object)23);
        TestPreparedQueryCache.assertEquals((String)"javax.persistence.JPQL", (String)OpenJPAPersistence.cast((Query)q1).getLanguage());
        TestPreparedQueryCache.assertFalse((boolean)q1.getResultList().isEmpty());
        TypedQuery q2 = em.createQuery(jpql, OrderJPA.class);
        TestPreparedQueryCache.assertEquals((String)"openjpa.prepared.SQL", (String)OpenJPAPersistence.cast((Query)q2).getLanguage());
        q2.setParameter("customerId", (Object)2967).setParameter("districtId", (Object)5).setParameter("warehouseId", (Object)22);
        TestPreparedQueryCache.assertFalse((boolean)q2.getResultList().isEmpty());
        em.getTransaction().rollback();
    }

    public void testRepeatedParameterInSubqueryInSameOrder() {
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        String jpql = "select o from OrderJPA o where o.OrderId in (select max(o1.OrderId) from OrderJPA o1 where ((o1.CustomerId = :customerId) and   (o1.DistrictId = :districtId) and   (o1.WarehouseId = :warehouseId))) and (o.CustomerId = :customerId) and (o.DistrictId = :districtId) and (o.WarehouseId = :warehouseId)";
        em.getTransaction().begin();
        TypedQuery q1 = em.createQuery(jpql, OrderJPA.class);
        q1.setParameter("customerId", (Object)339).setParameter("districtId", (Object)3).setParameter("warehouseId", (Object)23);
        TestPreparedQueryCache.assertEquals((String)"javax.persistence.JPQL", (String)OpenJPAPersistence.cast((Query)q1).getLanguage());
        TestPreparedQueryCache.assertFalse((boolean)q1.getResultList().isEmpty());
        TypedQuery q2 = em.createQuery(jpql, OrderJPA.class);
        TestPreparedQueryCache.assertEquals((String)"openjpa.prepared.SQL", (String)OpenJPAPersistence.cast((Query)q2).getLanguage());
        q2.setParameter("customerId", (Object)2967).setParameter("districtId", (Object)5).setParameter("warehouseId", (Object)22);
        TestPreparedQueryCache.assertFalse((boolean)q2.getResultList().isEmpty());
        em.getTransaction().rollback();
    }

    public void testPartiallyRepeatedParameterInSubquery() {
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        String jpql = "select o from OrderJPA o where o.OrderId in (select max(o1.OrderId) from OrderJPA o1 where ((o1.CustomerId = :customerId) and   (o1.WarehouseId = :warehouseId))) and (o.CustomerId = :customerId) and (o.DistrictId = :districtId) and (o.WarehouseId = :warehouseId)";
        em.getTransaction().begin();
        TypedQuery q1 = em.createQuery(jpql, OrderJPA.class);
        q1.setParameter("customerId", (Object)339).setParameter("districtId", (Object)3).setParameter("warehouseId", (Object)23);
        TestPreparedQueryCache.assertEquals((String)"javax.persistence.JPQL", (String)OpenJPAPersistence.cast((Query)q1).getLanguage());
        TestPreparedQueryCache.assertFalse((boolean)q1.getResultList().isEmpty());
        TypedQuery q2 = em.createQuery(jpql, OrderJPA.class);
        TestPreparedQueryCache.assertEquals((String)"openjpa.prepared.SQL", (String)OpenJPAPersistence.cast((Query)q2).getLanguage());
        q2.setParameter("customerId", (Object)2967).setParameter("districtId", (Object)5).setParameter("warehouseId", (Object)22);
        TestPreparedQueryCache.assertFalse((boolean)q2.getResultList().isEmpty());
        em.getTransaction().rollback();
    }

    public void testPartiallyRepeatedParameterInMainquery() {
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        String jpql = "select o from OrderJPA o where o.OrderId in (select max(o1.OrderId) from OrderJPA o1 where ((o1.CustomerId = :customerId) and   (o1.DistrictId = :districtId) and   (o1.WarehouseId = :warehouseId))) and (o.CustomerId = :customerId) and (o.WarehouseId = :warehouseId)";
        em.getTransaction().begin();
        TypedQuery q1 = em.createQuery(jpql, OrderJPA.class);
        q1.setParameter("customerId", (Object)339).setParameter("districtId", (Object)3).setParameter("warehouseId", (Object)23);
        TestPreparedQueryCache.assertEquals((String)"javax.persistence.JPQL", (String)OpenJPAPersistence.cast((Query)q1).getLanguage());
        TestPreparedQueryCache.assertFalse((boolean)q1.getResultList().isEmpty());
        TypedQuery q2 = em.createQuery(jpql, OrderJPA.class);
        TestPreparedQueryCache.assertEquals((String)"openjpa.prepared.SQL", (String)OpenJPAPersistence.cast((Query)q2).getLanguage());
        q2.setParameter("customerId", (Object)2967).setParameter("districtId", (Object)5).setParameter("warehouseId", (Object)22);
        TestPreparedQueryCache.assertFalse((boolean)q2.getResultList().isEmpty());
        em.getTransaction().rollback();
    }

    public void testRangeIsExcluded() {
        List<Company> l = null;
        l = this.getAllCompaniesPaged(0, 1);
        TestPreparedQueryCache.assertEquals((int)1, (int)l.size());
        TestPreparedQueryCache.assertEquals((int)1900, (int)l.get(0).getStartYear());
        l = this.getAllCompaniesPaged(1, 1);
        TestPreparedQueryCache.assertEquals((int)1, (int)l.size());
        TestPreparedQueryCache.assertEquals((int)2000, (int)l.get(0).getStartYear());
        l = this.getAllCompaniesPaged(2, 1);
        TestPreparedQueryCache.assertEquals((int)1, (int)l.size());
        TestPreparedQueryCache.assertEquals((int)2010, (int)l.get(0).getStartYear());
    }

    public List<Company> getAllCompaniesPaged(int start, int max) {
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        Query q = em.createQuery("select p from Company p order by p.startYear");
        q.setFirstResult(start);
        q.setMaxResults(max);
        return q.getResultList();
    }

    PreparedQueryCache getPreparedQueryCache() {
        return emf.getConfiguration().getQuerySQLCacheInstance();
    }

    void compare(String jpql, boolean isNamed) {
        this.compare(jpql, isNamed, -1, NO_PARAMS);
    }

    void compare(String jpql, boolean isNamed, int expectedCount) {
        this.compare(jpql, isNamed, expectedCount, NO_PARAMS);
    }

    void compare(String jpql, boolean isNamed, Object ... params) {
        this.compare(jpql, isNamed, -1, params);
    }

    void compare(String query, boolean isNamed, int expectedCount, Object ... params) {
        this.run(query, isNamed, params, expectedCount, false, 1);
        auditor.clear();
        long without = this.run(query, isNamed, params, expectedCount, false, 100);
        List<String> originalSQLs = auditor.getSQLs();
        auditor.clear();
        long with = this.run(query, isNamed, params, expectedCount, true, 100);
        List<String> cachedSQLs = auditor.getSQLs();
        this.compareSQLs(originalSQLs, cachedSQLs);
        long delta = without == 0L ? 0L : (without - with) * 100L / without;
        String jpql = this.getJPQLString(query, isNamed);
        System.err.println((delta < 0L ? "***WARN " : "") + Math.abs(delta) + "% " + (delta < 0L ? "degradtion" : "improvement") + " for [" + jpql + "]");
        TestPreparedQueryCache.assertTrue((String)(Math.abs(delta) + "% degradtion for [" + jpql + "]"), (!FAIL_IF_PERF_DEGRADE || delta > 0L ? 1 : 0) != 0);
    }

    void compareSQLs(List<String> a, List<String> b) {
        TestPreparedQueryCache.assertEquals((int)a.size(), (int)b.size());
        for (int i = 0; i < a.size(); ++i) {
            TestPreparedQueryCache.assertEquals((String)a.get(i), (String)b.get(i));
        }
    }

    long run(String jpql, boolean isNamedQuery, Object[] params, int expectedCount, boolean useCache, int N) {
        ArrayList<Long> stats = new ArrayList<Long>();
        String cacheKey = this.getJPQLString(jpql, isNamedQuery);
        QueryStatistics cacheStats = this.getPreparedQueryCache().getStatistics();
        this.getPreparedQueryCache().clear();
        TestPreparedQueryCache.assertEquals((long)0L, (long)cacheStats.getExecutionCount((Object)cacheKey));
        TestPreparedQueryCache.assertEquals((long)0L, (long)cacheStats.getHitCount((Object)cacheKey));
        for (int i = 0; i < N; ++i) {
            OpenJPAEntityManagerSPI em = emf.createEntityManager();
            em.setQuerySQLCache(useCache);
            TestPreparedQueryCache.assertEquals((boolean)useCache, (boolean)em.getQuerySQLCache());
            long start = System.nanoTime();
            OpenJPAQuery q = isNamedQuery ? em.createNamedQuery(jpql) : em.createQuery(jpql);
            this.parameterize((Query)q, params);
            List list = q.getResultList();
            if (expectedCount >= 0) {
                TestPreparedQueryCache.assertEquals((int)expectedCount, (int)list.size());
            } else {
                TestPreparedQueryCache.assertFalse((boolean)list.isEmpty());
            }
            this.iterate(list);
            long end = System.nanoTime();
            TestPreparedQueryCache.assertEquals((long)(useCache ? (long)(i + 1) : 0L), (long)cacheStats.getExecutionCount((Object)cacheKey));
            TestPreparedQueryCache.assertEquals((long)(useCache ? (long)i : 0L), (long)cacheStats.getHitCount((Object)cacheKey));
            q.closeAll();
            stats.add(end - start);
            em.close();
        }
        TestPreparedQueryCache.assertEquals((String)("Execution Count [" + cacheKey + "]"), (long)(useCache ? (long)N : 0L), (long)cacheStats.getTotalExecutionCount());
        TestPreparedQueryCache.assertEquals((String)("Hit Count [" + cacheKey + "]"), (long)(useCache ? (long)(N - 1) : 0L), (long)cacheStats.getTotalHitCount());
        Collections.sort(stats);
        return (Long)stats.get(N / 2);
    }

    public void testRepeatedQueryInBetweenParameters() {
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        em.clear();
        String jpql1 = "SELECT e FROM Employee e";
        int employeeSize = em.createQuery(jpql1, Employee.class).getResultList().size();
        String jpql2 = "SELECT e FROM Employee e WHERE :baseDate between e.startDate AND e.endDate";
        TypedQuery q1 = em.createQuery(jpql2, Employee.class);
        q1.setParameter("baseDate", (Object)new GregorianCalendar(2016, 5, 1).getTime());
        int count2016 = (int)((double)employeeSize * 0.6666666666666666);
        TestPreparedQueryCache.assertEquals((int)count2016, (int)q1.getResultList().size());
        TypedQuery q2 = em.createQuery(jpql2, Employee.class);
        q2.setParameter("baseDate", (Object)new GregorianCalendar(2017, 5, 1).getTime());
        int count2017 = (int)((double)employeeSize * 0.6666666666666666);
        TestPreparedQueryCache.assertEquals((int)count2017, (int)q2.getResultList().size());
    }

    void parameterize(Query q, Object[] params) {
        if (params == null) {
            return;
        }
        for (int j = 0; params != null && j < params.length - 1; j += 2) {
            Object key = params[j];
            Object val = params[j + 1];
            if (key instanceof Integer) {
                q.setParameter(((Number)key).intValue(), val);
                continue;
            }
            if (key instanceof String) {
                q.setParameter(key.toString(), val);
                continue;
            }
            TestPreparedQueryCache.fail((String)("key " + key + " is neither Number nor String"));
        }
    }

    void iterate(List<?> list) {
        Iterator<?> i = list.iterator();
        while (i.hasNext()) {
            i.next();
        }
    }

    String getJPQLString(String name, boolean isNamedQuery) {
        if (!isNamedQuery) {
            return name;
        }
        return emf.getConfiguration().getMetaDataRepositoryInstance().getQueryMetaData(null, name, null, true).getQueryString();
    }

    static {
        COMPANY_NAMES = new String[]{"IBM", "BEA", "acme.org"};
        START_YEARS = new int[]{1900, 2000, 2010};
        DEPARTMENT_NAMES = new String[]{"Marketing", "Sales", "Engineering"};
        EMPLOYEE_NAMES = new String[]{"Tom", "Dick", "Harray"};
        EMPLOYEE_START_DATES = new Date[]{new GregorianCalendar(2017, 1, 12).getTime(), new GregorianCalendar(2014, 0, 1).getTime(), new GregorianCalendar(2014, 0, 1).getTime()};
        EMPLOYEE_END_DATES = new Date[]{new GregorianCalendar(2999, 0, 1).getTime(), new GregorianCalendar(2999, 0, 1).getTime(), new GregorianCalendar(2016, 11, 31).getTime()};
        CITY_NAMES = new String[]{"Tulsa", "Durban", "Harlem"};
        BOOK_IDS = new long[]{1000L, 2000L, 3000L};
        BOOK_NAMES = new String[]{"Argumentative Indian", "Tin Drum", "Blink"};
        CD_IDS = new long[]{1001L, 2001L, 3001L};
        CD_LABELS = new String[]{"Beatles", "Sinatra", "Don't Rock My Boat"};
        TEST_COUNT = 0;
    }

    public static class QueryThread
    implements Runnable {
        private final OpenJPAEntityManager em;
        private final String jpql;
        private boolean failed = false;

        public QueryThread(OpenJPAEntityManager em, String jpql) {
            this.em = em;
            this.jpql = jpql;
        }

        @Override
        public void run() {
            try {
                for (int i = 0; i < 10 && !this.failed; ++i) {
                    OpenJPAQuery q = this.em.createQuery(this.jpql);
                    q.setParameter("name", (Object)("Author-" + i));
                    q.getResultList();
                    if (i <= 1) continue;
                    TestCase.assertEquals((String)"openjpa.prepared.SQL", (String)q.getLanguage());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.failed = true;
            }
        }

        public boolean isFailed() {
            return this.failed;
        }
    }

    public class SQLAuditor
    extends AbstractJDBCListener {
        private List<String> sqls = new ArrayList<String>();

        public void beforeExecuteStatement(JDBCEvent event) {
            if (event.getSQL() != null && this.sqls != null) {
                this.sqls.add(event.getSQL());
            }
        }

        void clear() {
            this.sqls.clear();
        }

        List<String> getSQLs() {
            return new ArrayList<String>(this.sqls);
        }
    }
}

