/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.sqlcache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import junit.framework.TestCase;
import org.apache.openjpa.kernel.QueryStatistics;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.jdbc.sqlcache.Person;

public class TestMultithreadedReparameterization
extends TestCase {
    private static String RESOURCE = "META-INF/persistence.xml";
    private static String UNIT_NAME = "PreparedQuery";
    protected static OpenJPAEntityManagerFactory emf;

    public void setUp() throws Exception {
        super.setUp();
        if (emf == null) {
            Properties config = new Properties();
            config.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true,SchemaAction='drop,add')");
            config.put("openjpa.Log", "SQL=WARN");
            config.put("openjpa.jdbc.QuerySQLCache", "true(EnableStatistics=true, MaxCacheSize=2)");
            config.put("openjpa.ConnectionFactoryProperties", "PrintParameters=true");
            emf = OpenJPAPersistence.createEntityManagerFactory((String)UNIT_NAME, (String)RESOURCE, (Map)config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReparameterizationUnderHeavyLoad() throws Exception {
        long baseId = System.currentTimeMillis();
        OpenJPAEntityManager em = emf.createEntityManager();
        em.getTransaction().begin();
        int nThreads = 80;
        for (int i = 0; i < nThreads; ++i) {
            Person p = new Person();
            p.setId(baseId + (long)i);
            p.setFirstName("First" + i);
            p.setLastName("Last" + i);
            p.setAge((short)(20 + i));
            em.persist((Object)p);
        }
        em.getTransaction().commit();
        String jpql = "select p from Person p where p.id=:id and p.firstName=:first and p.lastName=:last and p.age=:age";
        int nRepeats = 20;
        Thread[] threads = new Thread[nThreads];
        List<Throwable> exceptions = Collections.synchronizedList(new ArrayList());
        for (int i = 0; i < nThreads; ++i) {
            Object[] args = new Object[]{"id", baseId + (long)i, "first", "First" + i, "last", "Last" + i, "age", (short)(20 + i)};
            QueryThread thread = new QueryThread((EntityManager)emf.createEntityManager(), jpql, args, nRepeats, exceptions);
            threads[i] = new Thread(thread);
        }
        for (Thread thread : threads) {
            thread.start();
        }
        for (Thread thread : threads) {
            thread.join();
        }
        try {
            QueryStatistics stats = emf.getConfiguration().getQuerySQLCacheInstance().getStatistics();
            for (Throwable t : exceptions) {
                TestMultithreadedReparameterization.fail((String)(t.getCause() != null ? t.getCause().toString() : t.toString()));
            }
            TestMultithreadedReparameterization.assertEquals((float)(nThreads * nRepeats), (float)stats.getExecutionCount(), (float)stats.getExecutionCount((Object)jpql));
            TestMultithreadedReparameterization.assertEquals((float)(nThreads * nRepeats - 1), (float)stats.getExecutionCount(), (float)stats.getHitCount((Object)jpql));
        }
        finally {
            emf.getConfiguration().getQuerySQLCacheInstance().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCacheSwappingUnderHeavyLoad() throws Exception {
        int nRuns = 10;
        int nThreads = 20;
        int nQueries = 10;
        final List<Throwable> exceptions = Collections.synchronizedList(new ArrayList());
        for (int y = 0; y < 10; ++y) {
            Thread[] threads = new Thread[20];
            for (int i = 0; i < 20; ++i) {
                threads[i] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            OpenJPAEntityManager em = emf.createEntityManager();
                            String qStr = "select p from Person p where p.firstName=:first and p.id = ";
                            for (int j = 0; j < 10; ++j) {
                                Query q = em.createQuery(qStr + j);
                                q.setParameter("first", (Object)"test");
                                q.getResultList();
                            }
                            em.close();
                        }
                        catch (Throwable t) {
                            System.err.println("\nThread (" + Thread.currentThread().getName() + "): Caught the following exception: " + t + "\n  With cause: " + t.getCause());
                            exceptions.add(t);
                        }
                    }
                });
                threads[i].start();
            }
            Thread[] threadArray = threads;
            int n = threadArray.length;
            for (int i = 0; i < n; ++i) {
                Thread thread;
                Thread thread2 = thread = threadArray[i];
                synchronized (thread2) {
                    try {
                        thread.join();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
            }
            try {
                for (Throwable t : exceptions) {
                    TestMultithreadedReparameterization.fail((String)(t.getCause() != null ? t.getCause().toString() : t.toString()));
                }
                continue;
            }
            finally {
                emf.getConfiguration().getQuerySQLCacheInstance().clear();
            }
        }
    }

    public static class QueryThread
    implements Runnable {
        public final EntityManager em;
        public final String jpql;
        public final Object[] args;
        public final int nTimes;
        public final List<Throwable> exceptions;

        public QueryThread(EntityManager em, String jpql, Object[] args, int r, List<Throwable> exceptions) {
            this.em = em;
            this.jpql = jpql;
            this.args = args;
            this.nTimes = r;
            this.exceptions = exceptions;
        }

        @Override
        public void run() {
            try {
                for (int i = 0; i < this.nTimes; ++i) {
                    TypedQuery q = this.em.createQuery(this.jpql, Person.class);
                    for (int j = 0; j < this.args.length; j += 2) {
                        q.setParameter(this.args[j].toString(), this.args[j + 1]);
                    }
                    List result = q.getResultList();
                    TestCase.assertEquals((String)(Thread.currentThread() + " failed"), (int)1, (int)result.size());
                    Person p = (Person)result.get(0);
                    TestCase.assertEquals((Object)this.args[1], (Object)p.getId());
                    TestCase.assertEquals((Object)this.args[3], (Object)p.getFirstName());
                    TestCase.assertEquals((Object)this.args[5], (Object)p.getLastName());
                    TestCase.assertEquals((Object)this.args[7], (Object)p.getAge());
                }
            }
            catch (Throwable t) {
                this.exceptions.add(t);
            }
        }
    }
}

