/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.sqlcache;

import java.util.Arrays;
import java.util.List;
import javax.persistence.TypedQuery;
import org.apache.openjpa.kernel.PreparedQuery;
import org.apache.openjpa.kernel.PreparedQueryCache;
import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.jdbc.sqlcache.Address;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestInExpressionParameterBinding
extends SingleEMFTestCase {
    private static OpenJPAEntityManagerFactory _emf;
    private static List<Integer> ORIGINAL_ZIPS;
    private OpenJPAEntityManager _em;

    @Override
    public void setUp() throws Exception {
        if (_emf == null) {
            super.setUp(Address.class, "openjpa.ConnectionFactoryProperties", "PrintParameters=true", CLEAR_TABLES);
            _emf = this.emf;
            ORIGINAL_ZIPS = Arrays.asList(12345, 23456, 34567, 45678, 56789, 67890);
            this.createData();
        }
        this.getPreparedQueryCache().clear();
        this._em = _emf.createEntityManager();
    }

    @Override
    public void tearDown() throws Exception {
    }

    private void createData() {
        OpenJPAEntityManager em = _emf.createEntityManager();
        em.getTransaction().begin();
        for (Integer originalZip : ORIGINAL_ZIPS) {
            Address a = new Address();
            a.setZip(originalZip);
            em.persist((Object)a);
        }
        em.getTransaction().commit();
    }

    public void testWithCollectionParamOfDifferentSize() {
        String jpql = "select a from Address a where a.zip in (:p)";
        List<Integer> zips1 = ORIGINAL_ZIPS.subList(0, 3);
        List result1 = this._em.createQuery(jpql, Address.class).setParameter("p", zips1).getResultList();
        TestInExpressionParameterBinding.assertEquals((int)zips1.size(), (int)result1.size());
        this.assertNotCached(jpql);
        List<Integer> zips2 = ORIGINAL_ZIPS.subList(2, 4);
        List result2 = this._em.createQuery(jpql, Address.class).setParameter("p", zips2).getResultList();
        TestInExpressionParameterBinding.assertEquals((int)zips2.size(), (int)result2.size());
    }

    public void testWithCollectionParamOfDifferentSizeNoParentheses() {
        String jpql = "select a from Address a where a.zip in :p";
        List<Integer> zips1 = ORIGINAL_ZIPS.subList(0, 3);
        List result1 = this._em.createQuery(jpql, Address.class).setParameter("p", zips1).getResultList();
        TestInExpressionParameterBinding.assertEquals((int)zips1.size(), (int)result1.size());
        this.assertNotCached(jpql);
        List<Integer> zips2 = ORIGINAL_ZIPS.subList(2, 4);
        List result2 = this._em.createQuery(jpql, Address.class).setParameter("p", zips2).getResultList();
        TestInExpressionParameterBinding.assertEquals((int)zips2.size(), (int)result2.size());
    }

    public void testWithSingleParam() {
        String jpql = "select a from Address a where a.zip in (:p)";
        Integer zip1 = ORIGINAL_ZIPS.get(4);
        List result1 = this._em.createQuery(jpql, Address.class).setParameter("p", (Object)zip1).getResultList();
        TestInExpressionParameterBinding.assertEquals((int)1, (int)result1.size());
        TestInExpressionParameterBinding.assertEquals((int)zip1, (int)((Address)result1.get(0)).getZip());
        this.assertNotCached(jpql);
        Integer zip2 = ORIGINAL_ZIPS.get(2);
        List result2 = this._em.createQuery(jpql, Address.class).setParameter("p", (Object)zip2).getResultList();
        TestInExpressionParameterBinding.assertEquals((int)1, (int)result2.size());
        TestInExpressionParameterBinding.assertEquals((int)zip2, (int)((Address)result2.get(0)).getZip());
    }

    public void testWithMultiplParamOfDifferentSizeNoParentheses() {
        String jpql = "select a from Address a where a.zip in (:p1,:p2,:p3)";
        List<Integer> zips1 = ORIGINAL_ZIPS.subList(0, 3);
        TypedQuery query1 = this._em.createQuery(jpql, Address.class);
        query1.setParameter("p1", (Object)zips1.get(0));
        query1.setParameter("p2", (Object)zips1.get(1));
        query1.setParameter("p3", (Object)zips1.get(2));
        List result1 = query1.getResultList();
        TestInExpressionParameterBinding.assertEquals((int)zips1.size(), (int)result1.size());
        this.assertNotCached(jpql);
        List<Integer> zips2 = ORIGINAL_ZIPS.subList(2, 5);
        TypedQuery query2 = this._em.createQuery(jpql, Address.class);
        query2.setParameter("p1", (Object)zips2.get(0));
        query2.setParameter("p2", (Object)zips2.get(1));
        query2.setParameter("p3", (Object)zips2.get(2));
        List result2 = query2.getResultList();
        TestInExpressionParameterBinding.assertEquals((int)zips2.size(), (int)result2.size());
    }

    public void testWithSingleParamNoParentheses() {
        OpenJPAEntityManager em = _emf.createEntityManager();
        String jpql = "select a from Address a where a.zip in :p";
        Integer zip = ORIGINAL_ZIPS.get(4);
        TypedQuery q = em.createQuery(jpql, Address.class);
        q.setParameter("p", (Object)zip);
        try {
            List result = q.getResultList();
            TestInExpressionParameterBinding.fail((String)"Expected error in execution because single-valued parameter not acceptable without parenthese");
        }
        catch (ArgumentException argumentException) {
            // empty catch block
        }
    }

    void assertCached(String id) {
        PreparedQuery cached = this.getPreparedQueryCache().get(id);
        TestInExpressionParameterBinding.assertNotNull((String)(this.getPreparedQueryCache() + ": " + this.getPreparedQueryCache().getMapView() + " does not contain " + id), (Object)cached);
    }

    void assertNotCached(String id) {
        PreparedQueryCache cache = this.getPreparedQueryCache();
        if (cache != null) {
            TestInExpressionParameterBinding.assertNull((Object)cache.get(id));
        }
    }

    PreparedQueryCache getPreparedQueryCache() {
        return _emf.getConfiguration().getQuerySQLCacheInstance();
    }
}

