/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.sqlcache;

import java.util.ArrayList;
import java.util.Collections;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.kernel.FinderCache;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.sqlcache.Address;
import org.apache.openjpa.persistence.jdbc.sqlcache.Author;
import org.apache.openjpa.persistence.jdbc.sqlcache.Book;
import org.apache.openjpa.persistence.jdbc.sqlcache.CD;
import org.apache.openjpa.persistence.jdbc.sqlcache.Merchandise;
import org.apache.openjpa.persistence.jdbc.sqlcache.Person;
import org.apache.openjpa.persistence.jdbc.sqlcache.Singer;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestFinderCache
extends SQLListenerTestCase {
    public static final long[] BOOK_IDS = new long[]{1000L, 2000L, 3000L};
    public static final String[] BOOK_NAMES = new String[]{"Argumentative Indian", "Tin Drum", "Blink"};
    public static final long[] CD_IDS = new long[]{1001L, 2001L, 3001L};
    public static final String[] CD_LABELS = new String[]{"Beatles", "Sinatra", "Don't Rock My Boat"};

    void createTestData() {
        int i;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        for (i = 0; i < BOOK_IDS.length; ++i) {
            Book book = new Book();
            book.setId(BOOK_IDS[i]);
            book.setTitle(BOOK_NAMES[i]);
            em.persist((Object)book);
        }
        for (i = 0; i < CD_IDS.length; ++i) {
            CD cd = new CD();
            cd.setId(CD_IDS[i]);
            cd.setLabel(CD_LABELS[i]);
            em.persist((Object)cd);
        }
        em.getTransaction().commit();
        em.close();
    }

    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES, "openjpa.RuntimeUnenhancedClasses", "unsupported", "openjpa.DynamicEnhancementAgent", "false", "openjpa.DataCache", "false", Merchandise.class, Book.class, CD.class, Author.class, Person.class, Singer.class, Address.class);
        this.createTestData();
    }

    public void testFinder() {
        OpenJPAEntityManagerFactorySPI emf1 = this.createEMF("openjpa.jdbc.FinderCache", "false");
        this.run(1, Book.class, BOOK_IDS);
        TestFinderCache.assertNull((Object)this.getCache(emf1));
        OpenJPAEntityManagerFactorySPI emf2 = this.createEMF("openjpa.jdbc.FinderCache", "true");
        TestFinderCache.assertNotNull((Object)this.getCache(emf2));
        this.closeEMF((EntityManagerFactory)emf1);
        this.closeEMF((EntityManagerFactory)emf2);
    }

    public void testSQLEventListener() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        int N = 3;
        this.sql.clear();
        for (int i = 0; i < N; ++i) {
            em.clear();
            for (long id : BOOK_IDS) {
                Book pc = (Book)em.find(Book.class, (Object)id);
                TestFinderCache.assertNotNull((Object)pc);
            }
        }
        TestFinderCache.assertEquals((int)(BOOK_IDS.length * N), (int)this.sql.size());
        em.close();
    }

    <T> long run(int N, Class<T> cls, long[] ids) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        ArrayList<Long> stats = new ArrayList<Long>();
        for (int n = 0; n < N; ++n) {
            em.clear();
            long start = System.nanoTime();
            for (long id : ids) {
                Object pc = em.find(cls, (Object)id);
                TestFinderCache.assertNotNull((Object)pc);
                TestFinderCache.assertTrue((boolean)cls.isInstance(pc));
            }
            long end = System.nanoTime();
            stats.add(end - start);
        }
        Collections.sort(stats);
        return (Long)stats.get(N / 2);
    }

    FinderCache getCache(OpenJPAEntityManagerFactorySPI oemf) {
        return ((JDBCConfiguration)oemf.getConfiguration()).getFinderCacheInstance();
    }
}

