/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.schema;

import java.io.IOException;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.schema.PrimaryKey;
import org.apache.openjpa.jdbc.schema.Schema;
import org.apache.openjpa.jdbc.schema.SchemaGroup;
import org.apache.openjpa.jdbc.schema.Sequence;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.schema.XMLSchemaParser;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;
import org.apache.openjpa.persistence.jdbc.schema.TestSchema;

public class TestXMLSchemaParser
extends BaseJDBCTest {
    protected JDBCConfiguration conf = null;
    private SchemaGroup _group = null;

    public TestXMLSchemaParser() {
    }

    public TestXMLSchemaParser(String test) {
        super(test);
    }

    public void setUp() throws Exception {
        this.conf = new JDBCConfigurationImpl();
        this._group = this.getSchemaGroup();
    }

    protected SchemaGroup parseSchemaGroup() throws IOException {
        SCMSchemaParser parser = new SCMSchemaParser(this.conf);
        parser.parse(TestXMLSchemaParser.class, false);
        parser.parse(TestSchema.class, false);
        return parser.getSchemaGroup();
    }

    protected SchemaGroup getSchemaGroup() throws Exception {
        return this.parseSchemaGroup();
    }

    public void testSchemaParsing() {
        TestXMLSchemaParser.assertEquals((int)2, (int)this._group.getSchemas().length);
        TestXMLSchemaParser.assertEquals((String)"SCHEMA1", (String)this._group.getSchema("SCHEMA1").getName());
        TestXMLSchemaParser.assertEquals((String)"SCHEMA2", (String)this._group.getSchema("SCHEMA2").getName());
    }

    public void testSequenceParsing() {
        Schema schema = this._group.getSchema("SCHEMA1");
        TestXMLSchemaParser.assertEquals((int)2, (int)schema.getSequences().length);
        TestXMLSchemaParser.assertEquals((int)0, (int)this._group.getSchema("SCHEMA2").getSequences().length);
        Sequence seq1 = schema.getSequence("SEQ1");
        TestXMLSchemaParser.assertNotNull((Object)seq1);
        TestXMLSchemaParser.assertEquals((String)"SEQ1", (String)seq1.getName());
        TestXMLSchemaParser.assertEquals((Object)seq1, (Object)this._group.findSequence("SEQ1"));
        TestXMLSchemaParser.assertEquals((Object)seq1, (Object)this._group.findSequence("SCHEMA1.SEQ1"));
        TestXMLSchemaParser.assertEquals((int)1, (int)seq1.getInitialValue());
        TestXMLSchemaParser.assertEquals((int)1, (int)seq1.getIncrement());
        TestXMLSchemaParser.assertEquals((int)0, (int)seq1.getAllocate());
        Sequence seq2 = schema.getSequence("SEQ2");
        TestXMLSchemaParser.assertNotNull((Object)seq2);
        TestXMLSchemaParser.assertEquals((int)3, (int)seq2.getInitialValue());
        TestXMLSchemaParser.assertEquals((int)5, (int)seq2.getIncrement());
        TestXMLSchemaParser.assertEquals((int)50, (int)seq2.getAllocate());
    }

    public void testTableColumnParsing() {
        Schema schema1 = this._group.getSchema("SCHEMA1");
        Table[] tables = schema1.getTables();
        TestXMLSchemaParser.assertEquals((int)2, (int)tables.length);
        TestXMLSchemaParser.assertEquals((String)"TABLE1", (String)tables[0].getName());
        TestXMLSchemaParser.assertEquals((String)"TABLE3", (String)tables[1].getName());
        Column[] cols = tables[0].getColumns();
        TestXMLSchemaParser.assertEquals((int)2, (int)cols.length);
        TestXMLSchemaParser.assertEquals((String)"COL1", (String)cols[0].getName());
        TestXMLSchemaParser.assertEquals((String)"COL2", (String)cols[1].getName());
        TestXMLSchemaParser.assertEquals((int)12, (int)cols[0].getType());
        TestXMLSchemaParser.assertEquals((int)6, (int)cols[1].getType());
        TestXMLSchemaParser.assertTrue((boolean)cols[0].isNotNull());
        TestXMLSchemaParser.assertTrue((!cols[1].isNotNull() ? 1 : 0) != 0);
        TestXMLSchemaParser.assertEquals((Object)"def", (Object)cols[0].getDefault());
        TestXMLSchemaParser.assertNull((Object)cols[1].getDefault());
    }

    public void testPrimaryKeyParsing() {
        Table table = this._group.getSchema("SCHEMA1").getTable("TABLE1");
        PrimaryKey pk = table.getPrimaryKey();
        TestXMLSchemaParser.assertNotNull((Object)pk);
        TestXMLSchemaParser.assertEquals((String)"PK1", (String)pk.getName());
        TestXMLSchemaParser.assertTrue((boolean)pk.isLogical());
        TestXMLSchemaParser.assertEquals((int)1, (int)pk.getColumns().length);
        TestXMLSchemaParser.assertEquals((Object)table.getColumn("COL1"), (Object)pk.getColumns()[0]);
        table = this._group.getSchema("SCHEMA2").getTable("TABLE2");
        pk = table.getPrimaryKey();
        TestXMLSchemaParser.assertNotNull((Object)pk);
        TestXMLSchemaParser.assertEquals((String)"PK2", (String)pk.getName());
        TestXMLSchemaParser.assertTrue((!pk.isLogical() ? 1 : 0) != 0);
        TestXMLSchemaParser.assertEquals((int)2, (int)pk.getColumns().length);
        TestXMLSchemaParser.assertEquals((Object)table.getColumn("COL1"), (Object)pk.getColumns()[0]);
        TestXMLSchemaParser.assertEquals((Object)table.getColumn("COL2"), (Object)pk.getColumns()[1]);
    }

    public void testIndexParsing() {
        Table table = this._group.getSchema("SCHEMA1").getTable("TABLE1");
        Index idx = table.getIndex("IDX1");
        TestXMLSchemaParser.assertNotNull((Object)idx);
        TestXMLSchemaParser.assertTrue((boolean)idx.isUnique());
        TestXMLSchemaParser.assertEquals((int)1, (int)idx.getColumns().length);
        TestXMLSchemaParser.assertEquals((Object)table.getColumn("COL2"), (Object)idx.getColumns()[0]);
        table = this._group.getSchema("SCHEMA2").getTable("TABLE2");
        idx = table.getIndex("IDX2");
        TestXMLSchemaParser.assertNotNull((Object)idx);
        TestXMLSchemaParser.assertTrue((!idx.isUnique() ? 1 : 0) != 0);
        TestXMLSchemaParser.assertEquals((int)2, (int)idx.getColumns().length);
        TestXMLSchemaParser.assertEquals((Object)table.getColumn("COL1"), (Object)idx.getColumns()[0]);
        TestXMLSchemaParser.assertEquals((Object)table.getColumn("COL2"), (Object)idx.getColumns()[1]);
    }

    public void testForeignKeyParsing() {
        Table table1 = this._group.getSchema("SCHEMA1").getTable("TABLE1");
        Table table2 = this._group.getSchema("SCHEMA2").getTable("TABLE2");
        ForeignKey fk = table1.getForeignKeys()[0];
        TestXMLSchemaParser.assertEquals((String)"FK1", (String)fk.getName());
        TestXMLSchemaParser.assertNotNull((Object)fk);
        TestXMLSchemaParser.assertEquals((int)2, (int)fk.getDeleteAction());
        Column[] cols = fk.getColumns();
        Column[] pkCols = fk.getPrimaryKeyColumns();
        TestXMLSchemaParser.assertEquals((int)2, (int)cols.length);
        TestXMLSchemaParser.assertEquals((int)2, (int)pkCols.length);
        TestXMLSchemaParser.assertEquals((Object)table1.getColumn("COL1"), (Object)cols[0]);
        TestXMLSchemaParser.assertEquals((Object)table2.getColumn("COL1"), (Object)pkCols[0]);
        TestXMLSchemaParser.assertEquals((Object)table1.getColumn("COL2"), (Object)cols[1]);
        TestXMLSchemaParser.assertEquals((Object)table2.getColumn("COL2"), (Object)pkCols[1]);
        fk = table2.getForeignKeys()[0];
        TestXMLSchemaParser.assertEquals((String)"FK2", (String)fk.getName());
        TestXMLSchemaParser.assertNotNull((Object)fk);
        TestXMLSchemaParser.assertEquals((int)1, (int)fk.getDeleteAction());
        cols = fk.getColumns();
        pkCols = fk.getPrimaryKeyColumns();
        TestXMLSchemaParser.assertEquals((int)1, (int)cols.length);
        TestXMLSchemaParser.assertEquals((int)1, (int)pkCols.length);
        TestXMLSchemaParser.assertEquals((Object)table2.getColumn("COL2"), (Object)cols[0]);
        TestXMLSchemaParser.assertEquals((Object)table1.getColumn("COL1"), (Object)pkCols[0]);
    }

    public static void main(String[] args) {
    }

    public static class SCMSchemaParser
    extends XMLSchemaParser {
        public SCMSchemaParser(JDBCConfiguration conf) {
            super(conf);
            this.setSuffix(".scm");
        }
    }
}

