/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.schema;

import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.jdbc.kernel.ClassTableJDBCSeq;
import org.apache.openjpa.jdbc.kernel.TableJDBCSeq;
import org.apache.openjpa.kernel.Seq;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.SequenceMetaData;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.jdbc.common.apps.SeqA;
import org.apache.openjpa.persistence.jdbc.common.apps.SeqD;
import org.apache.openjpa.persistence.jdbc.kernel.TestSQLListenerTestCase;

public class TestSequenceGeneratorEnsureCapacityCall
extends TestSQLListenerTestCase {
    public TestSequenceGeneratorEnsureCapacityCall(String name) {
        super(name);
    }

    public void testDBSequenceFactory() {
        TableJDBCSeq seq = (TableJDBCSeq)this.seqForClass(SeqA.class);
        this.incrementTest(SeqA.class, seq.getAllocate());
    }

    public void testClassDBSequenceFactory() {
        ClassTableJDBCSeq seq = (ClassTableJDBCSeq)this.seqForClass(SeqD.class);
        this.incrementTest(SeqD.class, seq.getAllocate());
    }

    private void incrementTest(Class cls, int generatorIncrement) {
        int amountToIncrement = generatorIncrement * 2;
        OpenJPAEntityManager pm = this.currentEntityManager();
        Object s = null;
        s.setAllocate(amountToIncrement);
        sql.clear();
        for (int i = 0; i < amountToIncrement; ++i) {
            s.getIncrement();
            TestSequenceGeneratorEnsureCapacityCall.assertEquals((String)("SQL list should have been empty on sequence fetch #" + i + " of #" + amountToIncrement + ", but contained: " + sql), (int)0, (int)sql.size());
        }
    }

    private Seq seqForClass(Class cls) {
        OpenJPAConfiguration conf = this.getConfiguration();
        ClassMetaData meta = conf.getMetaDataRepositoryInstance().getMetaData(cls, null, true);
        SequenceMetaData smeta = meta.getIdentitySequenceMetaData();
        return smeta == null ? conf.getSequenceInstance() : smeta.getInstance(null);
    }
}

