/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.schema;

import java.io.File;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.identifier.QualifiedDBIdentifier;
import org.apache.openjpa.jdbc.meta.MappingTool;
import org.apache.openjpa.jdbc.schema.SchemaGroup;
import org.apache.openjpa.jdbc.schema.SchemaTool;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.OracleDictionary;
import org.apache.openjpa.jdbc.sql.PostgresDictionary;
import org.apache.openjpa.jdbc.sql.SQLServerDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.jdbc.common.apps.InvertA;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;

public class TestSchemaGenerationProperties
extends BaseJDBCTest {
    private static final String[] TABLES_NAME = new String[]{"AUTOINCPC1", "AUTOINCPC3", "CONJOINPC4", "CONJOINPC5", "CUSTMAPPC", "DFGTEST", "EAGERPC", "EAGERPCSUB", "HELPERPC", "HELPERPC2", "HELPERPC3", "INVERTA", "INVERTB", "EAGEROUTERJOINPC"};

    public TestSchemaGenerationProperties(String name) {
        super(name);
    }

    @Override
    protected String getPersistenceUnitName() {
        return "TestConv";
    }

    @Override
    protected void addProperties(Map map) {
    }

    public void setUp() throws Exception {
        super.setUp();
        OpenJPAEntityManagerFactory pmf = this.getEmf(new HashMap());
        pmf.createEntityManager();
        JDBCConfiguration conf = (JDBCConfiguration)((OpenJPAEntityManagerFactorySPI)pmf).getConfiguration();
        MappingTool tool = new MappingTool(conf, "drop", false);
        SchemaTool schemaTool = new SchemaTool(conf, "drop");
        schemaTool.setSchemaGroup(tool.getSchemaGroup());
        schemaTool.run();
    }

    public void testSchemaGenMetadataDrop() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("javax.persistence.schema-generation.database.action", "drop");
        SchemaGroup dbSchemaGroup = this.getSchemaGroup(properties);
        for (String tableName : TABLES_NAME) {
            TestSchemaGenerationProperties.assertNull((String)("Table " + tableName + " should not exist in the DB."), (Object)dbSchemaGroup.findTable(QualifiedDBIdentifier.getPath((DBIdentifier)DBIdentifier.newTable((String)tableName))));
        }
    }

    public void testSchemaGenMetadataCreate() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("javax.persistence.schema-generation.database.action", "create");
        SchemaGroup dbSchemaGroup = this.getSchemaGroup(properties);
        for (String tableName : TABLES_NAME) {
            TestSchemaGenerationProperties.assertNotNull((String)("Table " + tableName + " should have been created in the DB, but does not exists."), (Object)dbSchemaGroup.findTable(QualifiedDBIdentifier.getPath((DBIdentifier)DBIdentifier.newTable((String)tableName))));
        }
    }

    public void testSchemaGenMetadataDropAndCreate() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("javax.persistence.schema-generation.database.action", "drop-and-create");
        SchemaGroup dbSchemaGroup = this.getSchemaGroup(properties);
        for (String tableName : TABLES_NAME) {
            TestSchemaGenerationProperties.assertNotNull((String)("Table " + tableName + " should have been created in the DB, but does not exists."), (Object)dbSchemaGroup.findTable(QualifiedDBIdentifier.getPath((DBIdentifier)DBIdentifier.newTable((String)tableName))));
        }
    }

    public void testSchemaGenScriptDrop() throws Exception {
        this.testSchemaGenMetadataCreate();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("javax.persistence.schema-generation.database.action", "drop");
        properties.put("javax.persistence.schema-generation.drop-source", "script");
        properties.put("javax.persistence.schema-generation.drop-script-source", "org/apache/openjpa/persistence/jdbc/schema/drop.sql");
        SchemaGroup dbSchemaGroup = this.getSchemaGroup(properties);
        for (String tableName : TABLES_NAME) {
            TestSchemaGenerationProperties.assertNull((String)("Table " + tableName + " should not exist in the DB."), (Object)dbSchemaGroup.findTable(QualifiedDBIdentifier.getPath((DBIdentifier)DBIdentifier.newTable((String)tableName))));
        }
    }

    public void testSchemaGenScriptCreate() throws Exception {
        this.testSchemaGenMetadataDrop();
        JDBCConfiguration conf = (JDBCConfiguration)this.getPM().getConfiguration();
        DBDictionary dict = conf.getDBDictionaryInstance();
        String createSql = dict instanceof PostgresDictionary ? "org/apache/openjpa/persistence/jdbc/schema/create-postgresql.sql" : "org/apache/openjpa/persistence/jdbc/schema/create.sql";
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("javax.persistence.schema-generation.database.action", "create");
        properties.put("javax.persistence.schema-generation.create-source", "script");
        properties.put("javax.persistence.schema-generation.create-script-source", createSql);
        SchemaGroup dbSchemaGroup = this.getSchemaGroup(properties);
        for (String tableName : TABLES_NAME) {
            TestSchemaGenerationProperties.assertNotNull((String)("Table " + tableName + " should have been created in the DB, but does not exists."), (Object)dbSchemaGroup.findTable(QualifiedDBIdentifier.getPath((DBIdentifier)DBIdentifier.newTable((String)tableName))));
        }
    }

    public void testSchemaGenScriptDropAndCreate() throws Exception {
        this.testSchemaGenMetadataCreate();
        JDBCConfiguration conf = (JDBCConfiguration)this.getPM().getConfiguration();
        DBDictionary dict = conf.getDBDictionaryInstance();
        String createSql = dict instanceof PostgresDictionary ? "org/apache/openjpa/persistence/jdbc/schema/create-postgresql.sql" : (dict instanceof SQLServerDictionary ? "org/apache/openjpa/persistence/jdbc/schema/create-mssql.sql" : (dict instanceof OracleDictionary ? "org/apache/openjpa/persistence/jdbc/schema/create-oracle.sql" : "org/apache/openjpa/persistence/jdbc/schema/create.sql"));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("javax.persistence.schema-generation.database.action", "drop-and-create");
        properties.put("javax.persistence.schema-generation.drop-source", "script");
        properties.put("javax.persistence.schema-generation.drop-script-source", "org/apache/openjpa/persistence/jdbc/schema/drop.sql");
        properties.put("javax.persistence.schema-generation.create-source", "script");
        properties.put("javax.persistence.schema-generation.create-script-source", createSql);
        SchemaGroup dbSchemaGroup = this.getSchemaGroup(properties);
        for (String tableName : TABLES_NAME) {
            TestSchemaGenerationProperties.assertNotNull((String)("Table " + tableName + " should have been created in the DB, but does not exists."), (Object)dbSchemaGroup.findTable(QualifiedDBIdentifier.getPath((DBIdentifier)DBIdentifier.newTable((String)tableName))));
        }
    }

    public void testSchemaGenMetadataThenScriptDropAndCreate() throws Exception {
        try {
            OpenJPAEntityManagerFactory pmf = this.getEmf();
            pmf.createEntityManager();
            JDBCConfiguration conf = (JDBCConfiguration)((OpenJPAEntityManagerFactorySPI)pmf).getConfiguration();
            SchemaTool schemaTool = new SchemaTool(conf, "executeScript");
            schemaTool.setScriptToExecute("org/apache/openjpa/persistence/jdbc/schema/create-after-metadata.sql");
            schemaTool.run();
        }
        catch (SQLException pmf) {
            // empty catch block
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("javax.persistence.schema-generation.database.action", "drop-and-create");
        properties.put("javax.persistence.schema-generation.drop-source", "metadata-then-script");
        properties.put("javax.persistence.schema-generation.drop-script-source", "org/apache/openjpa/persistence/jdbc/schema/drop-after-metadata.sql");
        properties.put("javax.persistence.schema-generation.create-source", "metadata-then-script");
        properties.put("javax.persistence.schema-generation.create-script-source", "org/apache/openjpa/persistence/jdbc/schema/create-after-metadata.sql");
        SchemaGroup dbSchemaGroup = this.getSchemaGroup(properties);
        for (String tableName : TABLES_NAME) {
            TestSchemaGenerationProperties.assertNotNull((String)("Table " + tableName + " should have been created in the DB, but does not exists."), (Object)dbSchemaGroup.findTable(QualifiedDBIdentifier.getPath((DBIdentifier)DBIdentifier.newTable((String)tableName))));
        }
        TestSchemaGenerationProperties.assertNotNull((String)"Table CREATE_AFTER_METADATA should have been created in the DB, but does not exists.", (Object)dbSchemaGroup.findTable(QualifiedDBIdentifier.getPath((DBIdentifier)DBIdentifier.newTable((String)"CREATE_AFTER_METADATA"))));
    }

    public void testSchemaGenNoCreateSourceSpecifiedAndCreateScriptSourceSpecified() throws Exception {
        try {
            OpenJPAEntityManagerFactory pmf = this.getEmf();
            pmf.createEntityManager();
            JDBCConfiguration conf = (JDBCConfiguration)((OpenJPAEntityManagerFactorySPI)pmf).getConfiguration();
            SchemaTool schemaTool = new SchemaTool(conf, "executeScript");
            schemaTool.setScriptToExecute("org/apache/openjpa/persistence/jdbc/schema/drop-after-metadata.sql");
            schemaTool.run();
        }
        catch (SQLException pmf) {
            // empty catch block
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("javax.persistence.schema-generation.database.action", "create");
        properties.put("javax.persistence.schema-generation.create-script-source", "org/apache/openjpa/persistence/jdbc/schema/create-after-metadata.sql");
        SchemaGroup dbSchemaGroup = this.getSchemaGroup(properties);
        TestSchemaGenerationProperties.assertNotNull((String)"Table CREATE_AFTER_METADATA should have been created in the DB, but does not exists.", (Object)dbSchemaGroup.findTable(QualifiedDBIdentifier.getPath((DBIdentifier)DBIdentifier.newTable((String)"CREATE_AFTER_METADATA"))));
    }

    public void testSchemaGenNoCreateSourceAndCreateScriptSourceSpecified() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("javax.persistence.schema-generation.database.action", "create");
        SchemaGroup dbSchemaGroup = this.getSchemaGroup(properties);
        for (String tableName : TABLES_NAME) {
            TestSchemaGenerationProperties.assertNotNull((String)("Table " + tableName + " should have been created in the DB, but does not exists."), (Object)dbSchemaGroup.findTable(QualifiedDBIdentifier.getPath((DBIdentifier)DBIdentifier.newTable((String)tableName))));
        }
    }

    public void testSchemaGenNoDropSourceSpecifiedAndDropScriptSourceSpecified() throws Exception {
        this.testSchemaGenMetadataCreate();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("javax.persistence.schema-generation.database.action", "drop");
        properties.put("javax.persistence.schema-generation.drop-script-source", "org/apache/openjpa/persistence/jdbc/schema/drop.sql");
        SchemaGroup dbSchemaGroup = this.getSchemaGroup(properties);
        for (String tableName : TABLES_NAME) {
            TestSchemaGenerationProperties.assertNull((String)("Table " + tableName + " should not exist in the DB."), (Object)dbSchemaGroup.findTable(QualifiedDBIdentifier.getPath((DBIdentifier)DBIdentifier.newTable((String)tableName))));
        }
    }

    public void testSchemaGenScriptLoad() throws Exception {
        this.testSchemaGenMetadataDropAndCreate();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("javax.persistence.sql-load-script-source", "org/apache/openjpa/persistence/jdbc/schema/load.sql");
        OpenJPAEntityManagerFactory pmf = this.getEmf(properties);
        OpenJPAEntityManager entityManager = pmf.createEntityManager();
        JDBCConfiguration conf = (JDBCConfiguration)((OpenJPAEntityManagerFactorySPI)pmf).getConfiguration();
        SchemaTool schemaTool = new SchemaTool(conf);
        SchemaGroup dbSchemaGroup = schemaTool.getDBSchemaGroup();
        for (String tableName : TABLES_NAME) {
            TestSchemaGenerationProperties.assertNotNull((String)("Table " + tableName + " should have been created in the DB, but does not exists."), (Object)dbSchemaGroup.findTable(QualifiedDBIdentifier.getPath((DBIdentifier)DBIdentifier.newTable((String)tableName))));
        }
        InvertA invertA = (InvertA)entityManager.find(InvertA.class, (Object)1);
        TestSchemaGenerationProperties.assertEquals((int)1, (int)invertA.getId());
        TestSchemaGenerationProperties.assertEquals((String)"script load test", (String)invertA.getTest());
    }

    public void testSchemaGenOutputScriptCreate() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("javax.persistence.schema-generation.database.action", "create");
        properties.put("javax.persistence.schema-generation.scripts.create-target", "target/create-db-output.sql");
        this.getEmf(properties).createEntityManager();
        File createFile = new File("target/create-db-output.sql");
        TestSchemaGenerationProperties.assertTrue((boolean)createFile.exists());
        TestSchemaGenerationProperties.assertTrue((createFile.length() > 0L ? 1 : 0) != 0);
    }

    public void testSchemaGenOutputScriptDrop() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("javax.persistence.schema-generation.database.action", "drop");
        properties.put("javax.persistence.schema-generation.scripts.drop-target", "target/drop-db-output.sql");
        this.getEmf(properties).createEntityManager();
        File dropFile = new File("target/drop-db-output.sql");
        TestSchemaGenerationProperties.assertTrue((boolean)dropFile.exists());
        TestSchemaGenerationProperties.assertTrue((dropFile.length() > 0L ? 1 : 0) != 0);
    }

    public void testSchemaGenOutputScriptDropAndCreate() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("javax.persistence.schema-generation.database.action", "drop-and-create");
        properties.put("javax.persistence.schema-generation.scripts.create-target", "target/create-db-output.sql");
        properties.put("javax.persistence.schema-generation.scripts.drop-target", "target/drop-db-output.sql");
        this.getEmf(properties).createEntityManager();
        File createFile = new File("target/create-db-output.sql");
        TestSchemaGenerationProperties.assertTrue((boolean)createFile.exists());
        TestSchemaGenerationProperties.assertTrue((createFile.length() > 0L ? 1 : 0) != 0);
        File dropFile = new File("target/drop-db-output.sql");
        TestSchemaGenerationProperties.assertTrue((boolean)dropFile.exists());
        TestSchemaGenerationProperties.assertTrue((dropFile.length() > 0L ? 1 : 0) != 0);
    }

    private SchemaGroup getSchemaGroup(Map<String, String> properties) {
        OpenJPAEntityManagerFactory pmf = this.getEmf(properties);
        pmf.createEntityManager();
        JDBCConfiguration conf = (JDBCConfiguration)((OpenJPAEntityManagerFactorySPI)pmf).getConfiguration();
        SchemaTool schemaTool = new SchemaTool(conf);
        return schemaTool.getDBSchemaGroup();
    }
}

