/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.schema;

import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.schema.PrimaryKey;
import org.apache.openjpa.jdbc.schema.Schema;
import org.apache.openjpa.jdbc.schema.SchemaGroup;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;

public class TestSchema
extends BaseJDBCTest {
    private Schema _schema = new SchemaGroup().addSchema("schema");

    public TestSchema() {
    }

    public TestSchema(String test) {
        super(test);
    }

    public void testSchema() {
        TestSchema.assertEquals((String)"schema", (String)this._schema.getName());
        TestSchema.assertTrue((boolean)this._schema.getSchemaGroup().isNameTaken("schema"));
        TestSchema.assertTrue((!this._schema.getSchemaGroup().isNameTaken("table1") ? 1 : 0) != 0);
        Table table1 = this._schema.addTable("table1");
        TestSchema.assertTrue((boolean)this._schema.getSchemaGroup().isNameTaken("table1"));
        Table table2 = this._schema.addTable("table2");
        TestSchema.assertTrue((boolean)this._schema.getSchemaGroup().isNameTaken("table2"));
        Table[] tables = this._schema.getTables();
        TestSchema.assertEquals((int)2, (int)tables.length);
        TestSchema.assertEquals((Object)table1, (Object)tables[0]);
        TestSchema.assertEquals((Object)table2, (Object)tables[1]);
        TestSchema.assertEquals((Object)table1, (Object)this._schema.getTable("table1"));
        TestSchema.assertEquals((Object)table2, (Object)this._schema.getTable("table2"));
        TestSchema.assertNull((Object)this._schema.getTable("table3"));
        TestSchema.assertTrue((boolean)this._schema.removeTable(table1));
        TestSchema.assertTrue((!this._schema.getSchemaGroup().isNameTaken("table1") ? 1 : 0) != 0);
        TestSchema.assertNull((Object)this._schema.getTable("table1"));
        TestSchema.assertEquals((Object)table2, (Object)this._schema.getTable("table2"));
        TestSchema.assertTrue((boolean)this._schema.removeTable(table2));
        TestSchema.assertTrue((!this._schema.getSchemaGroup().isNameTaken("table2") ? 1 : 0) != 0);
        TestSchema.assertNull((Object)this._schema.getTable("table2"));
        TestSchema.assertEquals((int)0, (int)this._schema.getTables().length);
    }

    public void testTable() {
        Table table = this._schema.addTable("table");
        TestSchema.assertEquals((Object)this._schema, (Object)table.getSchema());
        TestSchema.assertEquals((String)"table", (String)table.getName());
        TestSchema.assertTrue((!table.isNameTaken("schema") ? 1 : 0) != 0);
        TestSchema.assertTrue((boolean)table.isNameTaken("table"));
        TestSchema.assertNull((Object)table.getPrimaryKey());
        PrimaryKey pk = table.addPrimaryKey("pk");
        TestSchema.assertEquals((Object)table, (Object)pk.getTable());
        TestSchema.assertEquals((Object)pk, (Object)table.getPrimaryKey());
        TestSchema.assertTrue((!table.isNameTaken("pk") ? 1 : 0) != 0);
        TestSchema.assertTrue((boolean)this._schema.getSchemaGroup().isNameTaken("pk"));
        table.removePrimaryKey();
        TestSchema.assertNull((Object)table.getPrimaryKey());
        TestSchema.assertTrue((!this._schema.getSchemaGroup().isNameTaken("pk") ? 1 : 0) != 0);
        Column c2 = table.addColumn("c2");
        Column c1 = table.addColumn("c1");
        TestSchema.assertTrue((boolean)table.isNameTaken("c1"));
        TestSchema.assertTrue((!this._schema.getSchemaGroup().isNameTaken("c1") ? 1 : 0) != 0);
        TestSchema.assertEquals((Object)table, (Object)c1.getTable());
        Column[] cols = table.getColumns();
        TestSchema.assertEquals((int)2, (int)cols.length);
        TestSchema.assertEquals((Object)c2, (Object)cols[0]);
        TestSchema.assertEquals((Object)c1, (Object)cols[1]);
        TestSchema.assertEquals((Object)c1, (Object)table.getColumn("c1"));
        TestSchema.assertEquals((Object)c2, (Object)table.getColumn("c2"));
        TestSchema.assertTrue((boolean)table.removeColumn(c1));
        TestSchema.assertTrue((!table.isNameTaken("c1") ? 1 : 0) != 0);
        TestSchema.assertNull((Object)table.getColumn("c1"));
        ForeignKey fk = table.addForeignKey("fk");
        TestSchema.assertTrue((boolean)this._schema.getSchemaGroup().isNameTaken("fk"));
        TestSchema.assertTrue((!table.isNameTaken("fk") ? 1 : 0) != 0);
        TestSchema.assertEquals((Object)table, (Object)fk.getTable());
        ForeignKey[] fks = table.getForeignKeys();
        TestSchema.assertEquals((int)1, (int)fks.length);
        TestSchema.assertEquals((Object)fk, (Object)fks[0]);
        TestSchema.assertTrue((boolean)table.removeForeignKey(fk));
        TestSchema.assertTrue((!this._schema.getSchemaGroup().isNameTaken("fk") ? 1 : 0) != 0);
        TestSchema.assertEquals((int)0, (int)table.getForeignKeys().length);
        Index idx = table.addIndex("idx");
        TestSchema.assertTrue((boolean)this._schema.getSchemaGroup().isNameTaken("idx"));
        TestSchema.assertTrue((!table.isNameTaken("idx") ? 1 : 0) != 0);
        TestSchema.assertEquals((Object)table, (Object)idx.getTable());
        Index[] idxs = table.getIndexes();
        TestSchema.assertEquals((int)1, (int)idxs.length);
        TestSchema.assertEquals((Object)idx, (Object)idxs[0]);
        TestSchema.assertEquals((Object)idx, (Object)table.getIndex("idx"));
        TestSchema.assertTrue((boolean)table.removeIndex(idx));
        TestSchema.assertTrue((!table.isNameTaken("idx") ? 1 : 0) != 0);
        TestSchema.assertNull((Object)table.getIndex("idx"));
    }

    public void testIndex() {
        Table table = this._schema.addTable("table");
        Column c1 = table.addColumn("c1");
        Column c2 = table.addColumn("c2");
        Table table2 = this._schema.addTable("table2");
        Column c3 = table2.addColumn("c3");
        Index idx = table.addIndex("idx");
        try {
            idx.addColumn(c3);
            TestSchema.fail((String)"Allowed addition of column of another table.");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Column[] cols = idx.getColumns();
        TestSchema.assertEquals((int)0, (int)cols.length);
        idx.addColumn(c1);
        idx.addColumn(c2);
        cols = idx.getColumns();
        TestSchema.assertEquals((int)2, (int)cols.length);
        TestSchema.assertEquals((Object)c1, (Object)cols[0]);
        TestSchema.assertEquals((Object)c2, (Object)cols[1]);
        TestSchema.assertTrue((boolean)idx.removeColumn(c1));
        cols = idx.getColumns();
        TestSchema.assertEquals((int)1, (int)cols.length);
        TestSchema.assertEquals((Object)c2, (Object)cols[0]);
        TestSchema.assertTrue((boolean)idx.removeColumn(c2));
        cols = idx.getColumns();
        TestSchema.assertEquals((int)0, (int)cols.length);
        TestSchema.assertTrue((!idx.isUnique() ? 1 : 0) != 0);
        idx.setUnique(true);
        TestSchema.assertTrue((boolean)idx.isUnique());
    }

    public void testForeignKey() {
        Table table = this._schema.addTable("table");
        Column c1 = table.addColumn("c1");
        Column c2 = table.addColumn("c2");
        Table table2 = this._schema.addTable("table2");
        Column c3 = table2.addColumn("c3");
        Column c4 = table2.addColumn("c4");
        ForeignKey fk = table.addForeignKey("fk");
        try {
            fk.join(c4, c2);
            TestSchema.fail((String)"Allowed addition of column of another table.");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Column[] cols = fk.getColumns();
        Column[] pkCols = fk.getPrimaryKeyColumns();
        TestSchema.assertEquals((int)0, (int)cols.length);
        TestSchema.assertEquals((int)0, (int)pkCols.length);
        PrimaryKey pk = table2.addPrimaryKey("pk");
        pk.addColumn(c3);
        fk.join(c1, c3);
        pk.addColumn(c4);
        fk.join(c2, c4);
        cols = fk.getColumns();
        pkCols = fk.getPrimaryKeyColumns();
        TestSchema.assertEquals((int)2, (int)cols.length);
        TestSchema.assertEquals((Object)c1, (Object)cols[0]);
        TestSchema.assertEquals((Object)c2, (Object)cols[1]);
        TestSchema.assertEquals((Object)c3, (Object)pkCols[0]);
        TestSchema.assertEquals((Object)c4, (Object)pkCols[1]);
        TestSchema.assertTrue((boolean)fk.removeJoin(c1));
        cols = fk.getColumns();
        pkCols = fk.getPrimaryKeyColumns();
        TestSchema.assertEquals((int)1, (int)cols.length);
        TestSchema.assertEquals((int)1, (int)pkCols.length);
        TestSchema.assertEquals((Object)c2, (Object)cols[0]);
        TestSchema.assertEquals((Object)c4, (Object)pkCols[0]);
        TestSchema.assertTrue((boolean)fk.removeJoin(c2));
        cols = fk.getColumns();
        pkCols = fk.getPrimaryKeyColumns();
        TestSchema.assertEquals((int)0, (int)cols.length);
        TestSchema.assertEquals((int)0, (int)pkCols.length);
        TestSchema.assertEquals((int)1, (int)fk.getDeleteAction());
        TestSchema.assertTrue((boolean)fk.isLogical());
        fk.setDeleteAction(2);
        TestSchema.assertEquals((int)2, (int)fk.getDeleteAction());
        TestSchema.assertFalse((boolean)fk.isLogical());
    }

    public void testSchemaGroup() {
        SchemaGroup group = this._schema.getSchemaGroup();
        TestSchema.assertEquals((Object)this._schema, (Object)group.getSchema("schema"));
        Table foo1 = this._schema.addTable("foo");
        Schema schema2 = group.addSchema("schema2");
        TestSchema.assertNull((Object)schema2.getTable("foo"));
        Table foo2 = schema2.addTable("foo");
        TestSchema.assertEquals((Object)foo2, (Object)schema2.getTable("foo"));
        TestSchema.assertEquals((Object)foo1, (Object)this._schema.getTable("foo"));
        TestSchema.assertEquals((Object)foo1, (Object)group.findTable("schema.foo"));
        TestSchema.assertEquals((Object)foo2, (Object)group.findTable("schema2.foo"));
    }

    public void testPrimaryKeyRemoval() {
        Table table = this._schema.addTable("table");
        Column c1 = table.addColumn("c1");
        Column c2 = table.addColumn("c2");
        Table table2 = this._schema.addTable("table2");
        Column c3 = table2.addColumn("c3");
        Column c4 = table2.addColumn("c4");
        PrimaryKey pk = table2.addPrimaryKey("pk");
        pk.addColumn(c3);
        pk.addColumn(c4);
        ForeignKey fk = table.addForeignKey("fk");
        fk.join(c1, c3);
        fk.join(c2, c4);
        table2.removePrimaryKey();
        TestSchema.assertNull((Object)pk.getTable());
        TestSchema.assertNull((Object)table2.getPrimaryKey());
        TestSchema.assertEquals((int)0, (int)table.getForeignKeys().length);
    }

    public void testColumnRemoval() {
        Table table = this._schema.addTable("table");
        Column c1 = table.addColumn("c1");
        Column c2 = table.addColumn("c2");
        PrimaryKey pk = table.addPrimaryKey("pk");
        pk.addColumn(c1);
        Index idx1 = table.addIndex("idx1");
        idx1.addColumn(c1);
        Index idx2 = table.addIndex("idx2");
        idx2.addColumn(c1);
        idx2.addColumn(c2);
        Table table2 = this._schema.addTable("table2");
        Column c3 = table2.addColumn("c3");
        Column c4 = table2.addColumn("c4");
        pk = table2.addPrimaryKey("pk2");
        pk.addColumn(c3);
        ForeignKey fk = table.addForeignKey("fk");
        fk.join(c1, c3);
        table.removeColumn(c1);
        TestSchema.assertNull((Object)table.getPrimaryKey());
        TestSchema.assertNull((Object)table.getIndex("idx1"));
        TestSchema.assertEquals((int)1, (int)idx2.getColumns().length);
        TestSchema.assertEquals((int)0, (int)table.getForeignKeys().length);
    }
}

