/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.schema;

import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.schema.LazySchemaFactory;
import org.apache.openjpa.jdbc.schema.SchemaGroup;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;

public class TestLazySchemaFactory
extends BaseJDBCTest {
    private SchemaGroup _group = null;
    private boolean _fks = true;

    public TestLazySchemaFactory() {
    }

    public TestLazySchemaFactory(String test) {
        super(test);
    }

    public void setUp() throws Exception {
        JDBCConfiguration conf = (JDBCConfiguration)this.getConfiguration();
        this._fks = conf.getDBDictionaryInstance().supportsForeignKeys && this.getCurrentPlatform() != AbstractTestCase.Platform.MYSQL && this.getCurrentPlatform() != AbstractTestCase.Platform.MARIADB;
        LazySchemaFactory factory = new LazySchemaFactory();
        factory.setConfiguration((Configuration)conf);
        factory.setPrimaryKeys(true);
        factory.setIndexes(true);
        factory.setForeignKeys(true);
        this._group = factory;
    }

    public void testLazySchemaFactory() {
        Table table = this._group.findTable("T1");
        TestLazySchemaFactory.assertNotNull((Object)table);
        Table table2 = this._group.findTable("t1");
        TestLazySchemaFactory.assertTrue((table == table2 ? 1 : 0) != 0);
        int expectedColumns = 2;
        if (this.getCurrentPlatform() == AbstractTestCase.Platform.SYBASE) {
            ++expectedColumns;
        }
        TestLazySchemaFactory.assertEquals((int)expectedColumns, (int)table.getColumns().length);
        if (this._fks) {
            TestLazySchemaFactory.assertEquals((int)1, (int)table.getForeignKeys().length);
        }
        table2 = this._group.findTable("T2");
        TestLazySchemaFactory.assertNotNull((Object)table2);
        if (this._fks) {
            TestLazySchemaFactory.assertTrue((table.getForeignKeys()[0].getPrimaryKeyColumns()[0].getTable() == table2 ? 1 : 0) != 0);
        }
        TestLazySchemaFactory.assertNull((Object)table.getSchema().getTable("T3"));
        Table table3 = this._group.findTable("T3");
        TestLazySchemaFactory.assertNotNull((Object)table3);
        TestLazySchemaFactory.assertTrue((table.getSchema().getTable("T3") == table3 ? 1 : 0) != 0);
        if (this._fks) {
            TestLazySchemaFactory.assertTrue((table3.getForeignKeys()[0].getPrimaryKeyColumns()[0].getTable() == table ? 1 : 0) != 0);
        }
        TestLazySchemaFactory.assertNull((Object)table3.getSchema().getTable("T4"));
    }

    public static void main(String[] args) {
    }
}

