/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.schema;

import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.Discriminator;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.meta.Version;
import org.apache.openjpa.jdbc.schema.DynamicSchemaFactory;
import org.apache.openjpa.jdbc.schema.Schemas;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.persistence.jdbc.common.apps.MappingTest1;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;

public class TestDynamicSchemaFactory
extends BaseJDBCTest {
    private ClassMapping _mapping = null;

    public TestDynamicSchemaFactory() {
    }

    public TestDynamicSchemaFactory(String test) {
        super(test);
    }

    public void setUp() throws Exception {
        JDBCConfigurationImpl conf = new JDBCConfigurationImpl();
        conf.setSchemaFactory(DynamicSchemaFactory.class.getName());
        MappingRepository repos = conf.newMappingRepositoryInstance();
        this._mapping = repos.getMapping(MappingTest1.class, null, true);
    }

    public void testClassMapping() {
        Table table = this._mapping.getTable();
        TestDynamicSchemaFactory.assertEquals((String)"MAPPINGTEST1", (String)table.getName().toUpperCase());
        TestDynamicSchemaFactory.assertEquals((int)1, (int)table.getPrimaryKey().getColumns().length);
        int type = table.getPrimaryKey().getColumns()[0].getType();
        TestDynamicSchemaFactory.assertEquals((String)Schemas.getJDBCName((int)type), (int)4, (int)type);
    }

    public void testIndicators() {
        Version vers = this._mapping.getVersion();
        TestDynamicSchemaFactory.assertNotNull((Object)vers);
        TestDynamicSchemaFactory.assertEquals((String)"MAPPINGTEST1", (String)vers.getColumns()[0].getTable().getName().toUpperCase());
        TestDynamicSchemaFactory.assertEquals((int)4, (int)vers.getColumns()[0].getType());
        Discriminator cls = this._mapping.getDiscriminator();
        TestDynamicSchemaFactory.assertNotNull((Object)cls);
        TestDynamicSchemaFactory.assertEquals((String)"MAPPINGTEST1", (String)cls.getColumns()[0].getTable().getName().toUpperCase());
        TestDynamicSchemaFactory.assertEquals((int)12, (int)cls.getColumns()[0].getType());
    }

    public static void main(String[] args) {
    }
}

