/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.schema;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.kernel.ClassTableJDBCSeq;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.Seq;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.persistence.jdbc.common.apps.SeqA;
import org.apache.openjpa.persistence.jdbc.common.apps.SeqB;
import org.apache.openjpa.persistence.jdbc.common.apps.SeqC;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;
import org.apache.openjpa.persistence.test.AllowFailure;

@AllowFailure(message="This test only applies to run with Oracle. This test also is not functional; disable until fix")
public class TestClassSequenceFactory
extends BaseJDBCTest {
    private static Map _sysprops = new HashMap();
    Broker _broker;

    public TestClassSequenceFactory() {
    }

    public TestClassSequenceFactory(String test) {
        super(test);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() throws Exception {
        JDBCConfigurationImpl conf = new JDBCConfigurationImpl();
        conf.fromProperties((Map)this.getProperties());
        if (!this.adjustConfiguration((JDBCConfiguration)conf)) {
            return;
        }
        String driver = conf.getConnectionDriverName().toLowerCase();
        String[] sql = null;
        if (driver.indexOf("oracle") >= 0) {
            sql = new String[]{"create sequence seqa_seq", "create sequence seqb_seq"};
        }
        if (sql == null) {
            return;
        }
        DataSource ds = conf.getDataSource2(null);
        Connection c = ds.getConnection();
        Statement s = null;
        try {
            s = c.createStatement();
            for (String value : sql) {
                try {
                    s.execute(value);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (Exception exception) {}
            }
        }
        this._broker = this.getBrokerFactory().newBroker();
    }

    public void testSequence() throws Exception {
        HashSet set = new HashSet();
        JDBCConfigurationImpl conf = new JDBCConfigurationImpl();
        conf.fromProperties((Map)this.getProperties());
        if (!this.adjustConfiguration((JDBCConfiguration)conf)) {
            return;
        }
        UpdateThread t1 = new UpdateThread(set, (JDBCConfiguration)conf);
        UpdateThread t2 = new UpdateThread(set, (JDBCConfiguration)conf);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        TestClassSequenceFactory.assertEquals((int)102, (int)set.size());
    }

    public void testExtensions() throws Exception {
        JDBCConfigurationImpl conf = new JDBCConfigurationImpl();
        conf.fromProperties((Map)this.getProperties());
        if (!this.adjustConfiguration((JDBCConfiguration)conf)) {
            return;
        }
        ClassMapping aMapping = conf.getMappingRepositoryInstance().getMapping(SeqA.class, null, true);
        ClassMapping bMapping = conf.getMappingRepositoryInstance().getMapping(SeqB.class, null, true);
        ClassMapping cMapping = conf.getMappingRepositoryInstance().getMapping(SeqC.class, null, true);
        DataSource ds = conf.getDataSource2(null);
        Seq seq = conf.getSequenceInstance();
        long aid = (Long)seq.next((StoreContext)this._broker, (ClassMetaData)aMapping);
        for (int i = 0; i < 5; ++i) {
            seq.next((StoreContext)this._broker, (ClassMetaData)bMapping);
        }
        TestClassSequenceFactory.assertEquals((Object)(aid + 1L), (Object)seq.next((StoreContext)this._broker, (ClassMetaData)aMapping));
        TestClassSequenceFactory.assertEquals((Object)(aid + 2L), (Object)seq.next((StoreContext)this._broker, (ClassMetaData)cMapping));
    }

    private boolean adjustConfiguration(JDBCConfiguration conf) {
        String driver = conf.getConnectionDriverName();
        if (driver == null) {
            return false;
        }
        if ((driver = driver.toLowerCase()).indexOf("oracle") >= 0) {
            conf.setSequence(ClassTableJDBCSeq.class.getName());
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
    }

    private class UpdateThread
    extends Thread {
        private JDBCConfiguration _conf;
        private Set _set = null;

        public UpdateThread(Set set, JDBCConfiguration conf) {
            this._set = set;
            this._conf = conf;
        }

        @Override
        public void run() {
            DataSource ds = this._conf.getDataSource2(null);
            try {
                Seq seq = this._conf.getSequenceInstance();
                ClassMapping mapping = this._conf.getMappingRepositoryInstance().getMapping(SeqA.class, null, true);
                for (int i = 0; i < 51; ++i) {
                    this._set.add(seq.next((StoreContext)TestClassSequenceFactory.this._broker, (ClassMetaData)mapping));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }
}

