/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.query.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.ManyToMany;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.DataCache;
import org.apache.openjpa.persistence.jdbc.query.cache.Part;
import org.apache.openjpa.persistence.jdbc.query.cache.Supplier;

@Entity
@DataCache
public class PartBase
extends Part
implements PersistenceCapable {
    double cost;
    double mass;
    int backOrder;
    @ManyToMany(mappedBy="supplies")
    protected List<Supplier> suppliers = new ArrayList<Supplier>();
    private static int pcInheritedFieldCount = Part.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient boolean pcVersionInit;
    static /* synthetic */ Class class$Lorg$apache$openjpa$persistence$jdbc$query$cache$Part;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Lorg$apache$openjpa$persistence$jdbc$query$cache$PartBase;

    public PartBase() {
    }

    public PartBase(int partno, String name, double cost, double mass) {
        this.partno = partno;
        this.name = name;
        this.cost = cost;
        this.mass = mass;
        this.backOrder = 0;
        this.inventory = 0;
    }

    public double getCost() {
        return PartBase.pcGetcost(this);
    }

    public void setCost(double cost) {
        PartBase.pcSetcost(this, cost);
    }

    public double getMass() {
        return PartBase.pcGetmass(this);
    }

    public void setMass(double mass) {
        PartBase.pcSetmass(this, mass);
    }

    public Collection<Supplier> getSuppliers() {
        return PartBase.pcGetsuppliers(this);
    }

    public void setSuppliers(List<Supplier> suppliers) {
        PartBase.pcSetsuppliers(this, suppliers);
    }

    public String toString() {
        StringBuilder sup = new StringBuilder();
        if (this.getSuppliers() != null) {
            for (Supplier s : this.getSuppliers()) {
                sup.append(Supplier.pcGetsid(s)).append(",");
            }
        }
        return "PartBase:" + Part.pcGetpartno(this) + " name:+" + Part.pcGetname(this) + " cost:" + PartBase.pcGetcost(this) + " mass:" + PartBase.pcGetmass(this) + " supplies=[" + sup + "]";
    }

    public int getBackOrder() {
        return PartBase.pcGetbackOrder(this);
    }

    public void setBackOrder(int backOrder) {
        PartBase.pcSetbackOrder(this, backOrder);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 196634845;
    }

    static {
        Class clazz = class$Lorg$apache$openjpa$persistence$jdbc$query$cache$Part != null ? class$Lorg$apache$openjpa$persistence$jdbc$query$cache$Part : (class$Lorg$apache$openjpa$persistence$jdbc$query$cache$Part = PartBase.class$("org.apache.openjpa.persistence.jdbc.query.cache.Part"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"backOrder", "cost", "mass", "suppliers"};
        Class[] classArray = new Class[4];
        classArray[0] = Integer.TYPE;
        classArray[1] = Double.TYPE;
        classArray[2] = Double.TYPE;
        Class clazz2 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = PartBase.class$("java.util.List"));
        classArray[3] = clazz2;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 5};
        Class clazz3 = class$Lorg$apache$openjpa$persistence$jdbc$query$cache$PartBase != null ? class$Lorg$apache$openjpa$persistence$jdbc$query$cache$PartBase : (class$Lorg$apache$openjpa$persistence$jdbc$query$cache$PartBase = PartBase.class$("org.apache.openjpa.persistence.jdbc.query.cache.PartBase"));
        PCRegistry.register((Class)clazz3, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"PartBase", (PersistenceCapable)new PartBase());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.backOrder = 0;
        this.cost = 0.0;
        this.mass = 0.0;
        this.suppliers = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        PartBase partBase = new PartBase();
        if (bl) {
            partBase.pcClearFields();
        }
        partBase.pcStateManager = stateManager;
        partBase.pcCopyKeyFieldsFromObjectId(object);
        return partBase;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        PartBase partBase = new PartBase();
        if (bl) {
            partBase.pcClearFields();
        }
        partBase.pcStateManager = stateManager;
        return partBase;
    }

    protected static int pcGetManagedFieldCount() {
        return 4 + Part.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.backOrder = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.cost = this.pcStateManager.replaceDoubleField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.mass = this.pcStateManager.replaceDoubleField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.suppliers = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.backOrder);
                return;
            }
            case 1: {
                this.pcStateManager.providedDoubleField((PersistenceCapable)this, n, this.cost);
                return;
            }
            case 2: {
                this.pcStateManager.providedDoubleField((PersistenceCapable)this, n, this.mass);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.suppliers);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(PartBase partBase, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(partBase, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.backOrder = partBase.backOrder;
                return;
            }
            case 1: {
                this.cost = partBase.cost;
                return;
            }
            case 2: {
                this.mass = partBase.mass;
                return;
            }
            case 3: {
                this.suppliers = partBase.suppliers;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        PartBase partBase = (PartBase)object;
        if (partBase.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(partBase, nArray[n]);
            ++n;
        }
    }

    static final int pcGetbackOrder(PartBase partBase) {
        if (partBase.pcStateManager == null) {
            return partBase.backOrder;
        }
        int n = pcInheritedFieldCount + 0;
        partBase.pcStateManager.accessingField(n);
        return partBase.backOrder;
    }

    static final void pcSetbackOrder(PartBase partBase, int n) {
        if (partBase.pcStateManager == null) {
            partBase.backOrder = n;
            return;
        }
        partBase.pcStateManager.settingIntField((PersistenceCapable)partBase, pcInheritedFieldCount + 0, partBase.backOrder, n, 0);
    }

    static final double pcGetcost(PartBase partBase) {
        if (partBase.pcStateManager == null) {
            return partBase.cost;
        }
        int n = pcInheritedFieldCount + 1;
        partBase.pcStateManager.accessingField(n);
        return partBase.cost;
    }

    static final void pcSetcost(PartBase partBase, double d) {
        if (partBase.pcStateManager == null) {
            partBase.cost = d;
            return;
        }
        partBase.pcStateManager.settingDoubleField((PersistenceCapable)partBase, pcInheritedFieldCount + 1, partBase.cost, d, 0);
    }

    static final double pcGetmass(PartBase partBase) {
        if (partBase.pcStateManager == null) {
            return partBase.mass;
        }
        int n = pcInheritedFieldCount + 2;
        partBase.pcStateManager.accessingField(n);
        return partBase.mass;
    }

    static final void pcSetmass(PartBase partBase, double d) {
        if (partBase.pcStateManager == null) {
            partBase.mass = d;
            return;
        }
        partBase.pcStateManager.settingDoubleField((PersistenceCapable)partBase, pcInheritedFieldCount + 2, partBase.mass, d, 0);
    }

    protected static final List pcGetsuppliers(PartBase partBase) {
        if (partBase.pcStateManager == null) {
            return partBase.suppliers;
        }
        int n = pcInheritedFieldCount + 3;
        partBase.pcStateManager.accessingField(n);
        return partBase.suppliers;
    }

    protected static final void pcSetsuppliers(PartBase partBase, List list) {
        if (partBase.pcStateManager == null) {
            partBase.suppliers = list;
            return;
        }
        partBase.pcStateManager.settingObjectField((PersistenceCapable)partBase, pcInheritedFieldCount + 3, partBase.suppliers, (Object)list, 0);
    }
}

