/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.query.cache;

import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import javax.persistence.Version;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.DataCache;
import org.apache.openjpa.persistence.jdbc.query.cache.Usage;
import org.apache.openjpa.util.IntId;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.UserException;

@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="PARTTYPE")
@DataCache
public abstract class Part
implements PersistenceCapable {
    @Id
    int partno;
    @Column(length=20)
    String name;
    int inventory;
    @OneToMany(mappedBy="child", cascade={CascadeType.PERSIST})
    protected Collection<Usage> usedIn = new ArrayList<Usage>();
    @Version
    long version;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient boolean pcVersionInit;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$util$Collection;
    static /* synthetic */ Class class$Lorg$apache$openjpa$persistence$jdbc$query$cache$Part;
    private transient Object pcDetachedState;

    public String getName() {
        return Part.pcGetname(this);
    }

    public void setName(String name) {
        Part.pcSetname(this, name);
    }

    public int getPartno() {
        return Part.pcGetpartno(this);
    }

    public void setPartno(int partno) {
        Part.pcSetpartno(this, partno);
    }

    public Collection<Usage> getUsedIn() {
        return Part.pcGetusedIn(this);
    }

    public void setUsedIn(Collection<Usage> usedIn) {
        Part.pcSetusedIn(this, usedIn);
    }

    public int getInventory() {
        return Part.pcGetinventory(this);
    }

    public void setInventory(int inventory) {
        Part.pcSetinventory(this, inventory);
    }

    public int pcGetEnhancementContractVersion() {
        return 196634845;
    }

    static {
        pcFieldNames = new String[]{"inventory", "name", "partno", "usedIn", "version"};
        Class[] classArray = new Class[5];
        classArray[0] = Integer.TYPE;
        Class clazz = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Part.class$("java.lang.String"));
        classArray[1] = clazz;
        classArray[2] = Integer.TYPE;
        Class clazz2 = class$Ljava$util$Collection != null ? class$Ljava$util$Collection : (class$Ljava$util$Collection = Part.class$("java.util.Collection"));
        classArray[3] = clazz2;
        classArray[4] = Long.TYPE;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 5, 21};
        Class clazz3 = class$Lorg$apache$openjpa$persistence$jdbc$query$cache$Part != null ? class$Lorg$apache$openjpa$persistence$jdbc$query$cache$Part : (class$Lorg$apache$openjpa$persistence$jdbc$query$cache$Part = Part.class$("org.apache.openjpa.persistence.jdbc.query.cache.Part"));
        PCRegistry.register((Class)clazz3, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"Part", null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.inventory = 0;
        this.name = null;
        this.partno = 0;
        this.usedIn = null;
        this.version = 0L;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        throw new UserException();
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        throw new UserException();
    }

    protected static int pcGetManagedFieldCount() {
        return 5;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.inventory = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.name = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.partno = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.usedIn = (Collection)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.version = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                this.pcVersionInit = true;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.inventory);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.name);
                return;
            }
            case 2: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.partno);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.usedIn);
                return;
            }
            case 4: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.version);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(Part part, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.inventory = part.inventory;
                return;
            }
            case 1: {
                this.name = part.name;
                return;
            }
            case 2: {
                this.partno = part.partno;
                return;
            }
            case 3: {
                this.usedIn = part.usedIn;
                return;
            }
            case 4: {
                this.version = part.version;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        Part part = (Part)object;
        if (part.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(part, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return new Long(this.version);
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        IntId intId = (IntId)object;
        fieldConsumer.storeIntField(2 + pcInheritedFieldCount, intId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        IntId intId = (IntId)object;
        this.partno = intId.getId();
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$openjpa$persistence$jdbc$query$cache$Part != null ? class$Lorg$apache$openjpa$persistence$jdbc$query$cache$Part : (class$Lorg$apache$openjpa$persistence$jdbc$query$cache$Part = Part.class$("org.apache.openjpa.persistence.jdbc.query.cache.Part"));
        return new IntId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$openjpa$persistence$jdbc$query$cache$Part != null ? class$Lorg$apache$openjpa$persistence$jdbc$query$cache$Part : (class$Lorg$apache$openjpa$persistence$jdbc$query$cache$Part = Part.class$("org.apache.openjpa.persistence.jdbc.query.cache.Part"));
        return new IntId(clazz, this.partno);
    }

    static final int pcGetinventory(Part part) {
        if (part.pcStateManager == null) {
            return part.inventory;
        }
        int n = pcInheritedFieldCount + 0;
        part.pcStateManager.accessingField(n);
        return part.inventory;
    }

    static final void pcSetinventory(Part part, int n) {
        if (part.pcStateManager == null) {
            part.inventory = n;
            return;
        }
        part.pcStateManager.settingIntField((PersistenceCapable)part, pcInheritedFieldCount + 0, part.inventory, n, 0);
    }

    static final String pcGetname(Part part) {
        if (part.pcStateManager == null) {
            return part.name;
        }
        int n = pcInheritedFieldCount + 1;
        part.pcStateManager.accessingField(n);
        return part.name;
    }

    static final void pcSetname(Part part, String string) {
        if (part.pcStateManager == null) {
            part.name = string;
            return;
        }
        part.pcStateManager.settingStringField((PersistenceCapable)part, pcInheritedFieldCount + 1, part.name, string, 0);
    }

    static final int pcGetpartno(Part part) {
        if (part.pcStateManager == null) {
            return part.partno;
        }
        int n = pcInheritedFieldCount + 2;
        part.pcStateManager.accessingField(n);
        return part.partno;
    }

    static final void pcSetpartno(Part part, int n) {
        if (part.pcStateManager == null) {
            part.partno = n;
            return;
        }
        part.pcStateManager.settingIntField((PersistenceCapable)part, pcInheritedFieldCount + 2, part.partno, n, 0);
    }

    protected static final Collection pcGetusedIn(Part part) {
        if (part.pcStateManager == null) {
            return part.usedIn;
        }
        int n = pcInheritedFieldCount + 3;
        part.pcStateManager.accessingField(n);
        return part.usedIn;
    }

    protected static final void pcSetusedIn(Part part, Collection collection) {
        if (part.pcStateManager == null) {
            part.usedIn = collection;
            return;
        }
        part.pcStateManager.settingObjectField((PersistenceCapable)part, pcInheritedFieldCount + 3, part.usedIn, (Object)collection, 0);
    }

    static final long pcGetversion(Part part) {
        if (part.pcStateManager == null) {
            return part.version;
        }
        int n = pcInheritedFieldCount + 4;
        part.pcStateManager.accessingField(n);
        return part.version;
    }

    static final void pcSetversion(Part part, long l) {
        if (part.pcStateManager == null) {
            part.version = l;
            part.pcVersionInit = true;
            return;
        }
        part.pcStateManager.settingLongField((PersistenceCapable)part, pcInheritedFieldCount + 4, part.version, l, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.version != 0L) {
            return Boolean.TRUE;
        }
        if (this.pcVersionInit) {
            return Boolean.TRUE;
        }
        return null;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

