/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.query;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.jdbc.query.domain.Binder;
import org.apache.openjpa.persistence.test.AllowFailure;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestQueryParameterBinding
extends SingleEMFTestCase {
    private static String JPQL = "SELECT p FROM Binder p ";
    private static int INT_VALUE = 1;
    private static String STR_VALUE = "2";
    private static double DBL_VALUE = 3.0;
    private EntityManager em;

    @Override
    public void setUp() throws Exception {
        super.setUp(CLEAR_TABLES, Binder.class);
        this.em = this.emf.createEntityManager();
        this.em.getTransaction().begin();
        this.em.persist((Object)new Binder(INT_VALUE, STR_VALUE, DBL_VALUE));
        this.em.getTransaction().commit();
    }

    public void testPositionalParameterWithPositionalBindingSucceeds() {
        String JPQL_POSITIONAL = JPQL + "WHERE p.p1=?1 AND p.p2=?2 AND p.p3=?3";
        Query q = this.em.createQuery(JPQL_POSITIONAL);
        q.setParameter(1, (Object)INT_VALUE);
        q.setParameter(2, (Object)STR_VALUE);
        q.setParameter(3, (Object)DBL_VALUE);
        TestQueryParameterBinding.assertEquals((int)1, (int)q.getResultList().size());
    }

    public void testPositionalParameterWithNamedBindingFails() {
        String JPQL_POSITIONAL = JPQL + "WHERE p.p1=?1 AND p.p2=?2 AND p.p3=?3";
        Query q = this.em.createQuery(JPQL_POSITIONAL);
        this.assertSetParameterFails(q, "p1", (Object)INT_VALUE);
    }

    public void testPositionalParameterWithInsufficientValuesFails() {
        String JPQL_POSITIONAL = JPQL + "WHERE p.p1=?1 AND p.p2=?2 AND p.p3=?3";
        Query q = this.em.createQuery(JPQL_POSITIONAL);
        q.setParameter(1, (Object)INT_VALUE);
        q.setParameter(2, (Object)STR_VALUE);
        this.fail(q);
    }

    public void testPositionalParameterWithExtraValuesFails() {
        String JPQL_POSITIONAL = JPQL + "WHERE p.p1=?1 AND p.p2=?2 AND p.p3=?3";
        Query q = this.em.createQuery(JPQL_POSITIONAL);
        q.setParameter(1, (Object)INT_VALUE);
        q.setParameter(2, (Object)STR_VALUE);
        q.setParameter(3, (Object)DBL_VALUE);
        this.assertSetParameterFails(q, 4, (Object)4);
    }

    public void testPositionalParameterWithRepeatedValuesSucceeds() {
        String jPQL_POSITIONAL_REPEATED_PARAM = JPQL + "WHERE p.p1=?1 OR p.p1=?1 AND p.p3=?2";
        Query q = this.em.createQuery(jPQL_POSITIONAL_REPEATED_PARAM);
        q.setParameter(1, (Object)INT_VALUE);
        q.setParameter(2, (Object)DBL_VALUE);
        TestQueryParameterBinding.assertEquals((int)1, (int)q.getResultList().size());
    }

    @AllowFailure
    public void testPositionalParameterWithGapSucceeds() {
        String JPQL_POSITIONAL_GAP_IN_PARAM = JPQL + "WHERE p.p1=?1 AND p.p2=?3";
        Query q = this.em.createQuery(JPQL_POSITIONAL_GAP_IN_PARAM);
        q.setParameter(1, (Object)INT_VALUE);
        q.setParameter(3, (Object)STR_VALUE);
        TestQueryParameterBinding.assertEquals((int)1, (int)q.getResultList().size());
    }

    public void testPositionalParameterWithGapFails() {
        String JPQL_POSITIONAL_GAP_IN_PARAM = JPQL + "WHERE p.p1=?1 AND p.p3=?3";
        Query q = this.em.createQuery(JPQL_POSITIONAL_GAP_IN_PARAM);
        q.setParameter(1, (Object)INT_VALUE);
        q.setParameter(3, (Object)DBL_VALUE);
        this.assertSetParameterFails(q, 2, (Object)STR_VALUE);
        this.fail(q);
    }

    public void testNamedParameterWithNamedBindingSucceeds() {
        String JPQL_NAMED = JPQL + "WHERE p.p1=:p1 AND p.p2=:p2 AND p.p3=:p3";
        Query q = this.em.createQuery(JPQL_NAMED);
        q.setParameter("p1", (Object)INT_VALUE);
        q.setParameter("p2", (Object)STR_VALUE);
        q.setParameter("p3", (Object)DBL_VALUE);
        TestQueryParameterBinding.assertEquals((int)1, (int)q.getResultList().size());
    }

    public void testNamedParameterWithPositionalBindingFails() {
        String JPQL_NAMED = JPQL + "WHERE p.p1=:p1 AND p.p2=:p2 AND p.p3=:p3";
        Query q = this.em.createQuery(JPQL_NAMED);
        this.assertSetParameterFails(q, 1, (Object)INT_VALUE);
    }

    public void testNamedParameterWithInsufficientValuesFails() {
        String JPQL_NAMED = JPQL + "WHERE p.p1=:p1 AND p.p2=:p2 AND p.p3=:p3";
        Query q = this.em.createQuery(JPQL_NAMED);
        q.setParameter("p1", (Object)INT_VALUE);
        q.setParameter("p2", (Object)STR_VALUE);
        this.fail(q);
    }

    public void testNamedParameterWithExtraValuesFails() {
        String JPQL_NAMED = JPQL + "WHERE p.p1=:p1 AND p.p2=:p2 AND p.p3=:p3";
        Query q = this.em.createQuery(JPQL_NAMED);
        q.setParameter("p1", (Object)INT_VALUE);
        q.setParameter("p2", (Object)STR_VALUE);
        q.setParameter("p3", (Object)DBL_VALUE);
        this.assertSetParameterFails(q, "p4", (Object)4);
    }

    public void testNamedParameterWithRepeatedValuesSucceeds() {
        String jPQL_NAMED_REPEATED_PARAM = JPQL + "WHERE p.p1=:p1 OR p.p1=:p1 AND p.p3=:p2";
        Query q = this.em.createQuery(jPQL_NAMED_REPEATED_PARAM);
        q.setParameter("p1", (Object)INT_VALUE);
        q.setParameter("p2", (Object)DBL_VALUE);
        TestQueryParameterBinding.assertEquals((int)1, (int)q.getResultList().size());
    }

    public void testNamedParameterWithGapSucceeds() {
        String JPQL_NAMED_GAP_IN_PARAM = JPQL + "WHERE p.p1=:p1 AND p.p2=:p3";
        Query q = this.em.createQuery(JPQL_NAMED_GAP_IN_PARAM);
        q.setParameter("p1", (Object)INT_VALUE);
        q.setParameter("p3", (Object)STR_VALUE);
        TestQueryParameterBinding.assertEquals((int)1, (int)q.getResultList().size());
    }

    public void testNamedParameterWithGapFails() {
        String JPQL_NAMED_GAP_IN_PARAM = JPQL + "WHERE p.p1=:p1 AND p.p3=:p3";
        Query q = this.em.createQuery(JPQL_NAMED_GAP_IN_PARAM);
        q.setParameter("p1", (Object)INT_VALUE);
        q.setParameter("p3", (Object)DBL_VALUE);
        this.assertSetParameterFails(q, "p2", (Object)STR_VALUE);
    }

    public void testNamedParameterWithWrongType() {
        String JPQL_NAMED = JPQL + "WHERE p.p1=:p1 AND p.p2=:p2 AND p.p3=:p3";
        Query q = this.em.createQuery(JPQL_NAMED);
        q.setParameter("p1", (Object)INT_VALUE);
        this.assertSetParameterFails(q, "p2", (Object)DBL_VALUE);
        this.assertSetParameterFails(q, "p3", (Object)STR_VALUE);
    }

    public void testPositionalParameterWithWrongType() {
        String JPQL_POSITIONAL = JPQL + "WHERE p.p1=?1 AND p.p2=?2 AND p.p3=?3";
        Query q = this.em.createQuery(JPQL_POSITIONAL);
        q.setParameter(1, (Object)INT_VALUE);
        this.assertSetParameterFails(q, 2, (Object)DBL_VALUE);
    }

    public void testNamedParameterWithNullValue() {
        String JPQL_POSITIONAL = JPQL + "WHERE p.p1=:p1 AND p.p2=:p2 AND p.p3=:p3";
        Query q = this.em.createQuery(JPQL_POSITIONAL);
        q.setParameter("p1", (Object)INT_VALUE);
        q.setParameter("p2", null);
        this.assertSetParameterFails(q, "p3", null);
    }

    public void testPositionalParameterWithNullValue() {
        String JPQL_POSITIONAL = JPQL + "WHERE p.p1=?1 AND p.p2=?2 AND p.p3=?3";
        Query q = this.em.createQuery(JPQL_POSITIONAL);
        q.setParameter(1, (Object)INT_VALUE);
        q.setParameter(2, null);
        this.assertSetParameterFails(q, 3, null);
    }

    public void testPositionalParameterWithSingleResult() {
        Query q = this.em.createNamedQuery("JPQL_POSITIONAL");
        q.setParameter(1, (Object)INT_VALUE);
        q.setParameter(2, null);
        this.assertSetParameterFails(q, 3, null);
    }

    public void testPositionalParameterWithNativeQuery() {
        Query q = this.em.createNamedQuery("SQL_POSITIONAL");
        q.setParameter(1, (Object)INT_VALUE);
        q.setParameter(2, (Object)STR_VALUE);
        q.setParameter(3, (Object)DBL_VALUE);
        TestQueryParameterBinding.assertEquals((int)1, (int)q.getResultList().size());
    }

    public void testPositionalParameterWithNativeQueryFails() {
        Query q = this.em.createNamedQuery("SQL_POSITIONAL");
        q.setParameter(1, (Object)INT_VALUE);
        q.setParameter(2, (Object)STR_VALUE);
        this.fail(q);
    }

    public void testPositionalParameterWithNativeQueryFailsWithGap() {
        Query q = this.em.createNamedQuery("SQL_POSITIONAL");
        q.setParameter(1, (Object)INT_VALUE);
        q.setParameter(3, (Object)DBL_VALUE);
        this.fail(q);
    }

    public void testRepeatedNamedParameters() {
        String JPQL_POSITIONAL = JPQL + "WHERE p.p1 in (select max(p.p1) from Binder p where p.p1=:p1 AND p.p2=:p2 AND p.p3=:p3) AND p.p1=:p1 AND p.p2=:p2 AND p.p3=:p3";
        Query q = this.em.createQuery(JPQL_POSITIONAL);
        q.setParameter("p1", (Object)INT_VALUE);
        q.setParameter("p2", (Object)STR_VALUE);
        q.setParameter("p3", (Object)DBL_VALUE);
        List list = q.getResultList();
        TestQueryParameterBinding.assertEquals((int)1, (int)list.size());
    }

    void assertSetParameterFails(Query q, String name, Object v) {
        try {
            q.setParameter(name, v);
            TestQueryParameterBinding.fail((String)("Expected to fail in setting named parameter [" + name + "] to a value of " + v));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    void assertSetParameterFails(Query q, int pos, Object v) {
        try {
            q.setParameter(pos, v);
            TestQueryParameterBinding.fail((String)("Expected to fail in setting positional parameter [" + pos + "] to a value of " + v));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    void fail(Query q) {
        this.fail(q, false);
    }

    void fail(Query q, boolean single) {
        try {
            if (single) {
                q.getSingleResult();
            } else {
                q.getResultList();
            }
            TestQueryParameterBinding.fail((String)("Expeceted " + ArgumentException.class.getName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

