/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.query;

import java.util.List;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.query.domain.Chess;
import org.apache.openjpa.persistence.jdbc.query.domain.Game;
import org.apache.openjpa.persistence.jdbc.query.domain.IndoorGame;
import org.apache.openjpa.persistence.jdbc.query.domain.Scrabble;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestOrderByQuery
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        super.setUp(DROP_TABLES, Game.class, IndoorGame.class, Scrabble.class, Chess.class);
        try {
            this.createData();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void createData() throws Exception {
        Class[] classes;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        for (Class cls : classes = new Class[]{Game.class, IndoorGame.class, Scrabble.class, Chess.class}) {
            for (int i = 1; i <= 4; ++i) {
                Game p = (Game)cls.newInstance();
                p.setName(cls.getSimpleName() + "-" + i);
                em.persist((Object)p);
            }
        }
        em.getTransaction().commit();
    }

    public void testOrderByAliasAscending() {
        String jpql = "SELECT p.name as name FROM Game p ORDER BY name ASC";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        List names = em.createQuery(jpql).getResultList();
        this.assertOrdering(names.toArray(new String[names.size()]), true);
    }

    public void testOrderByConcatAliasDescending() {
        String jpql = "SELECT CONCAT(p.name, '123') as cname FROM Game p ORDER BY cname DESC";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        List names = em.createQuery(jpql).getResultList();
        this.assertOrdering(names.toArray(new String[names.size()]), false);
    }

    public void testOrderByAliasDescending() {
        String jpql = "SELECT p.name as name FROM Game p ORDER BY name DESC";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        List names = em.createQuery(jpql).getResultList();
        this.assertOrdering(names.toArray(new String[names.size()]), false);
    }

    public void testOrderByQueryAscending() {
        String jpql = "SELECT p FROM Game p ORDER BY p.name ASC";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        List persons = em.createQuery(jpql).getResultList();
        this.assertOrdering(this.getNames(persons), true);
    }

    public void testOrderByQueryDescending() {
        String jpql = "SELECT p FROM Game p ORDER BY p.name DESC";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        List persons = em.createQuery(jpql).getResultList();
        this.assertOrdering(this.getNames(persons), false);
    }

    public void testOrderByQueryProjectionAscending() {
        String jpql = "SELECT p.name FROM Game p ORDER BY p.name ASC";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        List names = em.createQuery(jpql).getResultList();
        this.assertOrdering(names.toArray(new String[names.size()]), true);
    }

    public void testOrderByQueryProjectionDescending() {
        String jpql = "SELECT p.name FROM Game p ORDER BY p.name DESC";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        List names = em.createQuery(jpql).getResultList();
        this.assertOrdering(names.toArray(new String[names.size()]), false);
    }

    public String[] getNames(List<Game> persons) {
        TestOrderByQuery.assertNotNull(persons);
        String[] names = new String[persons.size()];
        int i = 0;
        for (Game p : persons) {
            names[i++] = p.getName();
        }
        return names;
    }

    public void assertOrdering(String[] names, boolean ascending) {
        TestOrderByQuery.assertNotNull((Object)names);
        TestOrderByQuery.assertTrue((names.length > 0 ? 1 : 0) != 0);
        for (int i = 1; i < names.length; ++i) {
            if (ascending) {
                TestOrderByQuery.assertTrue((names[i].compareTo(names[i - 1]) >= 0 ? 1 : 0) != 0);
                continue;
            }
            TestOrderByQuery.assertTrue((names[i].compareTo(names[i - 1]) <= 0 ? 1 : 0) != 0);
        }
    }
}

