/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.query;

import java.util.Collection;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.jdbc.common.apps.NamedSQL;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;

public class TestNamedSQLQueries
extends BaseJDBCTest {
    public TestNamedSQLQueries() {
    }

    public TestNamedSQLQueries(String test) {
        super(test);
    }

    public void setUp() {
        this.deleteAll(NamedSQL.class);
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        for (int i = 0; i < 10; ++i) {
            NamedSQL pc = new NamedSQL();
            if (i < 5) {
                pc.setNum(4);
            } else {
                pc.setNum(i + 10);
            }
            pm.persist((Object)pc);
        }
        this.endTx((EntityManager)pm);
        pm.close();
    }

    public void testNamedQuery() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        OpenJPAQuery q = pm.createNativeQuery("cls", NamedSQL.class);
        TestNamedSQLQueries.assertEquals((String)"javax.jdo.query.SQL", (String)q.getLanguage());
        Collection results = q.getCandidateCollection();
        for (Object result : results) {
            TestNamedSQLQueries.assertEquals((int)4, (int)((NamedSQL)result).getNum());
        }
        TestNamedSQLQueries.assertEquals((int)5, (int)results.size());
        q.closeAll();
        pm.close();
    }

    public void testSystem() {
        OpenJPAEntityManager pm = this.currentEntityManager();
    }
}

