/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.order;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.jdbc.XMLPersistenceMappingParser;
import org.apache.openjpa.persistence.jdbc.XMLPersistenceMappingSerializer;
import org.apache.openjpa.persistence.jdbc.order.BaseTestEntity1;
import org.apache.openjpa.persistence.jdbc.order.BaseTestEntity2;
import org.apache.openjpa.persistence.jdbc.order.BaseTestEntity3;
import org.apache.openjpa.persistence.jdbc.order.ColDefTestElement;
import org.apache.openjpa.persistence.jdbc.order.ColDefTestEntity;
import org.apache.openjpa.persistence.jdbc.order.ObOcEntity;
import org.apache.openjpa.persistence.test.AbstractCachedEMFTestCase;

public class TestOrderColumnXML
extends AbstractCachedEMFTestCase {
    public void testOrderColumnNullableFalse() {
        OpenJPAEntityManagerFactorySPI emf1 = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"BaseNoNullTest", (String)"org/apache/openjpa/persistence/jdbc/order/order-persistence-4.xml");
        OpenJPAConfiguration conf = emf1.getConfiguration();
        MetaDataRepository repos = conf.getMetaDataRepositoryInstance();
        repos.getMetaData(BaseTestEntity2.class, null, true);
        OpenJPAEntityManagerSPI em = emf1.createEntityManager();
        this.validateOrderColumnNullable(emf1, BaseTestEntity2.class, "one2Melems", false);
        this.validateOrderColumnNullable(emf1, BaseTestEntity2.class, "collelems", false);
        this.validateOrderColumnNullable(emf1, BaseTestEntity2.class, "m2melems", false);
        em.close();
        try {
            if (emf1 != null) {
                this.cleanupEMF(emf1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            TestOrderColumnXML.fail((String)e.getMessage());
        }
    }

    public void testOrderColumnColumnDefinition() {
        OpenJPAEntityManagerFactorySPI emf1 = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"ColDefTest", (String)"org/apache/openjpa/persistence/jdbc/order/order-persistence-2.xml");
        OpenJPAEntityManagerSPI em = emf1.createEntityManager();
        this.validateOrderColumnDef(emf1, ColDefTestEntity.class, "one2Mcoldef", "INTEGER");
        this.validateOrderColumnDef(emf1, ColDefTestEntity.class, "collcoldef", "INTEGER");
        this.validateOrderColumnDef(emf1, ColDefTestEntity.class, "m2mcoldef", "INTEGER");
        ColDefTestEntity cdent = new ColDefTestEntity();
        ColDefTestElement cdel1 = new ColDefTestElement("Element1");
        ColDefTestElement cdel2 = new ColDefTestElement("Element2");
        ColDefTestElement cdel3 = new ColDefTestElement("Element3");
        ArrayList<ColDefTestElement> one2Mcoldef = new ArrayList<ColDefTestElement>();
        one2Mcoldef.add(cdel3);
        one2Mcoldef.add(cdel2);
        one2Mcoldef.add(cdel1);
        cdent.setOne2Mcoldef(one2Mcoldef);
        LinkedHashSet<ColDefTestElement> collcoldef = new LinkedHashSet<ColDefTestElement>();
        collcoldef.add(cdel1);
        collcoldef.add(cdel2);
        collcoldef.add(cdel3);
        cdent.setCollcoldef(collcoldef);
        ArrayList<ColDefTestElement> m2mcoldef = new ArrayList<ColDefTestElement>();
        m2mcoldef.add(cdel2);
        m2mcoldef.add(cdel1);
        m2mcoldef.add(cdel3);
        cdent.setM2mcoldef(m2mcoldef);
        em.getTransaction().begin();
        em.persist((Object)cdent);
        em.getTransaction().commit();
        em.close();
        try {
            if (emf1 != null) {
                this.cleanupEMF(emf1);
            }
        }
        catch (Exception e) {
            TestOrderColumnXML.fail((String)e.getMessage());
        }
    }

    public void testOrderColumnTableXML() {
        OpenJPAEntityManagerFactorySPI emf1 = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"TableTest", (String)"org/apache/openjpa/persistence/jdbc/order/order-persistence-5.xml");
        OpenJPAEntityManagerSPI em = emf1.createEntityManager();
        this.validateOrderColumnTable(emf1, BaseTestEntity3.class, "one2Melems", "xml_o2m_table", "one2MOrder");
        this.validateOrderColumnTable(emf1, BaseTestEntity3.class, "m2melems", "xml_m2m_table", "m2morder");
        this.validateOrderColumnTable(emf1, BaseTestEntity3.class, "collelems", "xml_coll_table", "collelems_ORDER");
        em.close();
        try {
            if (emf1 != null) {
                this.cleanupEMF(emf1);
            }
        }
        catch (Exception e) {
            TestOrderColumnXML.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOrderColumnOrderBy() {
        OpenJPAEntityManagerFactorySPI emf1 = null;
        try (OpenJPAEntityManagerSPI em = null;){
            emf1 = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"ObOcTest", (String)"org/apache/openjpa/persistence/jdbc/order/order-persistence-3.xml");
            em = emf1.createEntityManager();
            ObOcEntity ent = new ObOcEntity();
            ArrayList<Integer> intList = new ArrayList<Integer>();
            intList.add(10);
            intList.add(20);
            ent.setIntList(intList);
            em.getTransaction().begin();
            em.persist(intList);
            em.getTransaction().commit();
            em.close();
            em = null;
            TestOrderColumnXML.fail((String)"An exception should have been thrown.");
        }
        try {
            if (emf1 != null) {
                this.cleanupEMF(emf1);
            }
        }
        catch (Exception e) {
            TestOrderColumnXML.fail((String)e.getMessage());
        }
    }

    public void testOrderColumnMetaDataSerialization() throws Exception {
        OpenJPAEntityManagerFactorySPI emf1 = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"BaseTest", (String)"org/apache/openjpa/persistence/jdbc/order/order-persistence.xml");
        OpenJPAConfiguration conf = emf1.getConfiguration();
        MetaDataRepository repos = conf.newMetaDataRepositoryInstance();
        repos.getMetaData(BaseTestEntity1.class, null, true);
        XMLPersistenceMappingSerializer ser = new XMLPersistenceMappingSerializer((JDBCConfiguration)conf);
        ser.addAll(repos);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ser.serialize((Writer)new OutputStreamWriter(out), 1);
        byte[] bytes = out.toByteArray();
        XMLPersistenceMappingParser parser = new XMLPersistenceMappingParser((JDBCConfiguration)conf);
        parser.parse((Reader)new InputStreamReader(new ByteArrayInputStream(bytes)), "bytes");
        MetaDataRepository mdr2 = parser.getRepository();
        ClassMetaData _entityMeta2 = mdr2.getMetaData(BaseTestEntity1.class, null, true);
        FieldMapping fm = (FieldMapping)_entityMeta2.getField("one2Melems");
        Column oc = fm.getOrderColumn();
        TestOrderColumnXML.assertNotNull((Object)oc);
        TestOrderColumnXML.assertEquals((String)oc.getName(), (String)"one2MOrder");
        fm = (FieldMapping)_entityMeta2.getField("m2melems");
        oc = fm.getOrderColumn();
        TestOrderColumnXML.assertNotNull((Object)oc);
        TestOrderColumnXML.assertEquals((String)oc.getName(), (String)"m2morder");
        fm = (FieldMapping)_entityMeta2.getField("collelems");
        oc = fm.getOrderColumn();
        TestOrderColumnXML.assertNotNull((Object)oc);
        TestOrderColumnXML.assertEquals((String)oc.getName(), (String)"collelems_ORDER");
        try {
            if (emf1 != null) {
                this.cleanupEMF(emf1);
            }
        }
        catch (Exception e) {
            TestOrderColumnXML.fail((String)e.getMessage());
        }
    }

    private Column getOrderColumn(OpenJPAEntityManagerFactorySPI emf1, Class clazz, String fieldName) {
        JDBCConfiguration conf = (JDBCConfiguration)emf1.getConfiguration();
        ClassMapping cls = conf.getMappingRepositoryInstance().getMapping(clazz, null, true);
        FieldMapping fm = cls.getFieldMapping(fieldName);
        Column oc = fm.getOrderColumn();
        TestOrderColumnXML.assertNotNull((Object)oc);
        return oc;
    }

    private void validateOrderColumnTable(OpenJPAEntityManagerFactorySPI emf1, Class clazz, String fieldName, String tableName, String columnName) {
        Column oc = this.getOrderColumn(emf1, clazz, fieldName);
        TestOrderColumnXML.assertTrue((boolean)oc.getTableName().equalsIgnoreCase(tableName));
        TestOrderColumnXML.assertTrue((boolean)this.tableAndColumnExists(emf1, null, tableName, null, columnName));
    }

    private void validateOrderColumnDef(OpenJPAEntityManagerFactorySPI emf1, Class clazz, String fieldName, String type) {
        Column oc = this.getOrderColumn(emf1, clazz, fieldName);
        TestOrderColumnXML.assertEquals((String)type, (String)oc.getTypeName());
    }

    private void validateOrderColumnNullable(OpenJPAEntityManagerFactorySPI emf1, Class clazz, String fieldName, boolean nullable) {
        Column oc = this.getOrderColumn(emf1, clazz, fieldName);
        TestOrderColumnXML.assertEquals((boolean)nullable, (!oc.isNotNull() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tableAndColumnExists(OpenJPAEntityManagerFactorySPI emf1, OpenJPAEntityManagerSPI em, String tableName, String schemaName, String columnName) {
        JDBCConfiguration conf = (JDBCConfiguration)emf1.getConfiguration();
        DBDictionary dict = conf.getDBDictionaryInstance();
        OpenJPAEntityManagerSPI em1 = em;
        if (em1 == null) {
            em1 = emf1.createEntityManager();
        }
        Connection conn = (Connection)em1.getConnection();
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            Column[] cols = dict.getColumns(dbmd, null, null, tableName, columnName, conn);
            if (cols != null && cols.length == 1) {
                Column col = cols[0];
                String colName = col.getName();
                if (col.getTableName().equalsIgnoreCase(tableName) && (schemaName == null || col.getSchemaName().equalsIgnoreCase(schemaName)) && colName.equalsIgnoreCase(columnName)) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (Throwable e) {
            TestOrderColumnXML.fail((String)"Unable to get column information.");
        }
        finally {
            if (em == null) {
                em1.close();
            }
        }
        return false;
    }

    private void cleanupEMF(OpenJPAEntityManagerFactorySPI emf1) throws Exception {
        if (emf1 == null) {
            return;
        }
        try {
            this.clear((EntityManagerFactory)emf1);
        }
        catch (Exception e) {
            if (this.testResult.wasSuccessful()) {
                throw e;
            }
        }
        finally {
            this.closeEMF((EntityManagerFactory)emf1);
        }
    }
}

