/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.meta.vertical;

import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.jdbc.common.apps.Base;
import org.apache.openjpa.persistence.jdbc.common.apps.BaseSub1;
import org.apache.openjpa.persistence.jdbc.common.apps.BaseSub1Sub1;
import org.apache.openjpa.persistence.jdbc.common.apps.BaseSub1Sub2;
import org.apache.openjpa.persistence.jdbc.common.apps.BaseSub2;
import org.apache.openjpa.persistence.jdbc.kernel.TestSQLListenerTestCase;
import org.apache.openjpa.util.Id;

public class TestSubclassJoinGetObjectById
extends TestSQLListenerTestCase {
    private String _outer = "OUTER";

    public TestSubclassJoinGetObjectById(String name) {
        super(name);
    }

    public boolean skipTest() {
        return false;
    }

    @Override
    public void setUpTestCase() {
        Class[] reg = new Class[]{Base.class, BaseSub1.class, BaseSub2.class, BaseSub1Sub1.class, BaseSub1Sub2.class};
        if (((JDBCConfiguration)this.getConfiguration()).getDBDictionaryInstance().joinSyntax == 2) {
            this._outer = "(+)";
        }
        this.deleteAll(Base.class);
    }

    public void testBase() throws Exception {
        Base pc = new Base();
        pc.setBaseField(1);
        Object oid = this.persist(pc);
        sql.clear();
        OpenJPAEntityManager pm = this.currentEntityManager();
        pc = (Base)pm.getObjectId(oid);
        TestSubclassJoinGetObjectById.assertEquals((int)1, (int)pc.getBaseField());
        TestSubclassJoinGetObjectById.assertEquals(Base.class, pc.getClass());
        pm.close();
        TestSubclassJoinGetObjectById.assertEquals((int)1, (int)sql.size());
        this.assertNotSQL(this._outer);
        sql.clear();
        oid = new Id(Base.class, ((Id)oid).getId());
        pm = this.currentEntityManager();
        pc = (Base)pm.getObjectId(oid);
        TestSubclassJoinGetObjectById.assertEquals((int)1, (int)pc.getBaseField());
        TestSubclassJoinGetObjectById.assertEquals(Base.class, pc.getClass());
        pm.close();
        TestSubclassJoinGetObjectById.assertEquals((int)1, (int)sql.size());
        this.assertSQL(this._outer);
    }

    public void testBadId() throws Exception {
        Base pc = new Base();
        pc.setBaseField(1);
        Object oid = this.persist(pc);
        sql.clear();
        Id id = new Id(Base.class, -1L);
        OpenJPAEntityManager pm = this.currentEntityManager();
        try {
            pm.getObjectId((Object)id);
            TestSubclassJoinGetObjectById.fail((String)"No exception on bad id.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        pm.close();
    }

    public void testLeaf() throws Exception {
        BaseSub1Sub2 pc = new BaseSub1Sub2();
        pc.setBaseField(4);
        pc.setBaseSub1Field(5);
        pc.setBaseSub1Sub2Field(6);
        Object oid = this.persist(pc);
        sql.clear();
        OpenJPAEntityManager pm = this.currentEntityManager();
        pc = (BaseSub1Sub2)pm.getObjectId(oid);
        TestSubclassJoinGetObjectById.assertEquals((int)4, (int)pc.getBaseField());
        TestSubclassJoinGetObjectById.assertEquals((int)5, (int)pc.getBaseSub1Field());
        TestSubclassJoinGetObjectById.assertEquals((int)6, (int)pc.getBaseSub1Sub2Field());
        pm.close();
        TestSubclassJoinGetObjectById.assertEquals((int)1, (int)sql.size());
        this.assertNotSQL(this._outer);
        sql.clear();
        oid = new Id(Base.class, ((Id)oid).getId());
        pm = this.currentEntityManager();
        pc = (BaseSub1Sub2)pm.getObjectId(oid);
        TestSubclassJoinGetObjectById.assertEquals((int)4, (int)pc.getBaseField());
        TestSubclassJoinGetObjectById.assertEquals((int)5, (int)pc.getBaseSub1Field());
        TestSubclassJoinGetObjectById.assertEquals((int)6, (int)pc.getBaseSub1Sub2Field());
        pm.close();
        TestSubclassJoinGetObjectById.assertEquals((int)1, (int)sql.size());
        this.assertSQL(this._outer);
    }

    public void testLeaf2() throws Exception {
        BaseSub2 pc = new BaseSub2();
        pc.setBaseField(3);
        pc.setBaseSub2Field(4);
        Object oid = this.persist(pc);
        sql.clear();
        OpenJPAEntityManager pm = this.currentEntityManager();
        pc = (BaseSub2)pm.getObjectId(oid);
        TestSubclassJoinGetObjectById.assertEquals((int)3, (int)pc.getBaseField());
        TestSubclassJoinGetObjectById.assertEquals((int)4, (int)pc.getBaseSub2Field());
        TestSubclassJoinGetObjectById.assertEquals(BaseSub2.class, pc.getClass());
        pm.close();
        TestSubclassJoinGetObjectById.assertEquals((int)1, (int)sql.size());
        this.assertNotSQL(this._outer);
        sql.clear();
        oid = new Id(Base.class, ((Id)oid).getId());
        pm = this.currentEntityManager();
        pc = (BaseSub2)pm.getObjectId(oid);
        TestSubclassJoinGetObjectById.assertEquals((int)3, (int)pc.getBaseField());
        TestSubclassJoinGetObjectById.assertEquals((int)4, (int)pc.getBaseSub2Field());
        TestSubclassJoinGetObjectById.assertEquals(BaseSub2.class, pc.getClass());
        pm.close();
        TestSubclassJoinGetObjectById.assertEquals((int)1, (int)sql.size());
        this.assertSQL(this._outer);
    }

    public void testMid() throws Exception {
        BaseSub1 pc = new BaseSub1();
        pc.setBaseField(2);
        pc.setBaseSub1Field(3);
        Object oid = this.persist(pc);
        sql.clear();
        OpenJPAEntityManager pm = this.currentEntityManager();
        pc = (BaseSub1)pm.getObjectId(oid);
        TestSubclassJoinGetObjectById.assertEquals((int)2, (int)pc.getBaseField());
        TestSubclassJoinGetObjectById.assertEquals((int)3, (int)pc.getBaseSub1Field());
        TestSubclassJoinGetObjectById.assertEquals(BaseSub1.class, pc.getClass());
        pm.close();
        TestSubclassJoinGetObjectById.assertEquals((int)1, (int)sql.size());
        this.assertNotSQL(this._outer);
        sql.clear();
        oid = new Id(Base.class, ((Id)oid).getId());
        pm = this.currentEntityManager();
        pc = (BaseSub1)pm.getObjectId(oid);
        TestSubclassJoinGetObjectById.assertEquals((int)2, (int)pc.getBaseField());
        TestSubclassJoinGetObjectById.assertEquals((int)3, (int)pc.getBaseSub1Field());
        TestSubclassJoinGetObjectById.assertEquals(BaseSub1.class, pc.getClass());
        pm.close();
        TestSubclassJoinGetObjectById.assertEquals((int)1, (int)sql.size());
        this.assertSQL(this._outer);
    }
}

