/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.meta;

import java.util.ArrayList;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.jdbc.common.apps.MultiA;
import org.apache.openjpa.persistence.jdbc.common.apps.MultiC;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;

public class TestMultiTableSelfCollection
extends BaseJDBCTest {
    private Object a1oid;
    private Object a2oid;
    private Object a3oid;
    private Object a4oid;
    private Object c1oid;
    private Object c2oid;
    private Object c3oid;
    private Object c4oid;

    public TestMultiTableSelfCollection(String name) {
        super(name);
    }

    public TestMultiTableSelfCollection() {
    }

    public void setUp() {
        this.deleteAll(MultiA.class);
        OpenJPAEntityManager pm = this.currentEntityManager();
        pm.getTransaction().begin();
        ArrayList<MultiA> os = new ArrayList<MultiA>();
        MultiA a1 = new MultiA();
        MultiA a2 = new MultiA();
        MultiA a3 = new MultiA();
        MultiA a4 = new MultiA();
        MultiC c1 = new MultiC();
        MultiC c2 = new MultiC();
        MultiC c3 = new MultiC();
        MultiC c4 = new MultiC();
        os.add(a1);
        os.add(a2);
        os.add(a3);
        os.add(a4);
        os.add(c1);
        os.add(c2);
        os.add(c3);
        os.add(c4);
        c1.getMultiAs().add(a1);
        c1.getMultiAs().add(a2);
        a1.getMultiCs().add(c1);
        a2.getMultiCs().add(c1);
        c2.getMultiAs().add(a1);
        c2.getMultiAs().add(a2);
        a1.getMultiCs().add(c2);
        a2.getMultiCs().add(c2);
        c3.getMultiAs().add(a3);
        c3.getMultiAs().add(a4);
        a3.getMultiCs().add(c3);
        a4.getMultiCs().add(c3);
        c4.getMultiAs().add(a3);
        c4.getMultiAs().add(a4);
        a3.getMultiCs().add(c4);
        a4.getMultiCs().add(c4);
        pm.persistAll(os);
        pm.getTransaction().commit();
        this.a1oid = pm.getObjectId((Object)a1);
        this.a2oid = pm.getObjectId((Object)a2);
        this.a3oid = pm.getObjectId((Object)a3);
        this.a4oid = pm.getObjectId((Object)a4);
        this.c1oid = pm.getObjectId((Object)c1);
        this.c2oid = pm.getObjectId((Object)c2);
        this.c3oid = pm.getObjectId((Object)c3);
        this.c4oid = pm.getObjectId((Object)c4);
        pm.close();
    }

    public void testSelfCollections() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        MultiA a1 = (MultiA)pm.getObjectId(this.a1oid);
        TestMultiTableSelfCollection.assertEquals((int)2, (int)a1.getMultiCs().size());
        MultiA a2 = (MultiA)pm.getObjectId(this.a2oid);
        TestMultiTableSelfCollection.assertEquals((int)2, (int)a2.getMultiCs().size());
        TestMultiTableSelfCollection.assertEquals((Object)a1.getMultiCs(), (Object)a2.getMultiCs());
        MultiA a3 = (MultiA)pm.getObjectId(this.a3oid);
        TestMultiTableSelfCollection.assertEquals((int)2, (int)a3.getMultiCs().size());
        MultiA a4 = (MultiA)pm.getObjectId(this.a4oid);
        TestMultiTableSelfCollection.assertEquals((int)2, (int)a4.getMultiCs().size());
        TestMultiTableSelfCollection.assertEquals((Object)a3.getMultiCs(), (Object)a4.getMultiCs());
        MultiC c1 = (MultiC)pm.getObjectId(this.c1oid);
        TestMultiTableSelfCollection.assertEquals((int)2, (int)c1.getMultiAs().size());
        MultiC c2 = (MultiC)pm.getObjectId(this.c2oid);
        TestMultiTableSelfCollection.assertEquals((int)2, (int)c2.getMultiAs().size());
        TestMultiTableSelfCollection.assertEquals((Object)c1.getMultiAs(), (Object)c2.getMultiAs());
        MultiC c3 = (MultiC)pm.getObjectId(this.c3oid);
        TestMultiTableSelfCollection.assertEquals((int)2, (int)c3.getMultiAs().size());
        MultiC c4 = (MultiC)pm.getObjectId(this.c4oid);
        TestMultiTableSelfCollection.assertEquals((int)2, (int)c4.getMultiAs().size());
        TestMultiTableSelfCollection.assertEquals((Object)c3.getMultiAs(), (Object)c4.getMultiAs());
        TestMultiTableSelfCollection.assertTrue((boolean)a1.getMultiCs().contains(c1));
        TestMultiTableSelfCollection.assertTrue((boolean)a1.getMultiCs().contains(c2));
        TestMultiTableSelfCollection.assertTrue((!a1.getMultiCs().contains(c3) ? 1 : 0) != 0);
        TestMultiTableSelfCollection.assertTrue((!a1.getMultiCs().contains(c4) ? 1 : 0) != 0);
        TestMultiTableSelfCollection.assertTrue((boolean)a2.getMultiCs().contains(c1));
        TestMultiTableSelfCollection.assertTrue((boolean)a2.getMultiCs().contains(c2));
        TestMultiTableSelfCollection.assertTrue((!a2.getMultiCs().contains(c3) ? 1 : 0) != 0);
        TestMultiTableSelfCollection.assertTrue((!a2.getMultiCs().contains(c4) ? 1 : 0) != 0);
        TestMultiTableSelfCollection.assertTrue((!a3.getMultiCs().contains(c1) ? 1 : 0) != 0);
        TestMultiTableSelfCollection.assertTrue((!a3.getMultiCs().contains(c2) ? 1 : 0) != 0);
        TestMultiTableSelfCollection.assertTrue((boolean)a3.getMultiCs().contains(c3));
        TestMultiTableSelfCollection.assertTrue((boolean)a3.getMultiCs().contains(c4));
        TestMultiTableSelfCollection.assertTrue((!a4.getMultiCs().contains(c1) ? 1 : 0) != 0);
        TestMultiTableSelfCollection.assertTrue((!a4.getMultiCs().contains(c2) ? 1 : 0) != 0);
        TestMultiTableSelfCollection.assertTrue((boolean)a4.getMultiCs().contains(c3));
        TestMultiTableSelfCollection.assertTrue((boolean)a4.getMultiCs().contains(c4));
        TestMultiTableSelfCollection.assertTrue((boolean)c1.getMultiAs().contains(a1));
        TestMultiTableSelfCollection.assertTrue((boolean)c1.getMultiAs().contains(a2));
        TestMultiTableSelfCollection.assertTrue((!c1.getMultiAs().contains(a3) ? 1 : 0) != 0);
        TestMultiTableSelfCollection.assertTrue((!c1.getMultiAs().contains(a4) ? 1 : 0) != 0);
        TestMultiTableSelfCollection.assertTrue((boolean)c2.getMultiAs().contains(a1));
        TestMultiTableSelfCollection.assertTrue((boolean)c2.getMultiAs().contains(a2));
        TestMultiTableSelfCollection.assertTrue((!c2.getMultiAs().contains(a3) ? 1 : 0) != 0);
        TestMultiTableSelfCollection.assertTrue((!c2.getMultiAs().contains(a4) ? 1 : 0) != 0);
        TestMultiTableSelfCollection.assertTrue((!c3.getMultiAs().contains(a1) ? 1 : 0) != 0);
        TestMultiTableSelfCollection.assertTrue((!c3.getMultiAs().contains(a2) ? 1 : 0) != 0);
        TestMultiTableSelfCollection.assertTrue((boolean)c3.getMultiAs().contains(a3));
        TestMultiTableSelfCollection.assertTrue((boolean)c3.getMultiAs().contains(a4));
        TestMultiTableSelfCollection.assertTrue((!c4.getMultiAs().contains(a1) ? 1 : 0) != 0);
        TestMultiTableSelfCollection.assertTrue((!c4.getMultiAs().contains(a2) ? 1 : 0) != 0);
        TestMultiTableSelfCollection.assertTrue((boolean)c4.getMultiAs().contains(a3));
        TestMultiTableSelfCollection.assertTrue((boolean)c4.getMultiAs().contains(a4));
        pm.close();
    }
}

