/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.meta;

import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.strats.SuperclassDiscriminatorStrategy;
import org.apache.openjpa.jdbc.meta.strats.ValueMapDiscriminatorStrategy;
import org.apache.openjpa.persistence.Extent;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.common.apps.MultiE;
import org.apache.openjpa.persistence.jdbc.common.apps.MultiF;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;

public class TestMetaDataValueIndicator
extends BaseJDBCTest {
    private OpenJPAEntityManager pm;
    private ClassMapping eMapping;
    private ClassMapping fMapping;

    public TestMetaDataValueIndicator(String str) {
        super(str);
    }

    public TestMetaDataValueIndicator() {
    }

    public void setUp() {
        Class<MultiE> c = MultiE.class;
        c = MultiF.class;
        this.pm = this.currentEntityManager();
        this.eMapping = (ClassMapping)((OpenJPAEntityManagerSPI)this.pm).getConfiguration().getMetaDataRepositoryInstance().getMetaData(MultiE.class, this.pm.getClassLoader(), true);
        this.fMapping = (ClassMapping)((OpenJPAEntityManagerSPI)this.pm).getConfiguration().getMetaDataRepositoryInstance().getMetaData(MultiF.class, this.pm.getClassLoader(), true);
    }

    @Override
    public void tearDown() throws Exception {
        if (this.pm.getTransaction().isActive()) {
            this.pm.getTransaction().rollback();
        }
        this.pm.close();
        super.tearDown();
    }

    public void testMetaData() {
        TestMetaDataValueIndicator.assertEquals(ValueMapDiscriminatorStrategy.class, this.eMapping.getDiscriminator().getStrategy().getClass());
        TestMetaDataValueIndicator.assertEquals(SuperclassDiscriminatorStrategy.class, this.fMapping.getDiscriminator().getStrategy().getClass());
    }

    public void testOperations() {
        this.deleteAll(MultiE.class);
        this.pm = this.currentEntityManager();
        this.pm.getTransaction().begin();
        MultiE e = new MultiE();
        e.setString0("foo");
        this.pm.persist((Object)e);
        MultiF f = new MultiF();
        f.setString0("bar");
        this.pm.persist((Object)f);
        this.pm.getTransaction().commit();
        this.pm = this.currentEntityManager();
        Object oid = null;
        this.pm = this.currentEntityManager();
        TestMetaDataValueIndicator.assertNotNull((Object)this.pm.getObjectId(oid));
        this.pm.close();
        this.pm = this.currentEntityManager();
        TestMetaDataValueIndicator.assertNotNull((Object)this.pm.getObjectId(oid));
    }

    private int countExtent(Extent e) {
        int count = 0;
        for (Object o : e) {
            ++count;
        }
        return count;
    }
}

