/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.meta;

import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.meta.RefreshStrategyInstaller;
import org.apache.openjpa.jdbc.meta.StrategyInstaller;
import org.apache.openjpa.jdbc.meta.strats.BlobValueHandler;
import org.apache.openjpa.jdbc.meta.strats.ClobValueHandler;
import org.apache.openjpa.jdbc.meta.strats.MaxEmbeddedClobFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.StringFieldStrategy;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.SchemaGroup;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;

public class TestJDBCType
extends BaseJDBCTest {
    public TestJDBCType(String name) {
        super(name);
    }

    public void testSchemaGeneration() {
        Column[] cols;
        Class<?> cls;
        JDBCConfigurationImpl conf = new JDBCConfigurationImpl();
        DBDictionary dict = conf.getDBDictionaryInstance();
        MappingRepository repos = conf.getMappingRepositoryInstance();
        repos.setStrategyInstaller((StrategyInstaller)new RefreshStrategyInstaller(repos));
        ClassMapping mapping = repos.getMapping(Column.class, null, true);
        if (dict.getPreferredType(1006) == 1006) {
            if (dict.maxEmbeddedClobSize > 0) {
                cls = mapping.getFieldMapping("toClob").getStrategy().getClass();
                TestJDBCType.assertTrue((String)cls.getName(), (boolean)MaxEmbeddedClobFieldStrategy.class.isAssignableFrom(cls));
            } else {
                cls = mapping.getFieldMapping("toClob").getHandler().getClass();
                TestJDBCType.assertTrue((String)cls.getName(), (boolean)ClobValueHandler.class.isAssignableFrom(cls));
            }
        } else {
            TestJDBCType.assertTrue((boolean)(mapping.getFieldMapping("toClob").getStrategy() instanceof StringFieldStrategy));
        }
        cls = mapping.getFieldMapping("toBlob").getHandler().getClass();
        TestJDBCType.assertTrue((String)cls.getName(), (boolean)BlobValueHandler.class.isAssignableFrom(cls));
        SchemaGroup schema = repos.getSchemaGroup();
        Table table = schema.getSchemas()[0].getTables()[0];
        for (Column col : cols = table.getColumns()) {
            if (col.getName().equalsIgnoreCase("id") || col.getName().equalsIgnoreCase("versn") || col.getName().equalsIgnoreCase("typ")) continue;
            if ("longToInt".equalsIgnoreCase(col.getName())) {
                TestJDBCType.assertEquals((int)dict.getPreferredType(5), (int)col.getType());
                continue;
            }
            if ("longToSQL".equalsIgnoreCase(col.getName())) {
                TestJDBCType.assertEquals((String)"varchar", (String)col.getTypeName());
                continue;
            }
            if ("toClob".equalsIgnoreCase(col.getName())) {
                TestJDBCType.assertEquals((int)dict.getPreferredType(1006), (int)col.getType());
                continue;
            }
            if ("toBlob".equalsIgnoreCase(col.getName())) {
                TestJDBCType.assertEquals((int)dict.getPreferredType(1003), (int)col.getType());
                continue;
            }
            TestJDBCType.fail((String)("Unknown column:" + col.getName()));
        }
    }
}

