/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.meta;

import javax.persistence.EntityManager;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.jdbc.common.apps.RuntimeTest1;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;

public class TestIntermediate
extends BaseJDBCTest {
    private Object _pc;
    private Object _rel;

    public TestIntermediate(String test) {
        super(test);
    }

    public TestIntermediate() {
    }

    public void setUp() {
        RuntimeTest1 pc = new RuntimeTest1("pc", 1);
        RuntimeTest1 rel = new RuntimeTest1("rel", 2);
        pc.setSelfOneOne(rel);
        OpenJPAEntityManager em = this.currentEntityManager();
        Broker broker = JPAFacadeHelper.toBroker((EntityManager)em);
        broker.begin();
        broker.persist((Object)pc, null);
        broker.commit();
        this._pc = broker.getObjectId((Object)pc);
        this._rel = broker.getObjectId((Object)rel);
        broker.close();
        em.close();
    }

    public void testOneOneSetsIntermediate() {
        OpenJPAEntityManager em = this.currentEntityManager();
        Broker broker = JPAFacadeHelper.toBroker((EntityManager)em);
        try {
            this.oneOneIntermediateTest(broker);
        }
        finally {
            broker.close();
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDataCacheOneOneSetsIntermediate() {
        BrokerFactory factory = this.getBrokerFactory(new String[]{"openjpa.DataCache", "true", "openjpa.RemoteCommitProvider", "sjvm"});
        try (Broker broker = factory.newBroker();){
            broker.find(this._pc, true, null);
        }
        broker = factory.newBroker();
        try {
            this.oneOneIntermediateTest(broker);
        }
        finally {
            broker.close();
            try {
                factory.close();
            }
            catch (Exception exception) {}
        }
    }

    private void oneOneIntermediateTest(Broker broker) {
        RuntimeTest1 pc = (RuntimeTest1)broker.find(this._pc, true, null);
        OpenJPAStateManager sm = broker.getStateManager((Object)pc);
        TestIntermediate.assertNotNull((Object)sm);
        FieldMetaData fmd = sm.getMetaData().getField("selfOneOne");
        TestIntermediate.assertNotNull((Object)fmd);
        TestIntermediate.assertEquals((Object)this._rel, (Object)sm.getIntermediate(fmd.getIndex()));
        TestIntermediate.assertEquals((Object)this._rel, (Object)broker.getObjectId((Object)pc.getSelfOneOne()));
        TestIntermediate.assertNull((Object)sm.getIntermediate(fmd.getIndex()));
    }
}

