/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.meta;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.persistence.FetchPlan;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.jdbc.common.apps.EagerOuterJoinPC;
import org.apache.openjpa.persistence.jdbc.common.apps.EagerOuterJoinPC2;
import org.apache.openjpa.persistence.jdbc.common.apps.HelperPC;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;

public class TestEagerOuterToManyJoins
extends BaseJDBCTest {
    public TestEagerOuterToManyJoins(String name) {
        super(name);
    }

    public boolean skipTest() {
        DBDictionary dict = ((JDBCConfiguration)this.getConfiguration()).getDBDictionaryInstance();
        return !dict.supportsSubselect;
    }

    public void setUp() {
        this.deleteAll(HelperPC.class);
        this.deleteAll(EagerOuterJoinPC2.class);
        this.deleteAll(EagerOuterJoinPC.class);
    }

    public void testStringCollectionById() {
        this.stringCollectionByIdTest(false);
    }

    public void testEmptyStringCollectionById() {
        this.stringCollectionByIdTest(true);
    }

    private void stringCollectionByIdTest(boolean empty) {
        Object oid = this.insertStringCollection(empty ? 1 : 0);
        OpenJPAEntityManager pm = this.currentEntityManager();
        FetchPlan fetch = pm.getFetchPlan();
        fetch.addField(EagerOuterJoinPC.class, "stringCollection");
        EagerOuterJoinPC pc = (EagerOuterJoinPC)pm.getObjectId(oid);
        TestEagerOuterToManyJoins.assertEquals((String)"1", (String)pc.getName());
        if (empty) {
            TestEagerOuterToManyJoins.assertEquals((String)pc.getStringCollection().toString(), (int)0, (int)pc.getStringCollection().size());
        } else {
            TestEagerOuterToManyJoins.assertEquals((String)pc.getStringCollection().toString(), (int)2, (int)pc.getStringCollection().size());
            TestEagerOuterToManyJoins.assertTrue((boolean)pc.getStringCollection().contains("1.1"));
            TestEagerOuterToManyJoins.assertTrue((boolean)pc.getStringCollection().contains("1.2"));
        }
        pm.close();
    }

    public void testStringCollectionByQuery() {
        this.stringCollectionByQueryTest(0);
    }

    public void testEmptyStringCollectionByQuery1() {
        this.stringCollectionByQueryTest(1);
    }

    public void testEmptyStringCollectionByQuery2() {
        this.stringCollectionByQueryTest(2);
    }

    public void testEmptyStringCollectionByQuery3() {
        this.stringCollectionByQueryTest(3);
    }

    private void stringCollectionByQueryTest(int empty) {
        this.insertStringCollection(empty);
        OpenJPAEntityManager pm = this.currentEntityManager();
        FetchPlan fetch = pm.getFetchPlan();
        fetch.addField(EagerOuterJoinPC.class, "stringCollection");
        fetch.setFetchBatchSize(-1);
        OpenJPAQuery q = pm.createNativeQuery("", EagerOuterJoinPC.class);
        List results = q.getResultList();
        TestEagerOuterToManyJoins.assertEquals((int)2, (int)results.size());
        Iterator itr = results.iterator();
        EagerOuterJoinPC pc = (EagerOuterJoinPC)itr.next();
        TestEagerOuterToManyJoins.assertEquals((String)"1", (String)pc.getName());
        if ((empty & 1) > 0) {
            TestEagerOuterToManyJoins.assertEquals((String)pc.getStringCollection().toString(), (int)0, (int)pc.getStringCollection().size());
        } else {
            TestEagerOuterToManyJoins.assertEquals((String)pc.getStringCollection().toString(), (int)2, (int)pc.getStringCollection().size());
            TestEagerOuterToManyJoins.assertTrue((boolean)pc.getStringCollection().contains("1.1"));
            TestEagerOuterToManyJoins.assertTrue((boolean)pc.getStringCollection().contains("1.2"));
        }
        pc = (EagerOuterJoinPC)itr.next();
        TestEagerOuterToManyJoins.assertEquals((String)"2", (String)pc.getName());
        if ((empty & 2) > 0) {
            TestEagerOuterToManyJoins.assertEquals((String)pc.getStringCollection().toString(), (int)0, (int)pc.getStringCollection().size());
        } else {
            TestEagerOuterToManyJoins.assertEquals((String)pc.getStringCollection().toString(), (int)2, (int)pc.getStringCollection().size());
            TestEagerOuterToManyJoins.assertTrue((boolean)pc.getStringCollection().contains("2.1"));
            TestEagerOuterToManyJoins.assertTrue((boolean)pc.getStringCollection().contains("2.2"));
        }
        TestEagerOuterToManyJoins.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
        pm.close();
    }

    private Object insertStringCollection(int empty) {
        EagerOuterJoinPC pc1 = new EagerOuterJoinPC();
        pc1.setName("1");
        if ((empty & 1) == 0) {
            pc1.getStringCollection().add("1.1");
            pc1.getStringCollection().add("1.2");
        }
        EagerOuterJoinPC pc2 = new EagerOuterJoinPC();
        pc2.setName("2");
        if ((empty & 2) == 0) {
            pc2.getStringCollection().add("2.1");
            pc2.getStringCollection().add("2.2");
        }
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc1);
        pm.persist((Object)pc2);
        this.endTx((EntityManager)pm);
        Object oid = pm.getObjectId((Object)pc1);
        pm.close();
        return oid;
    }

    public void testStringListById() {
        Object oid = this.insertStringList();
        OpenJPAEntityManager pm = this.currentEntityManager();
        FetchPlan fetch = pm.getFetchPlan();
        fetch.addField(EagerOuterJoinPC.class, "stringList");
        EagerOuterJoinPC pc = (EagerOuterJoinPC)pm.getObjectId(oid);
        TestEagerOuterToManyJoins.assertEquals((String)"1", (String)pc.getName());
        TestEagerOuterToManyJoins.assertEquals((int)2, (int)pc.getStringList().size());
        TestEagerOuterToManyJoins.assertEquals((Object)"1.1", pc.getStringList().get(0));
        TestEagerOuterToManyJoins.assertEquals((Object)"1.2", pc.getStringList().get(1));
        pm.close();
    }

    public void testStringListByQuery() {
        this.insertStringList();
        OpenJPAEntityManager pm = this.currentEntityManager();
        FetchPlan fetch = pm.getFetchPlan();
        fetch.addField(EagerOuterJoinPC.class, "stringList");
        fetch.setFetchBatchSize(-1);
        OpenJPAQuery q = pm.createNativeQuery("", EagerOuterJoinPC.class);
        List results = q.getResultList();
        TestEagerOuterToManyJoins.assertEquals((int)2, (int)results.size());
        Iterator itr = results.iterator();
        EagerOuterJoinPC pc = (EagerOuterJoinPC)itr.next();
        TestEagerOuterToManyJoins.assertEquals((String)"1", (String)pc.getName());
        TestEagerOuterToManyJoins.assertEquals((int)2, (int)pc.getStringList().size());
        TestEagerOuterToManyJoins.assertEquals((Object)"1.1", pc.getStringList().get(0));
        TestEagerOuterToManyJoins.assertEquals((Object)"1.2", pc.getStringList().get(1));
        pc = (EagerOuterJoinPC)itr.next();
        TestEagerOuterToManyJoins.assertEquals((String)"2", (String)pc.getName());
        TestEagerOuterToManyJoins.assertEquals((int)2, (int)pc.getStringList().size());
        TestEagerOuterToManyJoins.assertEquals((Object)"2.1", pc.getStringList().get(0));
        TestEagerOuterToManyJoins.assertEquals((Object)"2.2", pc.getStringList().get(1));
        TestEagerOuterToManyJoins.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
        pm.close();
    }

    private Object insertStringList() {
        EagerOuterJoinPC pc1 = new EagerOuterJoinPC();
        pc1.setName("1");
        pc1.getStringList().add("1.1");
        pc1.getStringList().add("1.2");
        EagerOuterJoinPC pc2 = new EagerOuterJoinPC();
        pc2.setName("2");
        pc2.getStringList().add("2.1");
        pc2.getStringList().add("2.2");
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc1);
        pm.persist((Object)pc2);
        this.endTx((EntityManager)pm);
        Object oid = pm.getObjectId((Object)pc1);
        pm.close();
        return oid;
    }

    public void testOneManyCollectionById() {
        this.oneManyCollectionByIdTest(false);
    }

    public void testEmptyOneManyCollectionById() {
        this.oneManyCollectionByIdTest(true);
    }

    private void oneManyCollectionByIdTest(boolean empty) {
        Object oid = this.insertOneManyCollection(empty ? 1 : 0);
        OpenJPAEntityManager pm = this.currentEntityManager();
        FetchPlan fetch = pm.getFetchPlan();
        fetch.addField(EagerOuterJoinPC.class, "oneManyCollection");
        EagerOuterJoinPC pc = (EagerOuterJoinPC)pm.getObjectId(oid);
        TestEagerOuterToManyJoins.assertEquals((String)"1", (String)pc.getName());
        if (empty) {
            TestEagerOuterToManyJoins.assertEquals((int)0, (int)pc.getOneManyCollection().size());
        } else {
            TestEagerOuterToManyJoins.assertEquals((int)2, (int)pc.getOneManyCollection().size());
        }
        pm.close();
    }

    public void testOneManyCollectionByQuery() {
        this.oneManyCollectionByQueryTest(0);
    }

    public void testEmptyOneManyCollectionByQuery1() {
        this.oneManyCollectionByQueryTest(1);
    }

    public void testEmptyOneManyCollectionByQuery2() {
        this.oneManyCollectionByQueryTest(2);
    }

    public void testEmptyOneManyCollectionByQuery3() {
        this.oneManyCollectionByQueryTest(3);
    }

    private void oneManyCollectionByQueryTest(int empty) {
        this.insertOneManyCollection(empty);
        OpenJPAEntityManager pm = this.currentEntityManager();
        FetchPlan fetch = pm.getFetchPlan();
        fetch.addField(EagerOuterJoinPC.class, "oneManyCollection");
        fetch.setFetchBatchSize(-1);
        OpenJPAQuery q = pm.createNativeQuery("", EagerOuterJoinPC.class);
        List results = q.getResultList();
        TestEagerOuterToManyJoins.assertEquals((int)2, (int)results.size());
        Iterator itr = results.iterator();
        EagerOuterJoinPC pc = (EagerOuterJoinPC)itr.next();
        TestEagerOuterToManyJoins.assertEquals((String)"1", (String)pc.getName());
        if ((empty & 1) > 0) {
            TestEagerOuterToManyJoins.assertEquals((int)0, (int)pc.getOneManyCollection().size());
        } else {
            TestEagerOuterToManyJoins.assertEquals((int)2, (int)pc.getOneManyCollection().size());
        }
        pc = (EagerOuterJoinPC)itr.next();
        TestEagerOuterToManyJoins.assertEquals((String)"2", (String)pc.getName());
        if ((empty & 2) > 0) {
            TestEagerOuterToManyJoins.assertEquals((int)0, (int)pc.getOneManyCollection().size());
        } else {
            TestEagerOuterToManyJoins.assertEquals((int)2, (int)pc.getOneManyCollection().size());
        }
        TestEagerOuterToManyJoins.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
        pm.close();
    }

    private Object insertOneManyCollection(int empty) {
        EagerOuterJoinPC2 hpc;
        EagerOuterJoinPC pc1 = new EagerOuterJoinPC();
        pc1.setName("1");
        if ((empty & 1) == 0) {
            hpc = new EagerOuterJoinPC2();
            hpc.setName("1.1");
            hpc.setRef(pc1);
            pc1.getOneManyCollection().add(hpc);
            hpc = new EagerOuterJoinPC2();
            hpc.setName("1.2");
            hpc.setRef(pc1);
            pc1.getOneManyCollection().add(hpc);
        }
        EagerOuterJoinPC pc2 = new EagerOuterJoinPC();
        pc2.setName("2");
        if ((empty & 2) == 0) {
            hpc = new EagerOuterJoinPC2();
            hpc.setName("2.1");
            hpc.setRef(pc2);
            pc2.getOneManyCollection().add(hpc);
            hpc = new EagerOuterJoinPC2();
            hpc.setName("2.2");
            hpc.setRef(pc2);
            pc2.getOneManyCollection().add(hpc);
        }
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc1);
        pm.persist((Object)pc2);
        this.endTx((EntityManager)pm);
        Object oid = pm.getObjectId((Object)pc1);
        pm.close();
        return oid;
    }

    public void testManyManyCollectionById() {
        Object oid = this.insertManyManyCollection();
        OpenJPAEntityManager pm = this.currentEntityManager();
        FetchPlan fetch = pm.getFetchPlan();
        fetch.addField(EagerOuterJoinPC.class, "manyManyCollection");
        EagerOuterJoinPC pc = (EagerOuterJoinPC)pm.getObjectId(oid);
        TestEagerOuterToManyJoins.assertEquals((String)"1", (String)pc.getName());
        TestEagerOuterToManyJoins.assertEquals((int)2, (int)pc.getManyManyCollection().size());
        pm.close();
    }

    public void testManyManyCollectionByQuery() {
        this.insertManyManyCollection();
        OpenJPAEntityManager pm = this.currentEntityManager();
        FetchPlan fetch = pm.getFetchPlan();
        fetch.addField(EagerOuterJoinPC.class, "manyManyCollection");
        fetch.setFetchBatchSize(-1);
        OpenJPAQuery q = pm.createNativeQuery("", EagerOuterJoinPC.class);
        List results = q.getResultList();
        TestEagerOuterToManyJoins.assertEquals((int)2, (int)results.size());
        Iterator itr = results.iterator();
        EagerOuterJoinPC pc = (EagerOuterJoinPC)itr.next();
        TestEagerOuterToManyJoins.assertEquals((String)"1", (String)pc.getName());
        TestEagerOuterToManyJoins.assertEquals((int)2, (int)pc.getManyManyCollection().size());
        pc = (EagerOuterJoinPC)itr.next();
        TestEagerOuterToManyJoins.assertEquals((String)"2", (String)pc.getName());
        TestEagerOuterToManyJoins.assertEquals((int)2, (int)pc.getManyManyCollection().size());
        TestEagerOuterToManyJoins.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
        pm.close();
    }

    private Object insertManyManyCollection() {
        EagerOuterJoinPC pc1 = new EagerOuterJoinPC();
        pc1.setName("1");
        EagerOuterJoinPC2 hpc = new EagerOuterJoinPC2();
        hpc.setName("1.1");
        pc1.getManyManyCollection().add(hpc);
        hpc = new EagerOuterJoinPC2();
        hpc.setName("1.2");
        pc1.getManyManyCollection().add(hpc);
        EagerOuterJoinPC pc2 = new EagerOuterJoinPC();
        pc2.setName("2");
        hpc = new EagerOuterJoinPC2();
        hpc.setName("2.1");
        pc2.getManyManyCollection().add(hpc);
        hpc = new EagerOuterJoinPC2();
        hpc.setName("2.2");
        pc2.getManyManyCollection().add(hpc);
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc1);
        pm.persist((Object)pc2);
        this.endTx((EntityManager)pm);
        Object oid = pm.getObjectId((Object)pc1);
        pm.close();
        return oid;
    }

    public void testManyManyListById() {
        this.manyManyListByIdTest(false);
    }

    public void testEmptyManyManyListById() {
        this.manyManyListByIdTest(true);
    }

    private void manyManyListByIdTest(boolean empty) {
        Object oid = this.insertManyManyList(empty ? 1 : 0);
        OpenJPAEntityManager pm = this.currentEntityManager();
        FetchPlan fetch = pm.getFetchPlan();
        fetch.addField(EagerOuterJoinPC.class, "manyManyList");
        EagerOuterJoinPC pc = (EagerOuterJoinPC)pm.getObjectId(oid);
        TestEagerOuterToManyJoins.assertEquals((String)"1", (String)pc.getName());
        if (empty) {
            TestEagerOuterToManyJoins.assertEquals((int)0, (int)pc.getManyManyList().size());
        } else {
            TestEagerOuterToManyJoins.assertEquals((int)2, (int)pc.getManyManyList().size());
            EagerOuterJoinPC2 hpc = (EagerOuterJoinPC2)pc.getManyManyList().get(0);
            TestEagerOuterToManyJoins.assertEquals((String)"1.1", (String)hpc.getName());
            hpc = (EagerOuterJoinPC2)pc.getManyManyList().get(1);
            TestEagerOuterToManyJoins.assertEquals((String)"1.2", (String)hpc.getName());
        }
        pm.close();
    }

    public void testManyManyListByQuery() {
        this.manyManyListByQueryTest(0);
    }

    public void testEmptyManyManyListByQuery1() {
        this.manyManyListByQueryTest(1);
    }

    public void testEmptyManyManyListByQuery2() {
        this.manyManyListByQueryTest(2);
    }

    public void testEmptyManyManyListByQuery3() {
        this.manyManyListByQueryTest(3);
    }

    private void manyManyListByQueryTest(int empty) {
        EagerOuterJoinPC2 hpc;
        this.insertManyManyList(empty);
        OpenJPAEntityManager pm = this.currentEntityManager();
        FetchPlan fetch = pm.getFetchPlan();
        fetch.addField(EagerOuterJoinPC.class, "manyManyList");
        fetch.setFetchBatchSize(-1);
        OpenJPAQuery q = pm.createNativeQuery("", EagerOuterJoinPC.class);
        List results = q.getResultList();
        TestEagerOuterToManyJoins.assertEquals((int)2, (int)results.size());
        Iterator itr = results.iterator();
        EagerOuterJoinPC pc = (EagerOuterJoinPC)itr.next();
        TestEagerOuterToManyJoins.assertEquals((String)"1", (String)pc.getName());
        if ((empty & 1) > 0) {
            TestEagerOuterToManyJoins.assertEquals((int)0, (int)pc.getManyManyList().size());
        } else {
            TestEagerOuterToManyJoins.assertEquals((int)2, (int)pc.getManyManyList().size());
            hpc = (EagerOuterJoinPC2)pc.getManyManyList().get(0);
            TestEagerOuterToManyJoins.assertEquals((String)"1.1", (String)hpc.getName());
            hpc = (EagerOuterJoinPC2)pc.getManyManyList().get(1);
            TestEagerOuterToManyJoins.assertEquals((String)"1.2", (String)hpc.getName());
        }
        pc = (EagerOuterJoinPC)itr.next();
        TestEagerOuterToManyJoins.assertEquals((String)"2", (String)pc.getName());
        if ((empty & 2) > 0) {
            TestEagerOuterToManyJoins.assertEquals((int)0, (int)pc.getManyManyList().size());
        } else {
            TestEagerOuterToManyJoins.assertEquals((int)2, (int)pc.getManyManyList().size());
            hpc = (EagerOuterJoinPC2)pc.getManyManyList().get(0);
            TestEagerOuterToManyJoins.assertEquals((String)"2.1", (String)hpc.getName());
            hpc = (EagerOuterJoinPC2)pc.getManyManyList().get(1);
            TestEagerOuterToManyJoins.assertEquals((String)"2.2", (String)hpc.getName());
        }
        TestEagerOuterToManyJoins.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
        pm.close();
    }

    private Object insertManyManyList(int empty) {
        EagerOuterJoinPC2 hpc;
        EagerOuterJoinPC pc1 = new EagerOuterJoinPC();
        pc1.setName("1");
        if ((empty & 1) == 0) {
            hpc = new EagerOuterJoinPC2();
            hpc.setName("1.1");
            pc1.getManyManyList().add(hpc);
            hpc = new EagerOuterJoinPC2();
            hpc.setName("1.2");
            pc1.getManyManyList().add(hpc);
        }
        EagerOuterJoinPC pc2 = new EagerOuterJoinPC();
        pc2.setName("2");
        if ((empty & 2) == 0) {
            hpc = new EagerOuterJoinPC2();
            hpc.setName("2.1");
            pc2.getManyManyList().add(hpc);
            hpc = new EagerOuterJoinPC2();
            hpc.setName("2.2");
            pc2.getManyManyList().add(hpc);
        }
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc1);
        pm.persist((Object)pc2);
        this.endTx((EntityManager)pm);
        Object oid = pm.getObjectId((Object)pc1);
        pm.close();
        return oid;
    }

    public void testTwoCollectionsInFetchGroupsById() {
        Object oid = this.insertTwoCollections();
        OpenJPAEntityManager pm = this.currentEntityManager();
        FetchPlan fetch = pm.getFetchPlan();
        fetch.addField(EagerOuterJoinPC.class, "stringCollection");
        fetch.addField(EagerOuterJoinPC.class, "manyManyList");
        EagerOuterJoinPC pc = (EagerOuterJoinPC)pm.getObjectId(oid);
        TestEagerOuterToManyJoins.assertEquals((String)"1", (String)pc.getName());
        TestEagerOuterToManyJoins.assertEquals((int)2, (int)pc.getStringCollection().size());
        TestEagerOuterToManyJoins.assertTrue((boolean)pc.getStringCollection().contains("1.1"));
        TestEagerOuterToManyJoins.assertTrue((boolean)pc.getStringCollection().contains("1.2"));
        TestEagerOuterToManyJoins.assertEquals((int)2, (int)pc.getManyManyList().size());
        EagerOuterJoinPC2 hpc = (EagerOuterJoinPC2)pc.getManyManyList().get(0);
        TestEagerOuterToManyJoins.assertEquals((String)"1.1", (String)hpc.getName());
        hpc = (EagerOuterJoinPC2)pc.getManyManyList().get(1);
        TestEagerOuterToManyJoins.assertEquals((String)"1.2", (String)hpc.getName());
        pm.close();
    }

    public void testTwoCollectionsInFetchGroupsByQuery() {
        this.insertTwoCollections();
        OpenJPAEntityManager pm = this.currentEntityManager();
        FetchPlan fetch = pm.getFetchPlan();
        fetch.addField(EagerOuterJoinPC.class, "stringCollection");
        fetch.addField(EagerOuterJoinPC.class, "manyManyList");
        fetch.setFetchBatchSize(-1);
        OpenJPAQuery q = pm.createNativeQuery("", EagerOuterJoinPC.class);
        List results = q.getResultList();
        TestEagerOuterToManyJoins.assertEquals((int)2, (int)results.size());
        Iterator itr = results.iterator();
        EagerOuterJoinPC pc = (EagerOuterJoinPC)itr.next();
        TestEagerOuterToManyJoins.assertEquals((String)"1", (String)pc.getName());
        TestEagerOuterToManyJoins.assertEquals((int)2, (int)pc.getStringCollection().size());
        TestEagerOuterToManyJoins.assertTrue((boolean)pc.getStringCollection().contains("1.1"));
        TestEagerOuterToManyJoins.assertTrue((boolean)pc.getStringCollection().contains("1.2"));
        TestEagerOuterToManyJoins.assertEquals((int)2, (int)pc.getManyManyList().size());
        EagerOuterJoinPC2 hpc = (EagerOuterJoinPC2)pc.getManyManyList().get(0);
        TestEagerOuterToManyJoins.assertEquals((String)"1.1", (String)hpc.getName());
        hpc = (EagerOuterJoinPC2)pc.getManyManyList().get(1);
        TestEagerOuterToManyJoins.assertEquals((String)"1.2", (String)hpc.getName());
        pc = (EagerOuterJoinPC)itr.next();
        TestEagerOuterToManyJoins.assertEquals((String)"2", (String)pc.getName());
        TestEagerOuterToManyJoins.assertEquals((int)2, (int)pc.getStringCollection().size());
        TestEagerOuterToManyJoins.assertTrue((boolean)pc.getStringCollection().contains("2.1"));
        TestEagerOuterToManyJoins.assertTrue((boolean)pc.getStringCollection().contains("2.2"));
        TestEagerOuterToManyJoins.assertEquals((int)2, (int)pc.getManyManyList().size());
        hpc = (EagerOuterJoinPC2)pc.getManyManyList().get(0);
        TestEagerOuterToManyJoins.assertEquals((String)"2.1", (String)hpc.getName());
        hpc = (EagerOuterJoinPC2)pc.getManyManyList().get(1);
        TestEagerOuterToManyJoins.assertEquals((String)"2.2", (String)hpc.getName());
        TestEagerOuterToManyJoins.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
        pm.close();
    }

    private Object insertTwoCollections() {
        EagerOuterJoinPC pc1 = new EagerOuterJoinPC();
        pc1.setName("1");
        pc1.getStringCollection().add("1.1");
        pc1.getStringCollection().add("1.2");
        EagerOuterJoinPC2 hpc = new EagerOuterJoinPC2();
        hpc.setName("1.1");
        pc1.getManyManyList().add(hpc);
        hpc = new EagerOuterJoinPC2();
        hpc.setName("1.2");
        pc1.getManyManyList().add(hpc);
        EagerOuterJoinPC pc2 = new EagerOuterJoinPC();
        pc2.setName("2");
        pc2.getStringCollection().add("2.1");
        pc2.getStringCollection().add("2.2");
        hpc = new EagerOuterJoinPC2();
        hpc.setName("2.1");
        pc2.getManyManyList().add(hpc);
        hpc = new EagerOuterJoinPC2();
        hpc.setName("2.2");
        pc2.getManyManyList().add(hpc);
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc1);
        pm.persist((Object)pc2);
        this.endTx((EntityManager)pm);
        Object oid = pm.getObjectId((Object)pc1);
        pm.close();
        return oid;
    }

    public void testQueryRandomAccess() {
        this.insertManyStringList();
        OpenJPAEntityManager pm = this.currentEntityManager();
        FetchPlan fetch = pm.getFetchPlan();
        fetch.addField(EagerOuterJoinPC.class, "stringList");
        fetch.setFetchBatchSize(3);
        OpenJPAQuery q = pm.createNativeQuery("", EagerOuterJoinPC.class);
        List results = q.getResultList();
        TestEagerOuterToManyJoins.assertEquals((int)10, (int)results.size());
        for (int i = 5; i < results.size(); ++i) {
            EagerOuterJoinPC pc = (EagerOuterJoinPC)results.get(i);
            TestEagerOuterToManyJoins.assertEquals((String)String.valueOf(i), (String)pc.getName());
            TestEagerOuterToManyJoins.assertEquals((int)2, (int)pc.getStringList().size());
            TestEagerOuterToManyJoins.assertEquals((Object)(i + ".1"), pc.getStringList().get(0));
            TestEagerOuterToManyJoins.assertEquals((Object)(i + ".2"), pc.getStringList().get(1));
        }
        q.closeAll();
        pm.close();
    }

    public void testQueryRange() {
        this.insertManyStringList();
        OpenJPAEntityManager pm = this.currentEntityManager();
        FetchPlan fetch = pm.getFetchPlan();
        fetch.addField(EagerOuterJoinPC.class, "stringList");
        fetch.setFetchBatchSize(3);
        OpenJPAQuery q = pm.createNativeQuery("", EagerOuterJoinPC.class);
        List results = q.getResultList();
        TestEagerOuterToManyJoins.assertEquals((int)5, (int)results.size());
        for (int i = 0; i < results.size(); ++i) {
            EagerOuterJoinPC pc = (EagerOuterJoinPC)results.get(i);
            TestEagerOuterToManyJoins.assertEquals((String)String.valueOf(i + 5), (String)pc.getName());
            TestEagerOuterToManyJoins.assertEquals((int)2, (int)pc.getStringList().size());
            TestEagerOuterToManyJoins.assertEquals((Object)(i + 5 + ".1"), pc.getStringList().get(0));
            TestEagerOuterToManyJoins.assertEquals((Object)(i + 5 + ".2"), pc.getStringList().get(1));
        }
        q.closeAll();
        pm.close();
    }

    private void insertManyStringList() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        for (int i = 0; i < 10; ++i) {
            EagerOuterJoinPC pc = new EagerOuterJoinPC();
            pc.setName(String.valueOf(i));
            pc.getStringList().add(i + ".1");
            pc.getStringList().add(i + ".2");
            pm.persist((Object)pc);
        }
        this.endTx((EntityManager)pm);
        pm.close();
    }

    public void testEagerToOneThenEagerToMany() {
        this.insertEagers();
        OpenJPAEntityManager pm = this.currentEntityManager();
        FetchPlan fetch = pm.getFetchPlan();
        fetch.addField(EagerOuterJoinPC2.class, "ref");
        fetch.addField(EagerOuterJoinPC.class, "stringCollection");
        OpenJPAQuery q = pm.createNativeQuery("", EagerOuterJoinPC2.class);
        List results = q.getResultList();
        TestEagerOuterToManyJoins.assertEquals((String)new ArrayList(results).toString(), (int)2, (int)results.size());
        Iterator itr = results.iterator();
        EagerOuterJoinPC2 ref = (EagerOuterJoinPC2)itr.next();
        TestEagerOuterToManyJoins.assertEquals((String)"r1", (String)ref.getName());
        EagerOuterJoinPC pc = ref.getRef();
        TestEagerOuterToManyJoins.assertEquals((String)"1", (String)pc.getName());
        TestEagerOuterToManyJoins.assertEquals((int)2, (int)pc.getStringCollection().size());
        TestEagerOuterToManyJoins.assertTrue((boolean)pc.getStringCollection().contains("1.1"));
        TestEagerOuterToManyJoins.assertTrue((boolean)pc.getStringCollection().contains("1.2"));
        ref = (EagerOuterJoinPC2)itr.next();
        TestEagerOuterToManyJoins.assertEquals((String)"r2", (String)ref.getName());
        TestEagerOuterToManyJoins.assertTrue((pc == ref.getRef() ? 1 : 0) != 0);
        TestEagerOuterToManyJoins.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
        pm.close();
    }

    public void testEagerToManyThenEagerToOne() {
        this.insertEagers();
        OpenJPAEntityManager pm = this.currentEntityManager();
        FetchPlan fetch = pm.getFetchPlan();
        fetch.addField(EagerOuterJoinPC.class, "manyManyList");
        fetch.addField(EagerOuterJoinPC2.class, "helper");
        OpenJPAQuery q = pm.createNativeQuery("", EagerOuterJoinPC.class);
        List results = q.getResultList();
        TestEagerOuterToManyJoins.assertEquals((int)1, (int)results.size());
        EagerOuterJoinPC pc = (EagerOuterJoinPC)results.iterator().next();
        TestEagerOuterToManyJoins.assertEquals((String)"1", (String)pc.getName());
        TestEagerOuterToManyJoins.assertEquals((int)2, (int)pc.getManyManyList().size());
        EagerOuterJoinPC2 ref = (EagerOuterJoinPC2)pc.getManyManyList().get(0);
        TestEagerOuterToManyJoins.assertEquals((String)"r1", (String)ref.getName());
        TestEagerOuterToManyJoins.assertEquals((String)"h1", (String)ref.getHelper().getStringField());
        ref = (EagerOuterJoinPC2)pc.getManyManyList().get(1);
        TestEagerOuterToManyJoins.assertEquals((String)"r2", (String)ref.getName());
        TestEagerOuterToManyJoins.assertEquals((String)"h2", (String)ref.getHelper().getStringField());
        pm.close();
    }

    public void testEagerToManyThenEagerToMany() {
        this.insertEagers();
        OpenJPAEntityManager pm = this.currentEntityManager();
        FetchPlan fetch = pm.getFetchPlan();
        fetch.addField(EagerOuterJoinPC.class, "manyManyList");
        fetch.addField(EagerOuterJoinPC2.class, "stringCollection");
        OpenJPAQuery q = pm.createNativeQuery("", EagerOuterJoinPC.class);
        List results = q.getResultList();
        TestEagerOuterToManyJoins.assertEquals((int)1, (int)results.size());
        EagerOuterJoinPC pc = (EagerOuterJoinPC)results.iterator().next();
        TestEagerOuterToManyJoins.assertEquals((String)"1", (String)pc.getName());
        TestEagerOuterToManyJoins.assertEquals((int)2, (int)pc.getManyManyList().size());
        EagerOuterJoinPC2 ref = (EagerOuterJoinPC2)pc.getManyManyList().get(0);
        TestEagerOuterToManyJoins.assertEquals((String)"r1", (String)ref.getName());
        TestEagerOuterToManyJoins.assertEquals((int)2, (int)ref.getStringCollection().size());
        TestEagerOuterToManyJoins.assertTrue((boolean)ref.getStringCollection().contains("r1.1"));
        TestEagerOuterToManyJoins.assertTrue((boolean)ref.getStringCollection().contains("r1.2"));
        ref = (EagerOuterJoinPC2)pc.getManyManyList().get(1);
        TestEagerOuterToManyJoins.assertEquals((String)"r2", (String)ref.getName());
        TestEagerOuterToManyJoins.assertEquals((int)2, (int)ref.getStringCollection().size());
        TestEagerOuterToManyJoins.assertTrue((boolean)ref.getStringCollection().contains("r2.1"));
        TestEagerOuterToManyJoins.assertTrue((boolean)ref.getStringCollection().contains("r2.2"));
        pm.close();
    }

    public void testEagerToOneAndToManyThenEagerToOne() {
        Object oid = this.insertEagers();
        OpenJPAEntityManager pm = this.currentEntityManager();
        FetchPlan fetch = pm.getFetchPlan();
        fetch.addField(EagerOuterJoinPC.class, "oneManyCollection");
        fetch.addField(EagerOuterJoinPC.class, "helper");
        fetch.addField(EagerOuterJoinPC2.class, "helper");
        OpenJPAQuery q = pm.createNativeQuery("", EagerOuterJoinPC.class);
        List results = q.getResultList();
        TestEagerOuterToManyJoins.assertEquals((int)1, (int)results.size());
        EagerOuterJoinPC pc = (EagerOuterJoinPC)results.iterator().next();
        TestEagerOuterToManyJoins.assertEquals((String)"1", (String)pc.getName());
        TestEagerOuterToManyJoins.assertEquals((String)"h3", (String)pc.getHelper().getStringField());
        TestEagerOuterToManyJoins.assertEquals((int)2, (int)pc.getOneManyCollection().size());
        Iterator itr = pc.getOneManyCollection().iterator();
        EagerOuterJoinPC2 ref = (EagerOuterJoinPC2)itr.next();
        if ("r1".equals(ref.getName())) {
            TestEagerOuterToManyJoins.assertEquals((String)"h1", (String)ref.getHelper().getStringField());
            ref = (EagerOuterJoinPC2)itr.next();
            TestEagerOuterToManyJoins.assertEquals((String)"r2", (String)ref.getName());
            TestEagerOuterToManyJoins.assertEquals((String)"h2", (String)ref.getHelper().getStringField());
        } else {
            TestEagerOuterToManyJoins.assertEquals((String)"r2", (String)ref.getName());
            TestEagerOuterToManyJoins.assertEquals((String)"h2", (String)ref.getHelper().getStringField());
            ref = (EagerOuterJoinPC2)itr.next();
            TestEagerOuterToManyJoins.assertEquals((String)"r1", (String)ref.getName());
            TestEagerOuterToManyJoins.assertEquals((String)"h1", (String)ref.getHelper().getStringField());
        }
        TestEagerOuterToManyJoins.assertTrue((!itr.hasNext() ? 1 : 0) != 0);
        pm.close();
    }

    private Object insertEagers() {
        EagerOuterJoinPC pc1 = new EagerOuterJoinPC();
        pc1.setName("1");
        pc1.getStringCollection().add("1.1");
        pc1.getStringCollection().add("1.2");
        EagerOuterJoinPC2 ref1 = new EagerOuterJoinPC2();
        ref1.setName("r1");
        ref1.getStringCollection().add("r1.1");
        ref1.getStringCollection().add("r1.2");
        EagerOuterJoinPC2 ref2 = new EagerOuterJoinPC2();
        ref2.setName("r2");
        ref2.getStringCollection().add("r2.1");
        ref2.getStringCollection().add("r2.2");
        HelperPC hpc1 = new HelperPC();
        hpc1.setStringField("h1");
        HelperPC hpc2 = new HelperPC();
        hpc2.setStringField("h2");
        HelperPC hpc3 = new HelperPC();
        hpc3.setStringField("h3");
        pc1.getManyManyList().add(ref1);
        pc1.getOneManyCollection().add(ref1);
        ref1.setRef(pc1);
        pc1.getManyManyList().add(ref2);
        pc1.getOneManyCollection().add(ref2);
        ref2.setRef(pc1);
        ref1.setHelper(hpc1);
        ref2.setHelper(hpc2);
        pc1.setHelper(hpc3);
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc1);
        this.endTx((EntityManager)pm);
        Object oid = pm.getObjectId((Object)pc1);
        pm.close();
        return oid;
    }
}

