/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.meta;

import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.jdbc.common.apps.CustomMappingPC;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;

public class TestEJBCustomMapping
extends BaseJDBCTest {
    private int _oid;

    public TestEJBCustomMapping(String name) {
        super(name);
    }

    public void setUp() {
        this.deleteAll(CustomMappingPC.class);
        CustomMappingPC pc = new CustomMappingPC(2);
        pc.setName("name");
        pc.setFemale(true);
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc);
        this.endTx((EntityManager)pm);
        this._oid = pc.getId();
        this.endEm((EntityManager)pm);
    }

    public void testInsert() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        CustomMappingPC pc = (CustomMappingPC)pm.find(CustomMappingPC.class, (Object)this._oid);
        TestEJBCustomMapping.assertNotNull((Object)pc);
        TestEJBCustomMapping.assertEquals((String)"name", (String)pc.getName());
        TestEJBCustomMapping.assertEquals((boolean)true, (boolean)pc.isFemale());
        this.endEm((EntityManager)pm);
    }

    public void testUpdate() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        CustomMappingPC pc = (CustomMappingPC)pm.find(CustomMappingPC.class, (Object)this._oid);
        pc.setName("name2");
        pc.setFemale(false);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pc = (CustomMappingPC)pm.find(CustomMappingPC.class, (Object)this._oid);
        TestEJBCustomMapping.assertEquals((String)"name2", (String)pc.getName());
        TestEJBCustomMapping.assertTrue((!pc.isFemale() ? 1 : 0) != 0);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }
}

