/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.meta;

import java.util.Iterator;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.jdbc.common.apps.ConstantJoinPC4;
import org.apache.openjpa.persistence.jdbc.common.apps.ConstantJoinPC5;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;

public class TestEJBConstantJoinOnSameRefTable
extends BaseJDBCTest {
    private int oid;

    public TestEJBConstantJoinOnSameRefTable(String name) {
        super(name);
    }

    public void setUp() {
        this.deleteAll(ConstantJoinPC4.class);
        this.deleteAll(ConstantJoinPC5.class);
        ConstantJoinPC4 pc4 = new ConstantJoinPC4("pc4-1", 1);
        pc4.setOneToOne1(new ConstantJoinPC5("pc5-one-to-one-1"));
        pc4.getManyToMany().add(new ConstantJoinPC5("pc5-many-to-many-1"));
        pc4.getManyToMany().add(new ConstantJoinPC5("pc5-many-to-many-2"));
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc4);
        this.endTx((EntityManager)pm);
        this.oid = pc4.getId();
        this.endEm((EntityManager)pm);
    }

    public void testConstantManyToMany() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        ConstantJoinPC4 pc4 = (ConstantJoinPC4)pm.find(ConstantJoinPC4.class, (Object)this.oid);
        TestEJBConstantJoinOnSameRefTable.assertEquals((int)2, (int)pc4.getManyToMany().size());
        Iterator iter = pc4.getManyToMany().iterator();
        ConstantJoinPC5 pc5_1 = (ConstantJoinPC5)iter.next();
        ConstantJoinPC5 pc5_2 = (ConstantJoinPC5)iter.next();
        if ("pc5-many-to-many-2".equals(pc5_1.getName())) {
            ConstantJoinPC5 other = pc5_1;
            pc5_1 = pc5_2;
            pc5_2 = other;
        }
        TestEJBConstantJoinOnSameRefTable.assertEquals((String)"pc5-many-to-many-1", (String)pc5_1.getName());
        TestEJBConstantJoinOnSameRefTable.assertEquals((String)"pc5-many-to-many-2", (String)pc5_2.getName());
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testConstantOneToOne1() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        ConstantJoinPC4 pc4 = (ConstantJoinPC4)pm.find(ConstantJoinPC4.class, (Object)this.oid);
        TestEJBConstantJoinOnSameRefTable.assertEquals((int)2, (int)pc4.getManyToMany().size());
        TestEJBConstantJoinOnSameRefTable.assertEquals((String)"pc5-one-to-one-1", (String)pc4.getOneToOne1().getName());
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testSharedJoinTableModifications() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        ConstantJoinPC4 pc4 = (ConstantJoinPC4)pm.find(ConstantJoinPC4.class, (Object)this.oid);
        this.startTx((EntityManager)pm);
        pc4.getManyToMany().clear();
        this.endTx((EntityManager)pm);
        OpenJPAEntityManager pm2 = this.currentEntityManager();
        pc4 = (ConstantJoinPC4)pm2.find(ConstantJoinPC4.class, (Object)this.oid);
        TestEJBConstantJoinOnSameRefTable.assertNotNull((Object)pc4.getOneToOne1());
        TestEJBConstantJoinOnSameRefTable.assertEquals((int)0, (int)pc4.getManyToMany().size());
    }
}

