/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.meta;

import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;
import org.apache.openjpa.persistence.kernel.common.apps.ColumnIOPC;

public class TestEJBColumnIOMappings
extends BaseJDBCTest {
    public TestEJBColumnIOMappings(String name) {
        super(name);
    }

    public void setUp() {
        this.deleteAll(ColumnIOPC.class);
    }

    public void testIgnoreInsert() {
        ColumnIOPC pc = new ColumnIOPC(2);
        pc.setName("pc");
        pc.setIgnoreInsert(10);
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc);
        TestEJBColumnIOMappings.assertEquals((int)10, (int)pc.getIgnoreInsert());
        this.endTx((EntityManager)pm);
        this.startTx((EntityManager)pm);
        TestEJBColumnIOMappings.assertEquals((int)10, (int)pc.getIgnoreInsert());
        int oid = pc.getId();
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pc = (ColumnIOPC)pm.find(ColumnIOPC.class, (Object)oid);
        TestEJBColumnIOMappings.assertNotNull((Object)pc);
        TestEJBColumnIOMappings.assertEquals((int)10, (int)pc.getIgnoreInsert());
        pc.setIgnoreInsert(10);
        this.endTx((EntityManager)pm);
        this.startTx((EntityManager)pm);
        TestEJBColumnIOMappings.assertEquals((int)10, (int)pc.getIgnoreInsert());
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pc = (ColumnIOPC)pm.find(ColumnIOPC.class, (Object)oid);
        TestEJBColumnIOMappings.assertNotNull((Object)pc);
        TestEJBColumnIOMappings.assertEquals((int)10, (int)pc.getIgnoreInsert());
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testIgnoreUpdate() {
        ColumnIOPC pc = new ColumnIOPC(3);
        pc.setName("pc");
        pc.setIgnoreUpdate(10);
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc);
        TestEJBColumnIOMappings.assertEquals((int)10, (int)pc.getIgnoreUpdate());
        this.endTx((EntityManager)pm);
        Integer oid = pc.getId();
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pc = (ColumnIOPC)pm.find(ColumnIOPC.class, (Object)oid);
        TestEJBColumnIOMappings.assertNotNull((Object)pc);
        TestEJBColumnIOMappings.assertEquals((int)10, (int)pc.getIgnoreUpdate());
        this.endTx((EntityManager)pm);
        this.startTx((EntityManager)pm);
        pc.setIgnoreUpdate(100);
        TestEJBColumnIOMappings.assertEquals((int)100, (int)pc.getIgnoreUpdate());
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pc = (ColumnIOPC)pm.find(ColumnIOPC.class, (Object)oid);
        TestEJBColumnIOMappings.assertNotNull((Object)pc);
        TestEJBColumnIOMappings.assertEquals((int)10, (int)pc.getIgnoreUpdate());
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testPrimitiveMappedToFieldOfForeignKey() {
        ColumnIOPC rel = new ColumnIOPC(1);
        rel.setName("rel");
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)rel);
        this.endTx((EntityManager)pm);
        this.startTx((EntityManager)pm);
        ColumnIOPC pc = new ColumnIOPC(2);
        pc.setName("pc");
        rel = (ColumnIOPC)pm.find(ColumnIOPC.class, (Object)1);
        pc.setRel(rel);
        rel.setIdent(10);
        pm.persist((Object)pc);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pc = (ColumnIOPC)pm.find(ColumnIOPC.class, (Object)2);
        TestEJBColumnIOMappings.assertNotNull((Object)pc);
        TestEJBColumnIOMappings.assertEquals((int)0, (int)pc.getIdent());
        TestEJBColumnIOMappings.assertNotNull((Object)pc.getRel());
        TestEJBColumnIOMappings.assertEquals((String)"rel", (String)pc.getRel().getName());
        pc.setIdent(50);
        pc.setRel(new ColumnIOPC(3));
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pc = (ColumnIOPC)pm.find(ColumnIOPC.class, (Object)2);
        TestEJBColumnIOMappings.assertNotNull((Object)pc);
        TestEJBColumnIOMappings.assertEquals((int)50, (int)pc.getIdent());
        TestEJBColumnIOMappings.assertNotNull((Object)pc.getRel());
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }
}

