/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.meta;

import javax.persistence.EntityManager;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityTransaction;
import org.apache.openjpa.persistence.jdbc.common.apps.DFGTest;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;

public class TestDFG
extends BaseJDBCTest {
    private Object oid;

    public TestDFG(String name) {
        super(name);
    }

    public void setUp() {
        this.deleteAll(DFGTest.class);
        OpenJPAEntityManager pm = this.currentEntityManager();
        OpenJPAEntityTransaction t = pm.getTransaction();
        t.begin();
        DFGTest a = new DFGTest();
        pm.persist((Object)a);
        a.setNonDFGField(2);
        t.commit();
        t.begin();
        a.setDFGField(1);
        t.commit();
        this.oid = pm.getObjectId((Object)a);
        pm.close();
    }

    public void testDFG() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        DFGTest a = (DFGTest)pm.getObjectId(this.oid);
        OpenJPAStateManager sm = this.getStateManager(a, (EntityManager)pm);
        FieldMetaData fmd = sm.getMetaData().getField("nonDFGField");
        TestDFG.assertTrue((String)"nonDFGField should not be loaded", (!sm.getLoaded().get(fmd.getIndex()) ? 1 : 0) != 0);
        fmd = sm.getMetaData().getField("dfgField");
        TestDFG.assertTrue((String)"dfgField should be loaded", (boolean)sm.getLoaded().get(fmd.getIndex()));
        int val = a.getNonDFGField();
        TestDFG.assertTrue((String)"nonDFGField should be loaded", (boolean)sm.getLoaded().get(fmd.getIndex()));
        TestDFG.assertEquals((int)2, (int)val);
        pm.close();
    }

    public void testDFGWrites() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        DFGTest a = (DFGTest)pm.getObjectId(this.oid);
        a.setDFGField(3);
        this.endTx((EntityManager)pm);
        pm.close();
    }
}

