/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.maps.update;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.maps.update.LocalizedString;
import org.apache.openjpa.persistence.jdbc.maps.update.MultilingualString;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestMapUpdate
extends SQLListenerTestCase {
    private MultilingualString entity1;
    private OpenJPAEntityManagerSPI em;

    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES, MultilingualString.class, LocalizedString.class);
        this.createObj((EntityManagerFactory)this.emf);
        this.em = this.emf.createEntityManager();
    }

    public void testUpdateMapKey() throws Exception {
        this.em.getTransaction().begin();
        MultilingualString ms = (MultilingualString)this.em.find(MultilingualString.class, (Object)this.entity1.getId());
        TestMapUpdate.assertNotNull((Object)ms);
        ms.setText("en", "Good evening");
        this.em.getTransaction().commit();
        this.em.clear();
        this.em.getTransaction().begin();
        ms = (MultilingualString)this.em.find(MultilingualString.class, (Object)this.entity1.getId());
        TestMapUpdate.assertEquals((String)"Good evening", (String)ms.getText("en"));
        this.em.getTransaction().commit();
        this.em.close();
    }

    public void testUpdateMapValue() throws Exception {
        this.em.getTransaction().begin();
        MultilingualString ms = (MultilingualString)this.em.find(MultilingualString.class, (Object)this.entity1.getId());
        TestMapUpdate.assertNotNull((Object)ms);
        ms.getMap().get("en").setString("Good evening");
        this.em.getTransaction().commit();
        this.em.clear();
        this.em.getTransaction().begin();
        ms = (MultilingualString)this.em.find(MultilingualString.class, (Object)this.entity1.getId());
        TestMapUpdate.assertEquals((String)"Good evening", (String)ms.getText("en"));
        this.em.getTransaction().commit();
        this.em.close();
    }

    private void createObj(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        this.entity1 = new MultilingualString("de", "Guten Tag");
        this.entity1.setText("en", "Good morning");
        em.persist((Object)this.entity1);
        em.flush();
        tran.commit();
        em.close();
    }
}

