/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.maps.spec_10_1_29_ex3;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.QueryImpl;
import org.apache.openjpa.persistence.jdbc.maps.spec_10_1_29_ex3.Course;
import org.apache.openjpa.persistence.jdbc.maps.spec_10_1_29_ex3.Semester;
import org.apache.openjpa.persistence.jdbc.maps.spec_10_1_29_ex3.Student;
import org.apache.openjpa.persistence.test.AllowFailure;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;
import org.junit.Assert;

public class TestSpec10_1_29_Ex3
extends SQLListenerTestCase {
    public int numStudents = 2;
    public int numCoursesPerStudent = 2;
    public int studentId = 1;
    public int courseId = 1;
    public int semesterId = 1;
    public List rsAllStudents = null;

    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES, Course.class, Semester.class, Student.class);
        this.createObj((EntityManagerFactory)this.emf);
        this.rsAllStudents = this.getAll(Student.class);
    }

    public void testQueryObj() throws Exception {
        this.queryObj((EntityManagerFactory)this.emf);
    }

    @AllowFailure
    public void testQueryInMemoryQualifiedId() throws Exception {
        this.queryQualifiedId(true);
    }

    public void testQueryQualifiedId() throws Exception {
        this.queryQualifiedId(false);
    }

    public void setCandidate(Query q, Class clz) throws Exception {
        QueryImpl q1 = (QueryImpl)q;
        org.apache.openjpa.kernel.Query q2 = q1.getDelegate();
        org.apache.openjpa.kernel.QueryImpl qi = (org.apache.openjpa.kernel.QueryImpl)q2;
        if (clz == Student.class) {
            qi.setCandidateCollection((Collection)this.rsAllStudents);
        }
    }

    public void queryQualifiedId(boolean inMemory) throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String query = "select KEY(e), e from Student s,  in (s.enrollment) e order by s.id, KEY(e).id";
        Query q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Student.class);
        }
        List rs = q.getResultList();
        Course c = (Course)((Object[])rs.get(0))[0];
        Semester s = (Semester)((Object[])rs.get(0))[1];
        em.clear();
        query = "select ENTRY(e) from Student s,  in (s.enrollment) e order by s.id, KEY(e).id";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Student.class);
        }
        rs = q.getResultList();
        Map.Entry me = (Map.Entry)rs.get(0);
        TestSpec10_1_29_Ex3.assertEquals((Object)c, me.getKey());
        TestSpec10_1_29_Ex3.assertEquals((int)s.getId(), (int)((Semester)me.getValue()).getId());
        em.clear();
        query = "select KEY(e), e from Student s  left join s.enrollment e order by s.id, KEY(e).id";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Student.class);
        }
        rs = q.getResultList();
        c = (Course)((Object[])rs.get(0))[0];
        s = (Semester)((Object[])rs.get(0))[1];
        em.clear();
        query = "select ENTRY(e) from Student s  left join s.enrollment e order by s.id, KEY(e).id";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Student.class);
        }
        rs = q.getResultList();
        me = (Map.Entry)rs.get(0);
        TestSpec10_1_29_Ex3.assertEquals((Object)c, me.getKey());
        TestSpec10_1_29_Ex3.assertEquals((int)s.getId(), (int)((Semester)me.getValue()).getId());
        query = "select KEY(e) from Student s  join s.enrollment e WHERE KEY(e).id = 1 order by s.id, KEY(e).id";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Student.class);
        }
        rs = q.getResultList();
        TestSpec10_1_29_Ex3.assertEquals((int)((Course)rs.get(0)).getId(), (int)1);
        em.close();
    }

    public void createObj(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        for (int i = 0; i < this.numStudents; ++i) {
            this.createStudent(em, this.studentId++);
        }
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public void createStudent(EntityManager em, int id) {
        Student s = new Student();
        s.setId(id);
        for (int i = 0; i < this.numCoursesPerStudent; ++i) {
            Course c = this.createCourse(em, this.courseId++);
            Semester semester = this.createSemester(em, this.semesterId++);
            s.addToEnrollment(c, semester);
            em.persist((Object)c);
            em.persist((Object)semester);
        }
        em.persist((Object)s);
    }

    public Course createCourse(EntityManager em, int id) {
        Course c = new Course();
        c.setId(id);
        c.setName("s" + id);
        return c;
    }

    public Semester createSemester(EntityManager em, int id) {
        Semester s = new Semester();
        s.setId(id);
        s.setName("s" + id);
        return s;
    }

    public void findObj(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        Student s = (Student)em.find(Student.class, (Object)1);
        this.assertStudent(s);
        Course c = (Course)em.find(Course.class, (Object)1);
        this.assertCourse(c);
        Semester sm = (Semester)em.find(Semester.class, (Object)1);
        this.assertSemester(sm);
        em.close();
    }

    public void assertStudent(Student s) {
        int id = s.getId();
        Map enrollment = s.getEnrollment();
        Assert.assertEquals((long)2L, (long)enrollment.size());
    }

    public void assertCourse(Course c) {
        long id = c.getId();
        String name = c.getName();
    }

    public void assertSemester(Semester s) {
        long id = s.getId();
        String name = s.getName();
    }

    public void queryObj(EntityManagerFactory emf) {
        this.queryStudent(emf);
        this.queryCourse(emf);
        this.querySemester(emf);
    }

    public void queryStudent(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select s from Student s");
        List ss = q.getResultList();
        for (Student s : ss) {
            this.assertStudent(s);
        }
        tran.commit();
        em.close();
    }

    public void queryCourse(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select c from Course c");
        List cs = q.getResultList();
        for (Course c : cs) {
            this.assertCourse(c);
        }
        tran.commit();
        em.close();
    }

    public void querySemester(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select s from Semester s");
        List ss = q.getResultList();
        for (Semester s : ss) {
            this.assertSemester(s);
        }
        tran.commit();
        em.close();
    }
}

