/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.maps.spec_10_1_26_ex3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.QueryImpl;
import org.apache.openjpa.persistence.jdbc.maps.spec_10_1_26_ex3.Department;
import org.apache.openjpa.persistence.jdbc.maps.spec_10_1_26_ex3.Employee;
import org.apache.openjpa.persistence.jdbc.maps.spec_10_1_26_ex3.EmployeeName;
import org.apache.openjpa.persistence.test.AllowFailure;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;
import org.junit.Assert;

public class TestSpec10_1_26_Ex3
extends SQLListenerTestCase {
    public int numDepartments = 2;
    public int numEmployeesPerDept = 2;
    public List<String> namedQueries = new ArrayList<String>();
    public int deptId = 1;
    public int empId = 1;
    public List rsAllDepartments = null;

    @Override
    public void setUp() {
        super.setUp(DROP_TABLES, Department.class, Employee.class, EmployeeName.class);
        this.createObj((EntityManagerFactory)this.emf);
        this.rsAllDepartments = this.getAll(Department.class);
    }

    @AllowFailure
    public void testQueryInMemoryQualifiedId() throws Exception {
        this.queryQualifiedId(true);
    }

    public void testQueryQualifiedId() throws Exception {
        this.queryQualifiedId(false);
    }

    public void setCandidate(Query q, Class clz) throws Exception {
        QueryImpl q1 = (QueryImpl)q;
        org.apache.openjpa.kernel.Query q2 = q1.getDelegate();
        org.apache.openjpa.kernel.QueryImpl qi = (org.apache.openjpa.kernel.QueryImpl)q2;
        if (clz == Department.class) {
            qi.setCandidateCollection((Collection)this.rsAllDepartments);
        }
    }

    public void queryQualifiedId(boolean inMemory) throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String query = "select KEY(e) from Department d,  in (d.emps) e order by d.deptId, e.empId";
        Query q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Department.class);
        }
        List rs = q.getResultList();
        EmployeeName d = (EmployeeName)rs.get(0);
        em.clear();
        query = "select ENTRY(e) from Department d,  in (d.emps) e order by d.deptId, e.empId";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Department.class);
        }
        rs = q.getResultList();
        Map.Entry me = (Map.Entry)rs.get(0);
        TestSpec10_1_26_Ex3.assertEquals((Object)d, me.getKey());
        query = "select KEY(e), KEY(e).fName from Department d,  in (d.emps) e order by KEY(e).fName";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Department.class);
        }
        rs = q.getResultList();
        d = (EmployeeName)((Object[])rs.get(0))[0];
        String fname = (String)((Object[])rs.get(0))[1];
        TestSpec10_1_26_Ex3.assertEquals((String)d.getFName(), (String)fname);
        this.sql.clear();
        query = "select COUNT(KEY(e).fName) from Department d  left join d.emps e GROUP BY KEY(e).fName";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Department.class);
        }
        rs = q.getResultList();
        if (!inMemory) {
            TestSpec10_1_26_Ex3.assertTrue((((String)this.sql.get(0)).toUpperCase().indexOf(" GROUP BY ") != -1 ? 1 : 0) != 0);
        }
        query = "select KEY(e) from Department d,  in (d.emps) e where VALUE(e).department.deptId = 1 ORDER BY KEY(e).fName";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Department.class);
        }
        rs = q.getResultList();
        if (!inMemory) {
            TestSpec10_1_26_Ex3.assertEquals((String)((EmployeeName)rs.get(0)).getFName(), (String)"f1");
        }
        query = "select KEY(e) from Department d,  in (d.emps) e where VALUE(e).name.fName = 'f1' ORDER BY KEY(e).fName";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Department.class);
        }
        rs = q.getResultList();
        if (!inMemory) {
            TestSpec10_1_26_Ex3.assertEquals((String)((EmployeeName)rs.get(0)).getFName(), (String)"f1");
        }
        query = "select KEY(e) from Department d,  in (d.emps) e where SUBSTRING(VALUE(e).name.fName, 1) = 'f1' ORDER BY KEY(e).fName";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Department.class);
        }
        rs = q.getResultList();
        if (!inMemory) {
            TestSpec10_1_26_Ex3.assertEquals((String)((EmployeeName)rs.get(0)).getFName(), (String)"f1");
        }
        query = "select KEY(e) from Department d,  in (d.emps) e where LOCATE(VALUE(e).name.fName, 'f1') <> 0 ORDER BY KEY(e).fName";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Department.class);
        }
        rs = q.getResultList();
        if (!inMemory) {
            TestSpec10_1_26_Ex3.assertEquals((String)((EmployeeName)rs.get(0)).getFName(), (String)"f1");
        }
        em.close();
    }

    public void testQueryObject() {
        this.queryObj((EntityManagerFactory)this.emf);
    }

    public void createObj(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        for (int i = 0; i < this.numDepartments; ++i) {
            this.createDepartment(em, this.deptId++);
        }
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public void createDepartment(EntityManager em, int id) {
        Department d = new Department();
        d.setDeptId(id);
        for (int i = 0; i < this.numEmployeesPerDept; ++i) {
            Employee e = this.createEmployee(em, this.empId++);
            d.addEmployee(e);
            e.setDepartment(d);
            em.persist((Object)e);
        }
        em.persist((Object)d);
    }

    public Employee createEmployee(EntityManager em, int id) {
        Employee e = new Employee();
        EmployeeName name = new EmployeeName("f" + id, "l" + id);
        e.setEmpId(id);
        e.setName(name);
        return e;
    }

    public void findObj(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        Department d = (Department)em.find(Department.class, (Object)1);
        this.assertDepartment(d);
        this.updateObj(em, d);
        this.deleteObj(em, d);
        em.close();
    }

    public void updateObj(EntityManager em, Department d) {
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Employee e = this.createEmployee(em, this.numDepartments * this.numEmployeesPerDept + 1);
        d.addEmployee(e);
        e.setDepartment(d);
        em.persist((Object)d);
        em.persist((Object)e);
        em.flush();
        tran.commit();
        tran.begin();
        d.removeEmployee(e.getName());
        e.setDepartment(null);
        em.persist((Object)d);
        em.flush();
        tran.commit();
    }

    public void deleteObj(EntityManager em, Department d) {
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        em.remove((Object)d);
        tran.commit();
    }

    public void assertDepartment(Department d) {
        int id = d.getDeptId();
        Map<EmployeeName, Employee> es = d.getEmployees();
        Assert.assertEquals((long)2L, (long)es.size());
        Set<EmployeeName> keys = es.keySet();
        Iterator<EmployeeName> iterator = keys.iterator();
        while (iterator.hasNext()) {
            EmployeeName obj;
            EmployeeName empName = obj = iterator.next();
            Employee e = es.get(empName);
            Assert.assertEquals((Object)empName, (Object)e.getName());
        }
    }

    public void queryObj(EntityManagerFactory emf) {
        this.queryDepartment(emf);
        this.queryEmployee(emf);
    }

    public void queryDepartment(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select d from Department d");
        List ds = q.getResultList();
        for (Department d : ds) {
            this.assertDepartment(d);
        }
        tran.commit();
        em.close();
    }

    public void queryEmployee(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select e from Employee e");
        List es = q.getResultList();
        for (Employee e : es) {
            this.assertEmployee(e);
        }
        tran.commit();
        em.close();
    }

    public void assertEmployee(Employee e) {
        int id = e.getEmpId();
        Department d = e.getDepartment();
        this.assertDepartment(d);
    }
}

