/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.maps.m2mmapex6;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.QueryImpl;
import org.apache.openjpa.persistence.jdbc.maps.m2mmapex6.Employee;
import org.apache.openjpa.persistence.jdbc.maps.m2mmapex6.FullName;
import org.apache.openjpa.persistence.jdbc.maps.m2mmapex6.PhoneNumber;
import org.apache.openjpa.persistence.test.AllowFailure;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;
import org.junit.Assert;

public class TestMany2ManyMapEx6
extends SQLListenerTestCase {
    public int numEmployees = 2;
    public int numPhoneNumbers = this.numEmployees + 1;
    public int numEmployeesPerPhoneNumber = 2;
    public int numPhoneNumbersPerEmployee = 2;
    public Map<Integer, PhoneNumber> phones = new HashMap<Integer, PhoneNumber>();
    public List<String> namedQueries = new ArrayList<String>();
    public Map<Integer, Employee> empMap = new HashMap<Integer, Employee>();
    public Map<Integer, PhoneNumber> phoneMap = new HashMap<Integer, PhoneNumber>();
    public int empId = 1;
    public int phoneId = 1;
    public int divId = 1;
    public int deptId = 1;
    public List rsAllPhones = null;
    public List rsAllEmps = null;

    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES, Employee.class, PhoneNumber.class, FullName.class);
        this.createObj();
        this.rsAllPhones = this.getAll(PhoneNumber.class);
        this.rsAllEmps = this.getAll(Employee.class);
    }

    @AllowFailure
    public void testQueryInMemoryQualifiedId() throws Exception {
        this.queryQualifiedId(true);
    }

    public void testQueryQualifiedId() throws Exception {
        this.queryQualifiedId(false);
    }

    public void setCandidate(Query q, Class clz) throws Exception {
        QueryImpl q1 = (QueryImpl)q;
        org.apache.openjpa.kernel.Query q2 = q1.getDelegate();
        org.apache.openjpa.kernel.QueryImpl qi = (org.apache.openjpa.kernel.QueryImpl)q2;
        if (clz == PhoneNumber.class) {
            qi.setCandidateCollection((Collection)this.rsAllPhones);
        } else if (clz == Employee.class) {
            qi.setCandidateCollection((Collection)this.rsAllEmps);
        }
    }

    public void queryQualifiedId(boolean inMemory) throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String query = "select KEY(e) from PhoneNumber p,  in (p.emps) e order by e.empId";
        Query q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, PhoneNumber.class);
        }
        List rs = q.getResultList();
        FullName d = (FullName)rs.get(0);
        query = "select KEY(p) from Employee e,  in (e.phones) p";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Employee.class);
        }
        rs = q.getResultList();
        String k = (String)rs.get(0);
        em.clear();
        query = "select ENTRY(e) from PhoneNumber p,  in (p.emps) e order by e.empId";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, PhoneNumber.class);
        }
        rs = q.getResultList();
        Map.Entry me = (Map.Entry)rs.get(0);
        TestMany2ManyMapEx6.assertEquals((Object)d, me.getKey());
        this.sql.clear();
        query = "select count(KEY(e).lName) from PhoneNumber p  left join p.emps e GROUP BY KEY(e).lName";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, PhoneNumber.class);
        }
        rs = q.getResultList();
        if (!inMemory) {
            TestMany2ManyMapEx6.assertTrue((((String)this.sql.get(0)).toUpperCase().indexOf(" GROUP BY ") != -1 ? 1 : 0) != 0);
        }
        em.close();
    }

    public void testQueryObject() throws Exception {
        this.queryObj();
        this.findObj();
    }

    public void createObj() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        for (int i = 0; i < this.numEmployees; ++i) {
            Employee e = this.createEmployee((EntityManager)em, this.empId++);
            this.empMap.put(e.getEmpId(), e);
        }
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public Employee createEmployee(EntityManager em, int id) {
        Employee e = new Employee();
        e.setEmpId(id);
        for (int i = 0; i < this.numPhoneNumbersPerEmployee; ++i) {
            PhoneNumber phoneNumber = new PhoneNumber();
            phoneNumber.setNumber(this.phoneId++);
            FullName name = new FullName("f" + id, "l" + id);
            phoneNumber.addEmployees(name, e);
            e.addPhoneNumber("String" + phoneNumber.getNumber(), phoneNumber);
            em.persist((Object)phoneNumber);
            this.phoneMap.put(phoneNumber.getNumber(), phoneNumber);
        }
        em.persist((Object)e);
        return e;
    }

    public void findObj() throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Employee e = (Employee)em.find(Employee.class, (Object)1);
        this.assertEmployee(e);
        PhoneNumber p = (PhoneNumber)em.find(PhoneNumber.class, (Object)1);
        this.assertPhoneNumber(p);
        em.close();
    }

    public void queryObj() throws Exception {
        this.queryEmployee();
        this.queryPhoneNumber();
    }

    public void queryPhoneNumber() throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select p from PhoneNumber p");
        List ps = q.getResultList();
        for (PhoneNumber p : ps) {
            this.assertPhoneNumber(p);
        }
        tran.commit();
        em.close();
    }

    public void queryEmployee() throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select e from Employee e");
        List es = q.getResultList();
        for (Employee e : es) {
            this.assertEmployee(e);
        }
        tran.commit();
        em.close();
    }

    public void assertEmployee(Employee e) throws Exception {
        int id = e.getEmpId();
        Employee e0 = this.empMap.get(id);
        Map<String, PhoneNumber> phones = e.getPhoneNumbers();
        Map<String, PhoneNumber> phones0 = e0.getPhoneNumbers();
        Assert.assertEquals((long)phones0.size(), (long)phones.size());
        this.checkPhoneMap(phones0, phones);
    }

    public void assertPhoneNumber(PhoneNumber p) throws Exception {
        int number = p.getNumber();
        PhoneNumber p0 = this.phoneMap.get(number);
        Map<FullName, Employee> es = p.getEmployees();
        Map<FullName, Employee> es0 = p0.getEmployees();
        Assert.assertEquals((long)es0.size(), (long)es.size());
        this.checkEmpMap(es0, es);
    }

    public void checkPhoneMap(Map<String, PhoneNumber> es0, Map<String, PhoneNumber> es) throws Exception {
        Set<Map.Entry<String, PhoneNumber>> entrySets0 = es0.entrySet();
        for (Map.Entry entry : entrySets0) {
            PhoneNumber p;
            String key0 = (String)entry.getKey();
            PhoneNumber p0 = (PhoneNumber)entry.getValue();
            if (p0.equals(p = es.get(key0))) continue;
            throw new Exception("Assertion Failure");
        }
    }

    public void checkEmpMap(Map<FullName, Employee> es0, Map<FullName, Employee> es) throws Exception {
        Set<Map.Entry<FullName, Employee>> entrySets0 = es0.entrySet();
        for (Map.Entry entry : entrySets0) {
            Employee e;
            FullName key0 = (FullName)entry.getKey();
            Employee e0 = (Employee)entry.getValue();
            if (e0.equals(e = es.get(key0))) continue;
            throw new Exception("Assertion failure");
        }
    }
}

