/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.maps.m2mmapex0;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.QueryImpl;
import org.apache.openjpa.persistence.jdbc.maps.m2mmapex0.Division;
import org.apache.openjpa.persistence.jdbc.maps.m2mmapex0.Employee;
import org.apache.openjpa.persistence.jdbc.maps.m2mmapex0.PhoneNumber;
import org.apache.openjpa.persistence.test.AllowFailure;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;
import org.junit.Assert;

public class TestMany2ManyMap
extends SQLListenerTestCase {
    public int numEmployees = 2;
    public int numPhoneNumbersPerEmployee = 2;
    public Map<Integer, Employee> empMap = new HashMap<Integer, Employee>();
    public Map<Integer, PhoneNumber> phoneMap = new HashMap<Integer, PhoneNumber>();
    public int empId = 1;
    public int phoneId = 1;
    public int divId = 1;
    public List rsAllPhones = null;
    public List rsAllEmps = null;

    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES, Division.class, Employee.class, PhoneNumber.class);
        this.createObj();
        this.rsAllPhones = this.getAll(PhoneNumber.class);
        this.rsAllEmps = this.getAll(Employee.class);
    }

    @AllowFailure
    public void testQueryInMemoryQualifiedId() throws Exception {
        this.queryQualifiedId(true);
    }

    public void testQueryQualifiedId() throws Exception {
        this.queryQualifiedId(false);
    }

    public void setCandidate(Query q, Class clz) throws Exception {
        QueryImpl q1 = (QueryImpl)q;
        org.apache.openjpa.kernel.Query q2 = q1.getDelegate();
        org.apache.openjpa.kernel.QueryImpl qi = (org.apache.openjpa.kernel.QueryImpl)q2;
        if (clz == PhoneNumber.class) {
            qi.setCandidateCollection((Collection)this.rsAllPhones);
        } else if (clz == Employee.class) {
            qi.setCandidateCollection((Collection)this.rsAllEmps);
        }
    }

    public void queryQualifiedId(boolean inMemory) throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String query = "select VALUE(e).empId from PhoneNumber p,  in (p.emps) e order by p.number, e.empId";
        Query q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, PhoneNumber.class);
        }
        List rs = q.getResultList();
        query = "select KEY(e), KEY(e).name from PhoneNumber p,  in (p.emps) e order by p.number, e.empId";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, PhoneNumber.class);
        }
        rs = q.getResultList();
        Division d0 = (Division)((Object[])rs.get(0))[0];
        String name = (String)((Object[])rs.get(0))[1];
        TestMany2ManyMap.assertEquals((String)d0.getName(), (String)name);
        query = "select KEY(e) from PhoneNumber p,  in (p.emps) e order by p.number, e.empId";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, PhoneNumber.class);
        }
        rs = q.getResultList();
        Division d = (Division)rs.get(0);
        query = "select KEY(p) from Employee e,  in (e.phones) p order by p.number, e.empId";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Employee.class);
        }
        rs = q.getResultList();
        Division d2 = (Division)rs.get(0);
        query = "select VALUE(e) from PhoneNumber p,  in (p.emps) e order by p.number, e.empId";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, PhoneNumber.class);
        }
        rs = q.getResultList();
        Employee e = (Employee)rs.get(0);
        em.clear();
        query = "select ENTRY(e) from PhoneNumber p,  in (p.emps) e order by p.number, e.empId";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, PhoneNumber.class);
        }
        rs = q.getResultList();
        Map.Entry me = (Map.Entry)rs.get(0);
        TestMany2ManyMap.assertEquals((Object)d, me.getKey());
        query = "select TYPE(KEY(p)) from Employee e,  in (e.phones) p  order by p.number, e.empId";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Employee.class);
        }
        rs = q.getResultList();
        TestMany2ManyMap.assertEquals(Division.class, rs.get(0));
        query = "select KEY(p) from Employee e,  in (e.phones) p where KEY(p) = ?1";
        try {
            q = em.createQuery(query).setParameter(1, (Object)d2);
            if (inMemory) {
                this.setCandidate(q, Employee.class);
            }
            rs = q.getResultList();
        }
        catch (Exception ex) {
            this.assertException(ex, ArgumentException.class);
        }
        query = "select KEY(p) from Employee e,  in (e.phones) p WHERE VALUE(p) IS NULL";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Employee.class);
        }
        rs = q.getResultList();
        TestMany2ManyMap.assertEquals((int)0, (int)rs.size());
        query = "select CONCAT(KEY(p).name, 'xyz') from Employee e,  in (e.phones) p WHERE SUBSTRING(KEY(p).name, 1) like '%2'";
        q = em.createQuery(query);
        if (inMemory) {
            this.setCandidate(q, Employee.class);
        }
        rs = q.getResultList();
        TestMany2ManyMap.assertEquals((String)((String)rs.get(0)), (String)"d2xyz");
        em.close();
    }

    public void testQueryObject() throws Exception {
        this.queryObj();
        this.findObj();
    }

    public void createObj() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        for (int i = 0; i < this.numEmployees; ++i) {
            Employee e = this.createEmployee((EntityManager)em, this.empId++);
            this.empMap.put(e.getEmpId(), e);
        }
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public Employee createEmployee(EntityManager em, int id) {
        Employee e = new Employee();
        e.setEmpId(id);
        for (int i = 0; i < this.numPhoneNumbersPerEmployee; ++i) {
            PhoneNumber phoneNumber = new PhoneNumber();
            phoneNumber.setNumber(this.phoneId++);
            Division d1 = this.createDivision(em, this.divId++);
            Division d2 = this.createDivision(em, this.divId++);
            phoneNumber.addEmployees(d1, e);
            e.addPhoneNumber(d2, phoneNumber);
            em.persist((Object)phoneNumber);
            this.phoneMap.put(phoneNumber.getNumber(), phoneNumber);
            em.persist((Object)d1);
            em.persist((Object)d2);
        }
        em.persist((Object)e);
        return e;
    }

    public Division createDivision(EntityManager em, int id) {
        Division d = new Division();
        d.setId(id);
        d.setName("d" + id);
        return d;
    }

    public void findObj() throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Employee e = (Employee)em.find(Employee.class, (Object)1);
        this.assertEmployee(e);
        PhoneNumber p = (PhoneNumber)em.find(PhoneNumber.class, (Object)1);
        this.assertPhoneNumber(p);
        em.close();
    }

    public void queryObj() throws Exception {
        this.queryEmployee();
        this.queryPhoneNumber();
    }

    public void queryPhoneNumber() throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select p from PhoneNumber p");
        List ps = q.getResultList();
        for (PhoneNumber p : ps) {
            this.assertPhoneNumber(p);
        }
        tran.commit();
        em.close();
    }

    public void queryEmployee() throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select e from Employee e");
        List es = q.getResultList();
        for (Employee e : es) {
            this.assertEmployee(e);
        }
        tran.commit();
        em.close();
    }

    public void assertEmployee(Employee e) throws Exception {
        int id = e.getEmpId();
        Employee e0 = this.empMap.get(id);
        Map<Division, PhoneNumber> phones0 = e0.getPhoneNumbers();
        Map<Division, PhoneNumber> phones = e.getPhoneNumbers();
        Assert.assertEquals((long)phones0.size(), (long)phones.size());
        this.checkPhoneMap(phones0, phones);
    }

    public void assertPhoneNumber(PhoneNumber p) throws Exception {
        int number = p.getNumber();
        PhoneNumber p0 = this.phoneMap.get(number);
        Map<Division, Employee> es0 = p0.getEmployees();
        Map<Division, Employee> es = p.getEmployees();
        Assert.assertEquals((long)es0.size(), (long)es.size());
        this.checkEmpMap(es0, es);
    }

    public void checkPhoneMap(Map<Division, PhoneNumber> es0, Map<Division, PhoneNumber> es) throws Exception {
        Set<Map.Entry<Division, PhoneNumber>> entrySets0 = es0.entrySet();
        for (Map.Entry entry : entrySets0) {
            PhoneNumber p;
            Division d0 = (Division)entry.getKey();
            PhoneNumber p0 = (PhoneNumber)entry.getValue();
            if (p0.equals(p = es.get(d0))) continue;
            throw new Exception("Assertion failure");
        }
    }

    public void checkEmpMap(Map<Division, Employee> es0, Map<Division, Employee> es) throws Exception {
        Set<Map.Entry<Division, Employee>> entrySets0 = es0.entrySet();
        for (Map.Entry entry : entrySets0) {
            Employee e;
            Division d0 = (Division)entry.getKey();
            Employee e0 = (Employee)entry.getValue();
            if (e0.equals(e = es.get(d0))) continue;
            throw new Exception("Assertion failure");
        }
    }
}

