/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.mapping.bidi;

import javax.persistence.EntityManager;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.persistence.jdbc.mapping.bidi.Child;
import org.apache.openjpa.persistence.jdbc.mapping.bidi.IParent;
import org.apache.openjpa.persistence.jdbc.mapping.bidi.ParentWithAppIdentity;
import org.apache.openjpa.persistence.jdbc.mapping.bidi.ParentWithAutoIdentity;
import org.apache.openjpa.persistence.jdbc.mapping.bidi.ParentWithSequenceIdentity;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestOneSidedParentChildWithImplicitForeignKey
extends SingleEMFTestCase {
    private EntityManager em;
    private static Class[] PARENT_ID_TYPES = new Class[]{ParentWithAppIdentity.class, ParentWithSequenceIdentity.class, ParentWithAutoIdentity.class};
    private static int[] VALUE_STRATEGIES = new int[]{0, 2, 3};
    private static long[] PARENT_IDS = new long[PARENT_ID_TYPES.length];
    private static long PARENT_ID_COUNTER = System.currentTimeMillis();
    private static long CHILD_ID_COUNTER = System.currentTimeMillis();
    private static int CHILD_COUNT = 3;

    @Override
    public void setUp() {
        super.setUp(DROP_TABLES, ParentWithAppIdentity.class, ParentWithSequenceIdentity.class, ParentWithAutoIdentity.class, Child.class);
        this.em = this.emf.createEntityManager();
        this.createData(CHILD_COUNT);
    }

    public void xtestStrategies() {
        MetaDataRepository repos = this.emf.getConfiguration().getMetaDataRepositoryInstance();
        for (int i = 0; i < VALUE_STRATEGIES.length; ++i) {
            ClassMetaData meta = repos.getMetaData(PARENT_ID_TYPES[i], null, true);
            FieldMetaData fmd = meta.getPrimaryKeyFields()[0];
            TestOneSidedParentChildWithImplicitForeignKey.assertEquals((String)(fmd + " strategy is " + fmd.getValueStrategy()), (int)VALUE_STRATEGIES[i], (int)fmd.getValueStrategy());
        }
    }

    void createData(int nChild) {
        this.em.getTransaction().begin();
        Child[] children = new Child[CHILD_COUNT];
        for (int j = 0; j < CHILD_COUNT; ++j) {
            Child child = new Child();
            child.setId(CHILD_ID_COUNTER++);
            child.setName("Child" + j);
            children[j] = child;
        }
        for (int i = 0; i < PARENT_ID_TYPES.length; ++i) {
            IParent parent = this.newParent(i);
            if (VALUE_STRATEGIES[i] == 0) {
                parent.setId(++PARENT_ID_COUNTER);
            }
            for (int j = 0; j < CHILD_COUNT; ++j) {
                parent.addChild(children[j]);
            }
            this.em.persist((Object)parent);
            this.em.flush();
            TestOneSidedParentChildWithImplicitForeignKey.PARENT_IDS[i] = parent.getId();
        }
        this.em.getTransaction().commit();
    }

    public void testPersist() {
        this.em.getTransaction().begin();
        for (int i = 0; i < PARENT_ID_TYPES.length; ++i) {
            IParent parent = this.findParent(i);
            TestOneSidedParentChildWithImplicitForeignKey.assertFalse((parent.getId() == 0L ? 1 : 0) != 0);
            TestOneSidedParentChildWithImplicitForeignKey.assertFalse((boolean)parent.getChildren().isEmpty());
            TestOneSidedParentChildWithImplicitForeignKey.assertEquals((int)CHILD_COUNT, (int)parent.getChildren().size());
            for (Child child : parent.getChildren()) {
                TestOneSidedParentChildWithImplicitForeignKey.assertFalse((child.getParentIdType(VALUE_STRATEGIES[i]) == 0L ? 1 : 0) != 0);
                TestOneSidedParentChildWithImplicitForeignKey.assertTrue((child.getParentIdType(VALUE_STRATEGIES[i]) == parent.getId() ? 1 : 0) != 0);
            }
        }
        this.em.getTransaction().commit();
    }

    public void testUpdate() {
        IParent parent;
        int i;
        this.em.getTransaction().begin();
        Child newChild = new Child();
        newChild.setId(CHILD_ID_COUNTER++);
        newChild.setName("New Child");
        for (i = 0; i < PARENT_ID_TYPES.length; ++i) {
            parent = this.findParent(i);
            parent.addChild(newChild);
            this.em.merge((Object)parent);
        }
        this.em.flush();
        this.em.getTransaction().commit();
        this.em.clear();
        this.em.getTransaction().begin();
        for (i = 0; i < PARENT_ID_TYPES.length; ++i) {
            parent = this.findParent(i);
            TestOneSidedParentChildWithImplicitForeignKey.assertFalse((parent.getId() == 0L ? 1 : 0) != 0);
            TestOneSidedParentChildWithImplicitForeignKey.assertFalse((boolean)parent.getChildren().isEmpty());
            TestOneSidedParentChildWithImplicitForeignKey.assertEquals((int)(CHILD_COUNT + 1), (int)parent.getChildren().size());
            for (Child child : parent.getChildren()) {
                TestOneSidedParentChildWithImplicitForeignKey.assertFalse((child.getParentIdType(VALUE_STRATEGIES[i]) == 0L ? 1 : 0) != 0);
                TestOneSidedParentChildWithImplicitForeignKey.assertTrue((child.getParentIdType(VALUE_STRATEGIES[i]) == parent.getId() ? 1 : 0) != 0);
            }
        }
        this.em.getTransaction().commit();
    }

    @Override
    public void tearDown() throws Exception {
        this.closeEM(this.em);
        super.tearDown();
    }

    public IParent newParent(int parentType) {
        try {
            IParent parent = (IParent)PARENT_ID_TYPES[parentType].newInstance();
            if (VALUE_STRATEGIES[parentType] == 0) {
                parent.setId(++PARENT_ID_COUNTER);
            }
            parent.setName(PARENT_ID_TYPES[parentType].getSimpleName());
            return parent;
        }
        catch (Exception e) {
            TestOneSidedParentChildWithImplicitForeignKey.fail((String)e.toString());
            return null;
        }
    }

    public IParent findParent(int parentType) {
        return (IParent)this.em.find(PARENT_ID_TYPES[parentType], (Object)PARENT_IDS[parentType]);
    }
}

