/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.mapping.bidi;

import java.util.Set;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.mapping.bidi.Address;
import org.apache.openjpa.persistence.jdbc.mapping.bidi.Person;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestBiDirectionalJoinTable
extends SQLListenerTestCase {
    private static long SSN = 123456789L;
    private static String[] PHONES = new String[]{"+1-23-456", "+2-34-567", "+3-45-678"};
    private static int ADDRESS_COUNT = PHONES.length;
    private static String[] CITIS = new String[]{"Berlin", "Paris", "Rome"};
    private static int[] ZIPS = new int[]{123456, 234567, 345678};

    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES, Person.class, Address.class);
        this.createData(SSN);
        this.sql.clear();
    }

    public void testPersist() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Person person = (Person)em.find(Person.class, (Object)SSN);
        TestBiDirectionalJoinTable.assertNotNull((Object)person);
        TestBiDirectionalJoinTable.assertEquals((int)ADDRESS_COUNT, (int)person.getAddresses().size());
    }

    public void testQuery() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String jpql = "select distinct a.city from Person as p, in(p.addresses) a";
        Query query = em.createQuery(jpql);
        TestBiDirectionalJoinTable.assertEquals((int)ADDRESS_COUNT, (int)query.getResultList().size());
    }

    public void testUpdate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Person person = (Person)em.find(Person.class, (Object)SSN);
        Address newAddress = new Address();
        newAddress.setPhone("+4-56-789");
        newAddress.setCity("San Francisco");
        person.addAddress(newAddress);
        person.setName("Frank");
        em.merge((Object)person);
        em.getTransaction().commit();
        em = this.emf.createEntityManager();
        Person updated = (Person)em.find(Person.class, (Object)SSN);
        TestBiDirectionalJoinTable.assertEquals((String)"Frank", (String)updated.getName());
        TestBiDirectionalJoinTable.assertEquals((int)(ADDRESS_COUNT + 1), (int)updated.getAddresses().size());
    }

    public void testRemove() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Person person = (Person)em.find(Person.class, (Object)SSN);
        em.remove((Object)person);
        em.getTransaction().commit();
        TestBiDirectionalJoinTable.assertEquals((int)0, (int)this.count(Person.class));
        TestBiDirectionalJoinTable.assertEquals((int)0, (int)this.count(Address.class));
        this.assertSQL("DELETE FROM .*J_PERSON_ADDRESSES .*");
    }

    public void testSingleDelete() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        String jpql = "delete from Person p where p.ssn=:ssn";
        em.createQuery(jpql).setParameter("ssn", (Object)SSN).executeUpdate();
        em.getTransaction().commit();
        TestBiDirectionalJoinTable.assertEquals((int)0, (int)this.count(Person.class));
        TestBiDirectionalJoinTable.assertEquals((int)0, (int)this.count(Address.class));
        this.assertSQL("DELETE FROM .*J_PERSON_ADDRESSES .*");
    }

    public void testBulkDelete() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        String jpql = "delete from Person p";
        em.createQuery(jpql).executeUpdate();
        em.getTransaction().commit();
        TestBiDirectionalJoinTable.assertEquals((int)0, (int)this.count(Person.class));
        TestBiDirectionalJoinTable.assertEquals((int)0, (int)this.count(Address.class));
        this.assertSQL("DELETE FROM .*J_PERSON_ADDRESSES .*");
    }

    public void testBreakingRelationCausesDeleteFromJoinTable() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Person person = (Person)em.find(Person.class, (Object)SSN);
        em.getTransaction().begin();
        Set<Address> addresses = person.getAddresses();
        TestBiDirectionalJoinTable.assertFalse((boolean)addresses.isEmpty());
        Address address = addresses.iterator().next();
        addresses.remove(address);
        address.setPerson(null);
        em.getTransaction().commit();
        this.assertSQL("DELETE FROM .*J_PERSON_ADDRESSES .*");
    }

    void createData(long ssn) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        this.sql.clear();
        Person person = new Person();
        person.setSsn(SSN);
        person.setName("Pinaki");
        for (int i = 0; i < PHONES.length; ++i) {
            Address address = new Address();
            address.setPhone(PHONES[i]);
            address.setCity(CITIS[i]);
            address.setZip(ZIPS[i]);
            person.addAddress(address);
        }
        em.persist((Object)person);
        em.getTransaction().commit();
        TestBiDirectionalJoinTable.assertEquals((int)(1 + 2 * ADDRESS_COUNT), (int)this.sql.size());
    }
}

