/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.mapping;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.jdbc.common.apps.mappingApp.Entity1;
import org.apache.openjpa.persistence.jdbc.common.apps.mappingApp.Entity2;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestNativeQueries
extends SingleEMFTestCase {
    private static final String TABLE_NAME = "entity_1";
    private static final String TABLE_NAME_2 = "ENTITY2";
    private static final String CONST_NAME = "testSimple";
    private static final int CONST_INT = 42;
    private EntityManager em;

    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES, Entity1.class, Entity2.class);
        this.em = this.emf.createEntityManager();
        this.em.getTransaction().begin();
        this.em.persist((Object)new Entity1(1L, CONST_NAME, 42));
        this.em.persist((Object)new Entity1(2L, "testSimple Changed", 43));
        this.em.persist((Object)new Entity1(3L, "testSimple Changed 2", 44));
        this.em.getTransaction().commit();
        this.em.getTransaction().begin();
    }

    public void testNoParameter() {
        String sql = "SELECT * FROM entity_1";
        this.assertSize(3, this.em.createNativeQuery(sql, Entity1.class).getResultList());
    }

    public void testLiteral() {
        String sql = "SELECT * FROM entity_1 WHERE INTFIELD = 42";
        this.assertSize(1, this.em.createNativeQuery(sql, Entity1.class).getResultList());
    }

    public void testParameter() {
        String sql = "SELECT * FROM entity_1 WHERE INTFIELD = ?1";
        this.assertSize(1, this.em.createNativeQuery(sql, Entity1.class).setParameter(1, (Object)42).getResultList());
    }

    public void testOutOfOrderParameter() {
        String sql = "SELECT * FROM entity_1 WHERE INTFIELD = ?2 AND STRINGFIELD = ?1";
        this.assertSize(1, this.em.createNativeQuery(sql, Entity1.class).setParameter(2, (Object)42).setParameter(1, (Object)CONST_NAME).getResultList());
    }

    public void testDuplicateParameter() {
        String sql = "SELECT * FROM entity_1 WHERE INTFIELD = ?1 AND INTFIELD = ?1";
        this.assertSize(1, this.em.createNativeQuery(sql, Entity1.class).setParameter(1, (Object)42).getResultList());
    }

    public void testDifferentParameterToSameField() {
        String sql = "SELECT * FROM entity_1 WHERE INTFIELD = ?1 OR INTFIELD = ?2";
        this.assertSize(2, this.em.createNativeQuery(sql, Entity1.class).setParameter(1, (Object)42).setParameter(2, (Object)43).getResultList());
    }

    public void testQuoteParameterIgnored() {
        String sql = "SELECT * FROM entity_1 WHERE INTFIELD = ?1 OR STRINGFIELD = '?2'";
        this.assertSize(1, this.em.createNativeQuery(sql, Entity1.class).setParameter(1, (Object)42).getResultList());
    }

    public void testParameterMarkerWithoutSpaces() {
        String sql = "SELECT * FROM entity_1 WHERE INTFIELD=?1";
        this.assertSize(1, this.em.createNativeQuery(sql, Entity1.class).setParameter(1, (Object)42).getResultList());
    }

    public void testZeroBasedParameterSettingFails() {
        try {
            String sql = "SELECT * FROM entity_1 WHERE INTFIELD = ?1";
            this.em.createNativeQuery(sql, Entity1.class).setParameter(0, (Object)12);
            TestNativeQueries.fail((String)"Expected to fail with 0 parameter index");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testNamedParameterFails() {
        String sql = "SELECT * FROM entity_1 WHERE INTFIELD = :p";
        try {
            this.em.createNativeQuery(sql, Entity1.class).setParameter("p", (Object)12);
            TestNativeQueries.fail((String)"Expected to fail with NAMED parameter");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testHintsAreProcessed() {
        Query q = this.em.createNamedQuery("SQLWithHints");
        TestNativeQueries.assertEquals((String)"openjpa.SQL", (String)OpenJPAPersistence.cast((Query)q).getLanguage());
        String hintKey = "XYZ";
        TestNativeQueries.assertTrue((boolean)q.getHints().containsKey(hintKey));
        TestNativeQueries.assertEquals((Object)"abc", q.getHints().get(hintKey));
    }

    public void testNullResult() {
        String sql = "SELECT max(pk) FROM ENTITY2";
        TestNativeQueries.assertNull((Object)this.em.createNativeQuery(sql, Long.class).getSingleResult());
    }

    public void assertSize(int num, List l) {
        TestNativeQueries.assertNotNull((Object)l);
        TestNativeQueries.assertEquals((int)num, (int)l.size());
    }
}

