/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.mapping;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.jdbc.common.apps.mappingApp.EntityWithCompositeId;
import org.apache.openjpa.persistence.jdbc.common.apps.mappingApp.OwnerOfEntityWithCompositeId;
import org.apache.openjpa.persistence.jdbc.common.apps.mappingApp.RecursiveEntityWithCompositeId;

public class TestCompositeIdTraversalInSQLMapping
extends AbstractTestCase {
    public TestCompositeIdTraversalInSQLMapping(String name) {
        super(name, "jdbccactusapp");
    }

    public void setUp() {
        this.deleteAll(OwnerOfEntityWithCompositeId.class);
        this.deleteAll(EntityWithCompositeId.class);
    }

    private void persist(Integer uniqueId, String uniqueName, String relName) {
        OwnerOfEntityWithCompositeId owner = new OwnerOfEntityWithCompositeId();
        EntityWithCompositeId relative = new EntityWithCompositeId();
        owner.setName(uniqueName);
        relative.setId(uniqueId);
        relative.setName(relName);
        relative.setValue("foo");
        owner.setRelation(relative);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persist((Object)owner);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testTraversalWhenSQLSelectsBothEndOfTheRelation() {
        OpenJPAEntityManager em = this.currentEntityManager();
        Integer uid = (int)(System.currentTimeMillis() % 100000L);
        String uName = "P" + uid;
        String rName = "R" + uName;
        this.persist(uid, uName, rName);
        String sql = "SELECT a.NAME as OWNER_NAME, a.RELATION_ID as REL_ID,a.RELATION_NAME as REL_NAME, b.ID as C_ID,b.NAME as C_NAME, b.VALUE as C_VALUE FROM OWNER_OF_COMPOSITE_ID a, COMPOSITE_ID b WHERE a.RELATION_ID=b.ID AND a.RELATION_NAME=b.NAME AND a.NAME='" + uName + "'";
        Query query = em.createNativeQuery(sql, "SQLSelectsBothEndOfTheRelation");
        List result = query.getResultList();
        TestCompositeIdTraversalInSQLMapping.assertEquals((int)1, (int)result.size());
        Object object = result.get(0);
        TestCompositeIdTraversalInSQLMapping.assertEquals(Object[].class, object.getClass());
        Object[] array = (Object[])object;
        TestCompositeIdTraversalInSQLMapping.assertEquals((int)2, (int)array.length);
        TestCompositeIdTraversalInSQLMapping.assertEquals(OwnerOfEntityWithCompositeId.class, array[0].getClass());
        TestCompositeIdTraversalInSQLMapping.assertEquals(EntityWithCompositeId.class, array[1].getClass());
        OwnerOfEntityWithCompositeId owner = (OwnerOfEntityWithCompositeId)array[0];
        EntityWithCompositeId relative = (EntityWithCompositeId)array[1];
        TestCompositeIdTraversalInSQLMapping.assertEquals((String)uName, (String)owner.getName());
        TestCompositeIdTraversalInSQLMapping.assertEquals((Object)owner.getRelation(), (Object)relative);
        TestCompositeIdTraversalInSQLMapping.assertEquals((Object)relative.getId(), (Object)uid);
        TestCompositeIdTraversalInSQLMapping.assertEquals((String)relative.getName(), (String)rName);
        TestCompositeIdTraversalInSQLMapping.assertEquals((String)"foo", (String)relative.getValue());
        this.endEm((EntityManager)em);
    }

    public void testTraversalWhenSQLSelectsOnlyOneEndOfTheRelation() {
        OpenJPAEntityManager em = this.currentEntityManager();
        Integer uid = (int)(System.currentTimeMillis() % 100000L);
        String uName = "P" + uid;
        String rName = "R" + uName;
        this.persist(uid, uName, rName);
        String sql = "SELECT a.NAME as OWNER_NAME, a.RELATION_ID as REL_ID,a.RELATION_NAME as REL_NAME FROM OWNER_OF_COMPOSITE_ID a WHERE  a.NAME='" + uName + "'";
        Query query = em.createNativeQuery(sql, "SQLSelectsOnlyOneEndOfTheRelation");
        List result = query.getResultList();
        TestCompositeIdTraversalInSQLMapping.assertEquals((int)1, (int)result.size());
        Object object = result.get(0);
        TestCompositeIdTraversalInSQLMapping.assertEquals(OwnerOfEntityWithCompositeId.class, object.getClass());
        OwnerOfEntityWithCompositeId owner = (OwnerOfEntityWithCompositeId)object;
        EntityWithCompositeId relative = owner.getRelation();
        TestCompositeIdTraversalInSQLMapping.assertEquals((String)uName, (String)owner.getName());
        TestCompositeIdTraversalInSQLMapping.assertEquals((Object)relative.getId(), (Object)uid);
        TestCompositeIdTraversalInSQLMapping.assertEquals((String)relative.getName(), (String)rName);
        TestCompositeIdTraversalInSQLMapping.assertEquals((String)"foo", (String)relative.getValue());
        this.endEm((EntityManager)em);
    }

    public void testTraversalWhenSQLSelectsUnrelatedInstances() {
        OpenJPAEntityManager em = this.currentEntityManager();
        Integer uid1 = (int)(System.currentTimeMillis() % 100000L);
        Integer uid2 = uid1 + 1;
        String uName1 = "P" + uid1;
        String rName1 = "R" + uName1;
        String uName2 = "P" + uid2;
        String rName2 = "R" + uName2;
        this.persist(uid1, uName1, rName1);
        this.persist(uid2, uName2, rName2);
        String sql = "SELECT a.NAME as OWNER_NAME, a.RELATION_ID AS REL_ID,a.RELATION_NAME AS REL_NAME, b.ID AS C_ID, b.NAME AS C_NAME, b.VALUE AS C_VALUE FROM OWNER_OF_COMPOSITE_ID a, COMPOSITE_ID b WHERE b.NAME='" + rName2 + "' AND a.NAME='" + uName1 + "'";
        Query query = em.createNativeQuery(sql, "SQLSelectsUnrelatedInstances");
        List result = query.getResultList();
        TestCompositeIdTraversalInSQLMapping.assertEquals((int)1, (int)result.size());
        Object object = result.get(0);
        TestCompositeIdTraversalInSQLMapping.assertEquals(Object[].class, object.getClass());
        Object[] array = (Object[])object;
        TestCompositeIdTraversalInSQLMapping.assertEquals((int)2, (int)array.length);
        TestCompositeIdTraversalInSQLMapping.assertEquals(OwnerOfEntityWithCompositeId.class, array[0].getClass());
        TestCompositeIdTraversalInSQLMapping.assertEquals(EntityWithCompositeId.class, array[1].getClass());
        OwnerOfEntityWithCompositeId owner1 = (OwnerOfEntityWithCompositeId)array[0];
        EntityWithCompositeId relative1 = owner1.getRelation();
        EntityWithCompositeId relative2 = (EntityWithCompositeId)array[1];
        TestCompositeIdTraversalInSQLMapping.assertEquals((String)uName1, (String)owner1.getName());
        TestCompositeIdTraversalInSQLMapping.assertEquals((Object)uid1, (Object)relative1.getId());
        TestCompositeIdTraversalInSQLMapping.assertEquals((String)rName1, (String)relative1.getName());
        TestCompositeIdTraversalInSQLMapping.assertEquals((Object)uid2, (Object)relative2.getId());
        TestCompositeIdTraversalInSQLMapping.assertEquals((String)rName2, (String)relative2.getName());
        this.endEm((EntityManager)em);
    }

    public void testRecursiveTraversal() {
        Integer rootId = (int)(System.currentTimeMillis() % 100000L);
        int depth = 3;
        this.persistChainedRelative(rootId, depth);
        String sql = this.createSelfJoinSQL("RECURSIVE_ENTITY", depth, rootId);
        OpenJPAEntityManager em = this.currentEntityManager();
        Query query = em.createNativeQuery(sql, "SQLSelectsChainedRelation");
        List result = query.getResultList();
        TestCompositeIdTraversalInSQLMapping.assertEquals((int)1, (int)result.size());
        TestCompositeIdTraversalInSQLMapping.assertEquals(RecursiveEntityWithCompositeId.class, result.get(0).getClass());
        RecursiveEntityWithCompositeId root = (RecursiveEntityWithCompositeId)result.get(0);
        TestCompositeIdTraversalInSQLMapping.assertEquals((Object)rootId, (Object)root.getId());
        TestCompositeIdTraversalInSQLMapping.assertEquals((String)("P" + rootId), (String)root.getName());
        for (int i = 1; i < depth; ++i) {
            RecursiveEntityWithCompositeId relative = root.getRelation();
            Integer expecetedId = root.getId() + 1;
            TestCompositeIdTraversalInSQLMapping.assertEquals((Object)expecetedId, (Object)relative.getId());
            TestCompositeIdTraversalInSQLMapping.assertEquals((String)("P" + expecetedId), (String)relative.getName());
            root = relative;
        }
    }

    void persistChainedRelative(Integer rootId, int depth) {
        RecursiveEntityWithCompositeId root = new RecursiveEntityWithCompositeId();
        root.setId(rootId);
        root.setName("P" + rootId);
        RecursiveEntityWithCompositeId head = root;
        for (int i = 1; i <= depth; ++i) {
            RecursiveEntityWithCompositeId relation = new RecursiveEntityWithCompositeId();
            relation.setId(rootId + i);
            relation.setName("P" + (rootId + i));
            head.setRelation(relation);
            head = relation;
        }
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persist((Object)root);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    String createSelfJoinSQL(String table, int depth, int id) {
        int i;
        StringBuilder sql = new StringBuilder("SELECT ");
        for (i = 0; i < depth; ++i) {
            sql.append("t" + i + ".ID AS T" + i + "_ID, ").append("t" + i + ".NAME AS T" + i + "_NAME, ").append("t" + i + ".RELATION_ID AS T" + i + "_REL_ID, ").append("t" + i + ".RELATION_NAME AS T" + i + "_REL_NAME").append(i == depth - 1 ? " " : ", ");
        }
        sql.append(" FROM ");
        for (i = 0; i < depth; ++i) {
            sql.append(table + " t" + i).append(i == depth - 1 ? " " : ", ");
        }
        sql.append(" WHERE ");
        for (i = 0; i < depth - 1; ++i) {
            sql.append("t" + i + ".RELATION_ID=t" + (i + 1) + ".ID AND ").append("t" + i + ".RELATION_NAME=t" + (i + 1) + ".NAME AND ");
        }
        sql.append("t0.ID=" + id);
        return sql.toString();
    }
}

