/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.kernel;

import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.sqlcache.Address;
import org.apache.openjpa.persistence.jdbc.sqlcache.Person;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestUpdateWithSubSelect
extends SQLListenerTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp(CLEAR_TABLES, Person.class, Address.class);
        DBDictionary dict = ((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance();
        this.setTestsDisabled(!dict.supportsSubselect || !dict.allowsAliasInBulkClause);
        this.getLog().trace((Object)((Object)((Object)this) + " is disabled because " + dict.getClass().getSimpleName() + " either both or one of supportsSubselect and allowsAliasInBulkClause is false"));
    }

    public void testUpdateBySubSelect() {
        String jpql = "UPDATE Person p SET p.age = :age WHERE p.address.city = :city";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        this.sql.clear();
        em.createQuery(jpql).setParameter("age", (Object)25).setParameter("city", (Object)"SFO").executeUpdate();
        em.getTransaction().commit();
        TestUpdateWithSubSelect.assertEquals((int)1, (int)this.sql.size());
        String sqlString = ((String)this.sql.get(0)).toUpperCase().trim();
        TestUpdateWithSubSelect.assertTrue((boolean)sqlString.startsWith("UPDATE"));
        TestUpdateWithSubSelect.assertTrue((sqlString.indexOf("T0.ADDRESS_ID = T1.ID") != -1 ? 1 : 0) != 0);
    }
}

