/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.kernel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.persistence.Extent;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.jdbc.common.apps.PagingAppIdPC;
import org.apache.openjpa.persistence.jdbc.common.apps.PagingHelperPC;
import org.apache.openjpa.persistence.jdbc.common.apps.PagingPC;
import org.apache.openjpa.persistence.jdbc.kernel.TestSQLListenerTestCase;

public class TestPagingResultObjectProvider
extends TestSQLListenerTestCase {
    private OpenJPAEntityManagerFactory emf;

    public TestPagingResultObjectProvider(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.emf = this.getEmf(this.getProps());
        OpenJPAEntityManager em = this.currentEntityManager();
    }

    public boolean skipTest() {
        JDBCConfiguration conf = (JDBCConfiguration)((OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.cast((EntityManagerFactory)this.emf)).getConfiguration();
        DBDictionary dict = conf.getDBDictionaryInstance();
        if (dict.joinSyntax == 1) {
            return true;
        }
        return ("testPagingRangeQuery".equals(this.getName()) || "testNonPagingRangeQuery".equals(this.getName())) && !conf.getDBDictionaryInstance().supportsSubselect;
    }

    public void testNonPagingExtent() {
        this.initializePagingPCs();
        OpenJPAEntityManager em = this.currentEntityManager();
        OpenJPAEntityManager kem = OpenJPAPersistence.cast((EntityManager)em);
        Extent extent = kem.createExtent(PagingPC.class, true);
        extent.getFetchPlan().setFetchBatchSize(0);
        extent.getFetchPlan().addFetchGroup("rel");
        List list = extent.list();
        TestPagingResultObjectProvider.assertEquals((int)4, (int)list.size());
        this.assertRel(list, 4);
        TestPagingResultObjectProvider.assertEquals((String)sql.toString(), (int)1, (int)sql.size());
        sql.clear();
        this.assertRels(list, 4);
        TestPagingResultObjectProvider.assertEquals((String)sql.toString(), (int)4, (int)sql.size());
        sql.clear();
        em.close();
    }

    public void testNonPagingQuery() throws Exception {
        this.initializePagingPCs();
        OpenJPAEntityManager em = this.currentEntityManager();
        OpenJPAEntityManager kem = OpenJPAPersistence.cast((EntityManager)em);
        String theQuery = "select a FROM " + PagingPC.class.getSimpleName() + " a where a.intField >= 0";
        OpenJPAQuery q = kem.createQuery(theQuery);
        q.getFetchPlan().setFetchBatchSize(0);
        q.getFetchPlan().addFetchGroups(new String[]{"rel"});
        List list = q.getResultList();
        TestPagingResultObjectProvider.assertEquals((int)4, (int)list.size());
        this.assertRel(list, 4);
        TestPagingResultObjectProvider.assertEquals((String)sql.toString(), (int)2, (int)sql.size());
        TestPagingResultObjectProvider.assertTrue((String)((String)sql.get(0)), (boolean)TestPagingResultObjectProvider.matches(" >= ", (String)sql.get(0)));
        TestPagingResultObjectProvider.assertTrue((String)((String)sql.get(1)), (boolean)TestPagingResultObjectProvider.matches(" COUNT", (String)sql.get(1)));
        sql.clear();
        this.assertRels(list, 4);
        TestPagingResultObjectProvider.assertEquals((String)sql.toString(), (int)4, (int)sql.size());
        sql.clear();
        em.close();
    }

    private void assertRel(List pcs, int size) {
        for (int i = 0; i < size; ++i) {
            PagingPC pc = (PagingPC)pcs.get(i);
            TestPagingResultObjectProvider.assertNotNull((Object)pc.getRel());
            TestPagingResultObjectProvider.assertEquals((int)(pc.getIntField() + 1), (int)pc.getRel().getIntField());
        }
        try {
            pcs.get(size + 1);
            TestPagingResultObjectProvider.fail((String)"Retrieved past end of list");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void assertRels(List pcs, int size) {
        for (int i = 0; i < size; ++i) {
            PagingPC pc = (PagingPC)pcs.get(i);
            TestPagingResultObjectProvider.assertEquals((int)2, (int)pc.getRels().size());
            TestPagingResultObjectProvider.assertEquals((int)(pc.getIntField() + 1), (int)((PagingHelperPC)pc.getRels().get(0)).getIntField());
            TestPagingResultObjectProvider.assertEquals((int)(pc.getIntField() + 2), (int)((PagingHelperPC)pc.getRels().get(1)).getIntField());
        }
        try {
            pcs.get(size + 1);
            TestPagingResultObjectProvider.fail((String)"Retrieved past end of list");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testPagingExtent() throws Exception {
        this.initializePagingPCs();
        OpenJPAEntityManager em = this.currentEntityManager();
        OpenJPAEntityManager kem = OpenJPAPersistence.cast((EntityManager)em);
        Extent extent = kem.createExtent(PagingPC.class, true);
        extent.getFetchPlan().setFetchBatchSize(0);
        extent.getFetchPlan().addFetchGroup("rel");
        extent.getFetchPlan().addFetchGroup("rels");
        List list = extent.list();
        TestPagingResultObjectProvider.assertEquals((int)4, (int)list.size());
        this.assertRel(list, 4);
        this.assertRels(list, 4);
        TestPagingResultObjectProvider.assertEquals((String)sql.toString(), (int)2, (int)sql.size());
        TestPagingResultObjectProvider.assertTrue((String)((String)sql.get(1)), (boolean)TestPagingResultObjectProvider.matches(" IN ", (String)sql.get(1)));
        sql.clear();
        em.close();
    }

    public void testPagingQuery() throws Exception {
        this.initializePagingPCs();
        OpenJPAEntityManager em = this.currentEntityManager();
        OpenJPAEntityManager kem = OpenJPAPersistence.cast((EntityManager)em);
        String theQuery = "select a FROM " + PagingPC.class.getSimpleName() + " a where a.intField >= 0";
        OpenJPAQuery q = kem.createQuery(theQuery);
        q.getFetchPlan().setFetchBatchSize(0);
        q.getFetchPlan().addFetchGroups(new String[]{"rel"});
        q.getFetchPlan().addFetchGroups(new String[]{"rels"});
        List list = q.getResultList();
        TestPagingResultObjectProvider.assertEquals((int)4, (int)list.size());
        this.assertRel(list, 4);
        this.assertRels(list, 4);
        TestPagingResultObjectProvider.assertEquals((String)sql.toString(), (int)3, (int)sql.size());
        TestPagingResultObjectProvider.assertTrue((String)((String)sql.get(0)), (boolean)TestPagingResultObjectProvider.matches(" >= ", (String)sql.get(0)));
        TestPagingResultObjectProvider.assertTrue((String)((String)sql.get(1)), (boolean)TestPagingResultObjectProvider.matches(" COUNT", (String)sql.get(1)));
        TestPagingResultObjectProvider.assertTrue((String)((String)sql.get(2)), (boolean)TestPagingResultObjectProvider.matches(" IN ", (String)sql.get(2)));
        TestPagingResultObjectProvider.assertFalse((String)((String)sql.get(2)), (boolean)TestPagingResultObjectProvider.matches(" >= ", (String)sql.get(2)));
        sql.clear();
        list = q.getResultList();
        list.get(0);
        TestPagingResultObjectProvider.assertEquals((int)4, (int)list.size());
        this.assertRel(list, 4);
        this.assertRels(list, 4);
        TestPagingResultObjectProvider.assertEquals((String)sql.toString(), (int)2, (int)sql.size());
        TestPagingResultObjectProvider.assertTrue((String)((String)sql.get(1)), (boolean)TestPagingResultObjectProvider.matches(" IN ", (String)sql.get(1)));
        sql.clear();
        em.close();
    }

    public void testPagingAppIdExtent() throws Exception {
        this.initializePagingAppIdPCs();
        OpenJPAEntityManager em = this.currentEntityManager();
        OpenJPAEntityManager kem = OpenJPAPersistence.cast((EntityManager)em);
        Extent extent = kem.createExtent(PagingAppIdPC.class, true);
        extent.getFetchPlan().setFetchBatchSize(0);
        extent.getFetchPlan().addFetchGroup("rel");
        extent.getFetchPlan().addFetchGroup("rels");
        List list = extent.list();
        TestPagingResultObjectProvider.assertEquals((int)4, (int)list.size());
        this.assertAppIdRel(list, 4);
        this.assertAppIdRels(list, 4);
        TestPagingResultObjectProvider.assertEquals((String)sql.toString(), (int)2, (int)sql.size());
        TestPagingResultObjectProvider.assertTrue((String)((String)sql.get(1)), (boolean)TestPagingResultObjectProvider.matches(" OR ", (String)sql.get(1)));
        sql.clear();
        em.close();
    }

    public void testPagingAppIdQuery() throws Exception {
        this.initializePagingAppIdPCs();
        OpenJPAEntityManager em = this.currentEntityManager();
        OpenJPAEntityManager kem = OpenJPAPersistence.cast((EntityManager)em);
        String theQuery = "select a FROM " + PagingAppIdPC.class.getSimpleName() + " a where a.intField >= 0";
        OpenJPAQuery q = kem.createQuery(theQuery);
        q.getFetchPlan().setFetchBatchSize(0);
        q.getFetchPlan().addFetchGroups(new String[]{"rel"});
        q.getFetchPlan().addFetchGroups(new String[]{"rels"});
        List list = q.getResultList();
        TestPagingResultObjectProvider.assertEquals((int)4, (int)list.size());
        this.assertAppIdRel(list, 4);
        this.assertAppIdRels(list, 4);
        TestPagingResultObjectProvider.assertEquals((String)sql.toString(), (int)3, (int)sql.size());
        TestPagingResultObjectProvider.assertTrue((String)((String)sql.get(0)), (boolean)TestPagingResultObjectProvider.matches(" >= ", (String)sql.get(0)));
        TestPagingResultObjectProvider.assertTrue((String)((String)sql.get(1)), (boolean)TestPagingResultObjectProvider.matches(" COUNT", (String)sql.get(1)));
        TestPagingResultObjectProvider.assertTrue((String)((String)sql.get(2)), (boolean)TestPagingResultObjectProvider.matches(" OR ", (String)sql.get(2)));
        TestPagingResultObjectProvider.assertFalse((String)((String)sql.get(2)), (boolean)TestPagingResultObjectProvider.matches(" >= ", (String)sql.get(2)));
        sql.clear();
        em.close();
    }

    private void assertAppIdRel(List pcs, int size) {
        for (int i = 0; i < size; ++i) {
            PagingAppIdPC pc = (PagingAppIdPC)pcs.get(i);
            TestPagingResultObjectProvider.assertNotNull((Object)pc.getRel());
            TestPagingResultObjectProvider.assertEquals((int)(pc.getIntField() + 1), (int)pc.getRel().getIntField());
        }
        try {
            pcs.get(size + 1);
            TestPagingResultObjectProvider.fail((String)"Retrieved past end of list");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void assertAppIdRels(List pcs, int size) {
        for (int i = 0; i < size; ++i) {
            PagingAppIdPC pc = (PagingAppIdPC)pcs.get(i);
            TestPagingResultObjectProvider.assertEquals((int)2, (int)pc.getRels().size());
            TestPagingResultObjectProvider.assertEquals((int)(pc.getIntField() + 1), (int)((PagingHelperPC)pc.getRels().get(0)).getIntField());
            TestPagingResultObjectProvider.assertEquals((int)(pc.getIntField() + 2), (int)((PagingHelperPC)pc.getRels().get(1)).getIntField());
        }
        try {
            pcs.get(size + 1);
            TestPagingResultObjectProvider.fail((String)"Retrieved past end of list");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMultiPageExtent() throws Exception {
        this.initializePagingPCs();
        OpenJPAEntityManager em = this.currentEntityManager();
        OpenJPAEntityManager kem = OpenJPAPersistence.cast((EntityManager)em);
        Extent extent = kem.createExtent(PagingPC.class, true);
        extent.getFetchPlan().setFetchBatchSize(2);
        extent.getFetchPlan().addFetchGroup("rel");
        extent.getFetchPlan().addFetchGroup("rels");
        List list = extent.list();
        TestPagingResultObjectProvider.assertEquals((String)list.toString(), (int)4, (int)list.size());
        this.assertRel(list, 4);
        this.assertRels(list, 4);
        TestPagingResultObjectProvider.assertEquals((String)sql.toString(), (int)3, (int)sql.size());
        TestPagingResultObjectProvider.assertTrue((String)((String)sql.get(1)), (boolean)TestPagingResultObjectProvider.matches(" IN ", (String)sql.get(1)));
        TestPagingResultObjectProvider.assertTrue((String)((String)sql.get(2)), (boolean)TestPagingResultObjectProvider.matches(" IN ", (String)sql.get(2)));
        sql.clear();
        em.close();
    }

    public void testMultiPageQuery() throws Exception {
        this.initializePagingPCs();
        OpenJPAEntityManager em = this.currentEntityManager();
        OpenJPAEntityManager kem = OpenJPAPersistence.cast((EntityManager)em);
        String theQuery = "select a FROM " + PagingPC.class.getSimpleName() + " a where a.intField >= 0";
        OpenJPAQuery q = kem.createQuery(theQuery);
        q.getFetchPlan().setFetchBatchSize(2);
        q.getFetchPlan().addFetchGroup("rel");
        q.getFetchPlan().addFetchGroup("rels");
        List list = q.getResultList();
        TestPagingResultObjectProvider.assertEquals((String)list.toString(), (int)4, (int)list.size());
        list = new ArrayList(list);
        this.assertRel(list, 4);
        this.assertRels(list, 4);
        TestPagingResultObjectProvider.assertEquals((String)sql.toString(), (int)4, (int)sql.size());
        TestPagingResultObjectProvider.assertTrue((String)((String)sql.get(1)), (boolean)TestPagingResultObjectProvider.matches(" COUNT", (String)sql.get(1)));
        TestPagingResultObjectProvider.assertTrue((String)((String)sql.get(2)), (boolean)TestPagingResultObjectProvider.matches(" IN ", (String)sql.get(2)));
        TestPagingResultObjectProvider.assertTrue((String)((String)sql.get(3)), (boolean)TestPagingResultObjectProvider.matches(" IN ", (String)sql.get(3)));
        sql.clear();
        list = q.getResultList();
        TestPagingResultObjectProvider.assertEquals((String)list.toString(), (int)4, (int)list.size());
        PagingPC pc = (PagingPC)list.get(2);
        TestPagingResultObjectProvider.assertEquals((int)2, (int)pc.getIntField());
        TestPagingResultObjectProvider.assertEquals((String)sql.toString(), (int)3, (int)sql.size());
        TestPagingResultObjectProvider.assertTrue((String)((String)sql.get(2)), (boolean)TestPagingResultObjectProvider.matches(" IN", (String)sql.get(2)));
        this.assertRel(list, 4);
        this.assertRels(list, 4);
        sql.clear();
        em.close();
    }

    public void testLastPageQuery() throws Exception {
        this.initializePagingPCs();
        OpenJPAEntityManager em = this.currentEntityManager();
        OpenJPAEntityManager kem = OpenJPAPersistence.cast((EntityManager)em);
        String theQuery = "select a FROM " + PagingPC.class.getSimpleName() + " a where a.intField >= 0";
        OpenJPAQuery q = kem.createQuery(theQuery);
        q.getFetchPlan().setFetchBatchSize(3);
        q.getFetchPlan().addFetchGroups(new String[]{"rel"});
        q.getFetchPlan().addFetchGroups(new String[]{"rels"});
        List list = q.getResultList();
        PagingPC pc = (PagingPC)list.get(3);
        TestPagingResultObjectProvider.assertEquals((int)3, (int)pc.getIntField());
        TestPagingResultObjectProvider.assertEquals((String)list.toString(), (int)4, (int)list.size());
        TestPagingResultObjectProvider.assertEquals((String)sql.toString(), (int)2, (int)sql.size());
        TestPagingResultObjectProvider.assertFalse((String)((String)sql.get(1)), (boolean)TestPagingResultObjectProvider.matches(" IN ", (String)sql.get(1)));
        sql.clear();
        em.close();
    }

    public void testSingleResultPage() throws Exception {
        this.initializePagingPCs();
        OpenJPAEntityManager em = this.currentEntityManager();
        OpenJPAEntityManager kem = OpenJPAPersistence.cast((EntityManager)em);
        Extent extent = kem.createExtent(PagingPC.class, true);
        extent.getFetchPlan().setFetchBatchSize(3);
        extent.getFetchPlan().addFetchGroup("rel");
        extent.getFetchPlan().addFetchGroup("rels");
        List list = extent.list();
        TestPagingResultObjectProvider.assertEquals((String)list.toString(), (int)4, (int)list.size());
        this.assertRel(list, 4);
        this.assertRels(list, 4);
        TestPagingResultObjectProvider.assertEquals((String)sql.toString(), (int)3, (int)sql.size());
        TestPagingResultObjectProvider.assertTrue((String)((String)sql.get(1)), (boolean)TestPagingResultObjectProvider.matches(" IN ", (String)sql.get(1)));
        TestPagingResultObjectProvider.assertFalse((String)((String)sql.get(2)), (boolean)TestPagingResultObjectProvider.matches(" IN ", (String)sql.get(2)));
        sql.clear();
        em.close();
    }

    private void initializePagingPCs() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        this.deleteAll(PagingPC.class, (EntityManager)em);
        this.deleteAll(PagingHelperPC.class, (EntityManager)em);
        this.endTx((EntityManager)em);
        this.startTx((EntityManager)em);
        for (int i = 0; i < 4; ++i) {
            PagingPC pc = new PagingPC();
            pc.setIntField(i);
            PagingHelperPC rel = new PagingHelperPC();
            rel.setIntField(i + 1);
            pc.setRel(rel);
            pc.getRels().add(rel);
            rel = new PagingHelperPC();
            rel.setIntField(i + 2);
            pc.getRels().add(rel);
            em.persist((Object)pc);
        }
        this.endTx((EntityManager)em);
        em.close();
        sql.clear();
    }

    private void initializePagingAppIdPCs() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        this.deleteAll(PagingAppIdPC.class, (EntityManager)em);
        this.deleteAll(PagingHelperPC.class, (EntityManager)em);
        this.startTx((EntityManager)em);
        this.startTx((EntityManager)em);
        for (int i = 0; i < 4; ++i) {
            PagingAppIdPC pc = new PagingAppIdPC();
            pc.setIntField(i);
            pc.setLongField(i + 100);
            PagingHelperPC rel = new PagingHelperPC();
            rel.setIntField(i + 1);
            pc.setRel(rel);
            pc.getRels().add(rel);
            rel = new PagingHelperPC();
            rel.setIntField(i + 2);
            pc.getRels().add(rel);
            em.persist((Object)pc);
        }
        this.endTx((EntityManager)em);
        em.close();
        sql.clear();
    }

    private Map getProps() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("openjpa.DataCache", "true");
        props.put("openjpa.RemoteCommitProvider", "sjvm");
        props.put("openjpa.FlushBeforeQueries", "true");
        props.put("javax.jdo.option.IgnoreCache", "false");
        return props;
    }
}

