/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.kernel;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.kernel.DelegatingStoreManager;
import org.apache.openjpa.kernel.StoreManager;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.jdbc.common.apps.RuntimeTest1;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;

public class TestIncrementalJDBCFlushes
extends BaseJDBCTest {
    private EntityManagerFactory emf;

    public TestIncrementalJDBCFlushes(String str) {
        super(str);
    }

    public void setUp() {
        this.emf = this.getEmf(this.getProps());
        EntityManager em = this.emf.createEntityManager();
        this.deleteAll(RuntimeTest1.class, em);
    }

    public void testFlushHappened() throws SQLException {
        EntityManager em = this.emf.createEntityManager();
        this.startTx(em);
        RuntimeTest1 a = new RuntimeTest1("a-name", 10);
        em.persist((Object)a);
        em.flush();
        JDBCStore store = (JDBCStore)this.getStoreManager(em, true);
        Connection conn = store.getConnection();
        ClassMapping mapping = store.getConfiguration().getMappingRepositoryInstance().getMapping(RuntimeTest1.class, null, true);
        FieldMapping fm = mapping.getFieldMapping("stringField");
        String tableName = store.getConfiguration().getDBDictionaryInstance().getFullName(fm.getTable(), false);
        String colName = fm.getColumns()[0].getName();
        Statement st = conn.createStatement();
        ResultSet rs = st.executeQuery("SELECT " + colName + " FROM " + tableName + " WHERE " + colName + " = 'a-name'");
        int count = 0;
        while (rs.next()) {
            ++count;
        }
        TestIncrementalJDBCFlushes.assertEquals((int)1, (int)count);
        this.rollbackTx(em);
        this.endEm(em);
    }

    private StoreManager getStoreManager(EntityManager em, boolean innermost) {
        DelegatingStoreManager mgr = JPAFacadeHelper.toBroker((EntityManager)em).getStoreManager();
        if (innermost) {
            return mgr.getInnermostDelegate();
        }
        return mgr;
    }

    private Map getProps() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("openjpa.DataCache", "true");
        props.put("openjpa.RemoteCommitProvider", "sjvm");
        props.put("openjpa.FlushBeforeQueries", "true");
        props.put("javax.jdo.option.IgnoreCache", "false");
        return props;
    }
}

